/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.LocalDate;
import org.killbill.billing.ObjectType;
import org.killbill.billing.overdue.OverdueTestSuiteNoDB;
import org.killbill.billing.overdue.config.DefaultOverdueCondition;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.payment.api.PaymentResponse;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.DefaultControlTag;
import org.killbill.billing.util.tag.DescriptiveTag;
import org.killbill.billing.util.tag.Tag;
import org.killbill.xmlloader.XMLLoader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCondition
extends OverdueTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testNumberOfUnpaidInvoicesEqualsOrExceeds() throws Exception {
        String xml = "<condition>\t<numberOfUnpaidInvoicesEqualsOrExceeds>1</numberOfUnpaidInvoicesEqualsOrExceeds></condition>";
        ByteArrayInputStream is = new ByteArrayInputStream("<condition>\t<numberOfUnpaidInvoicesEqualsOrExceeds>1</numberOfUnpaidInvoicesEqualsOrExceeds></condition>".getBytes());
        MockCondition c = (MockCondition)((Object)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, MockCondition.class));
        UUID unpaidInvoiceId = UUID.randomUUID();
        BillingState state0 = new BillingState(new UUID(0L, 1L), 0, BigDecimal.ZERO, new LocalDate(), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        BillingState state1 = new BillingState(new UUID(0L, 1L), 1, BigDecimal.ZERO, new LocalDate(), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        BillingState state2 = new BillingState(new UUID(0L, 1L), 2, BigDecimal.ZERO, new LocalDate(), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        Assert.assertTrue((!c.evaluate(state0, new LocalDate()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c.evaluate(state1, new LocalDate()));
        Assert.assertTrue((boolean)c.evaluate(state2, new LocalDate()));
    }

    @Test(groups={"fast"})
    public void testTotalUnpaidInvoiceBalanceEqualsOrExceeds() throws Exception {
        String xml = "<condition>\t<totalUnpaidInvoiceBalanceEqualsOrExceeds>100.00</totalUnpaidInvoiceBalanceEqualsOrExceeds></condition>";
        ByteArrayInputStream is = new ByteArrayInputStream("<condition>\t<totalUnpaidInvoiceBalanceEqualsOrExceeds>100.00</totalUnpaidInvoiceBalanceEqualsOrExceeds></condition>".getBytes());
        MockCondition c = (MockCondition)((Object)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, MockCondition.class));
        UUID unpaidInvoiceId = UUID.randomUUID();
        BillingState state0 = new BillingState(new UUID(0L, 1L), 0, BigDecimal.ZERO, new LocalDate(), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        BillingState state1 = new BillingState(new UUID(0L, 1L), 1, new BigDecimal("100.00"), new LocalDate(), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        BillingState state2 = new BillingState(new UUID(0L, 1L), 1, new BigDecimal("200.00"), new LocalDate(), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        Assert.assertTrue((!c.evaluate(state0, new LocalDate()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c.evaluate(state1, new LocalDate()));
        Assert.assertTrue((boolean)c.evaluate(state2, new LocalDate()));
    }

    @Test(groups={"fast"})
    public void testTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds() throws Exception {
        String xml = "<condition>\t<timeSinceEarliestUnpaidInvoiceEqualsOrExceeds><unit>DAYS</unit><number>10</number></timeSinceEarliestUnpaidInvoiceEqualsOrExceeds></condition>";
        ByteArrayInputStream is = new ByteArrayInputStream("<condition>\t<timeSinceEarliestUnpaidInvoiceEqualsOrExceeds><unit>DAYS</unit><number>10</number></timeSinceEarliestUnpaidInvoiceEqualsOrExceeds></condition>".getBytes());
        MockCondition c = (MockCondition)((Object)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, MockCondition.class));
        UUID unpaidInvoiceId = UUID.randomUUID();
        LocalDate now = new LocalDate();
        BillingState state0 = new BillingState(new UUID(0L, 1L), 0, BigDecimal.ZERO, null, unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        BillingState state1 = new BillingState(new UUID(0L, 1L), 1, new BigDecimal("100.00"), now.minusDays(10), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        BillingState state2 = new BillingState(new UUID(0L, 1L), 1, new BigDecimal("200.00"), now.minusDays(20), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        Assert.assertTrue((!c.evaluate(state0, now) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c.evaluate(state1, now));
        Assert.assertTrue((boolean)c.evaluate(state2, now));
    }

    @Test(groups={"fast"})
    public void testResponseForLastFailedPaymentIn() throws Exception {
        String xml = "<condition>\t<responseForLastFailedPaymentIn><response>INSUFFICIENT_FUNDS</response><response>DO_NOT_HONOR</response></responseForLastFailedPaymentIn></condition>";
        ByteArrayInputStream is = new ByteArrayInputStream("<condition>\t<responseForLastFailedPaymentIn><response>INSUFFICIENT_FUNDS</response><response>DO_NOT_HONOR</response></responseForLastFailedPaymentIn></condition>".getBytes());
        MockCondition c = (MockCondition)((Object)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, MockCondition.class));
        UUID unpaidInvoiceId = UUID.randomUUID();
        LocalDate now = new LocalDate();
        BillingState state0 = new BillingState(new UUID(0L, 1L), 0, BigDecimal.ZERO, null, unpaidInvoiceId, PaymentResponse.LOST_OR_STOLEN_CARD, new Tag[0]);
        BillingState state1 = new BillingState(new UUID(0L, 1L), 1, new BigDecimal("100.00"), now.minusDays(10), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[0]);
        BillingState state2 = new BillingState(new UUID(0L, 1L), 1, new BigDecimal("200.00"), now.minusDays(20), unpaidInvoiceId, PaymentResponse.DO_NOT_HONOR, new Tag[0]);
        Assert.assertTrue((!c.evaluate(state0, now) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c.evaluate(state1, now));
        Assert.assertTrue((boolean)c.evaluate(state2, now));
    }

    @Test(groups={"fast"})
    public void testHasControlTag() throws Exception {
        String xml = "<condition>\t<controlTagInclusion>OVERDUE_ENFORCEMENT_OFF</controlTagInclusion></condition>";
        ByteArrayInputStream is = new ByteArrayInputStream("<condition>\t<controlTagInclusion>OVERDUE_ENFORCEMENT_OFF</controlTagInclusion></condition>".getBytes());
        MockCondition c = (MockCondition)((Object)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, MockCondition.class));
        UUID unpaidInvoiceId = UUID.randomUUID();
        LocalDate now = new LocalDate();
        ObjectType objectType = ObjectType.BUNDLE;
        UUID objectId = new UUID(0L, 1L);
        BillingState state0 = new BillingState(objectId, 0, BigDecimal.ZERO, null, unpaidInvoiceId, PaymentResponse.LOST_OR_STOLEN_CARD, new Tag[]{new DefaultControlTag(ControlTagType.AUTO_INVOICING_OFF, objectType, objectId, this.clock.getUTCNow()), new DescriptiveTag(UUID.randomUUID(), objectType, objectId, this.clock.getUTCNow())});
        BillingState state1 = new BillingState(objectId, 1, new BigDecimal("100.00"), now.minusDays(10), unpaidInvoiceId, PaymentResponse.INSUFFICIENT_FUNDS, new Tag[]{new DefaultControlTag(ControlTagType.OVERDUE_ENFORCEMENT_OFF, objectType, objectId, this.clock.getUTCNow())});
        BillingState state2 = new BillingState(objectId, 1, new BigDecimal("200.00"), now.minusDays(20), unpaidInvoiceId, PaymentResponse.DO_NOT_HONOR, new Tag[]{new DefaultControlTag(ControlTagType.OVERDUE_ENFORCEMENT_OFF, objectType, objectId, this.clock.getUTCNow()), new DefaultControlTag(ControlTagType.AUTO_INVOICING_OFF, objectType, objectId, this.clock.getUTCNow()), new DescriptiveTag(UUID.randomUUID(), objectType, objectId, this.clock.getUTCNow())});
        Assert.assertTrue((!c.evaluate(state0, now) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c.evaluate(state1, now));
        Assert.assertTrue((boolean)c.evaluate(state2, now));
    }

    @XmlRootElement(name="condition")
    private static class MockCondition
    extends DefaultOverdueCondition {
        private MockCondition() {
        }
    }
}

