/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.calculator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.overdue.OverdueTestSuiteNoDB;
import org.killbill.billing.overdue.calculator.BillingStateCalculator;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBillingStateCalculator
extends OverdueTestSuiteNoDB {
    protected LocalDate now;

    @Override
    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)DateTimeZone.UTC);
        Mockito.when((Object)this.accountApi.getAccountById((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)account);
    }

    public BillingStateCalculator createBSCalc() {
        this.now = new LocalDate();
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        invoices.add(this.createInvoice(this.now, BigDecimal.ZERO, null));
        invoices.add(this.createInvoice(this.now.plusDays(1), BigDecimal.TEN, null));
        invoices.add(this.createInvoice(this.now.plusDays(2), new BigDecimal("100.0"), null));
        Mockito.when((Object)this.invoiceApi.getUnpaidInvoicesByAccountId((UUID)Mockito.any(), (LocalDate)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn(invoices);
        return new BillingStateCalculator(this.invoiceApi, (Clock)this.clock, this.tagInternalApi){

            public BillingState calculateBillingState(ImmutableAccountData overdueable, InternalCallContext context) {
                return null;
            }
        };
    }

    public Invoice createInvoice(LocalDate date, BigDecimal balance, List<InvoiceItem> invoiceItems) {
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        Mockito.when((Object)invoice.getBalance()).thenReturn((Object)balance);
        Mockito.when((Object)invoice.getInvoiceDate()).thenReturn((Object)date);
        Mockito.when((Object)invoice.getInvoiceItems()).thenReturn(invoiceItems);
        Mockito.when((Object)invoice.getId()).thenReturn((Object)UUID.randomUUID());
        return invoice;
    }

    @Test(groups={"fast"})
    public void testUnpaidInvoices() {
        BillingStateCalculator calc = this.createBSCalc();
        SortedSet invoices = calc.unpaidInvoicesForAccount(new UUID(0L, 0L), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)invoices.size(), (int)3);
        Assert.assertEquals((int)BigDecimal.ZERO.compareTo(((Invoice)invoices.first()).getBalance()), (int)0);
        Assert.assertEquals((int)new BigDecimal("100.0").compareTo(((Invoice)invoices.last()).getBalance()), (int)0);
    }

    @Test(groups={"fast"})
    public void testSum() {
        BillingStateCalculator calc = this.createBSCalc();
        SortedSet invoices = calc.unpaidInvoicesForAccount(new UUID(0L, 0L), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)new BigDecimal("110.0").compareTo(calc.sumBalance(invoices)), (int)0);
    }

    @Test(groups={"fast"})
    public void testEarliest() {
        BillingStateCalculator calc = this.createBSCalc();
        SortedSet invoices = calc.unpaidInvoicesForAccount(new UUID(0L, 0L), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((Object)calc.earliest(invoices).getInvoiceDate(), (Object)this.now);
    }
}

