/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.caching;

import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.overdue.OverdueTestSuiteNoDB;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.xmlloader.UriAccessor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestEhCacheOverdueConfigCache
extends OverdueTestSuiteNoDB {
    private InternalTenantContext multiTenantContext;
    private InternalTenantContext otherMultiTenantContext;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.cacheControllerDispatcher.clearAll();
        this.multiTenantContext = (InternalTenantContext)Mockito.mock(InternalTenantContext.class);
        Mockito.when((Object)this.multiTenantContext.getAccountRecordId()).thenReturn((Object)456L);
        Mockito.when((Object)this.multiTenantContext.getTenantRecordId()).thenReturn((Object)99L);
        this.otherMultiTenantContext = (InternalTenantContext)Mockito.mock(InternalCallContext.class);
        Mockito.when((Object)this.otherMultiTenantContext.getAccountRecordId()).thenReturn((Object)123L);
        Mockito.when((Object)this.otherMultiTenantContext.getTenantRecordId()).thenReturn((Object)112233L);
    }

    @Test(groups={"fast"})
    public void testMissingDefaultOverdueConfig() throws OverdueApiException {
        this.overdueConfigCache.loadDefaultOverdueConfig((String)null);
        OverdueConfig result = this.overdueConfigCache.getOverdueConfig((InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.getOverdueStatesAccount().getStates().length, (int)1);
        Assert.assertTrue((boolean)result.getOverdueStatesAccount().getStates()[0].isClearState());
    }

    @Test(groups={"fast"})
    public void testDefaultOverdueConfig() throws OverdueApiException {
        this.overdueConfigCache.loadDefaultOverdueConfig(Resources.getResource((String)"OverdueConfig.xml").toExternalForm());
        OverdueConfig result = this.overdueConfigCache.getOverdueConfig((InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.getOverdueStatesAccount().getStates().length, (int)1);
        Assert.assertTrue((boolean)result.getOverdueStatesAccount().getStates()[0].isClearState());
        Assert.assertEquals((Object)this.overdueConfigCache.getOverdueConfig(this.multiTenantContext), (Object)result);
        Assert.assertEquals((Object)this.overdueConfigCache.getOverdueConfig(this.otherMultiTenantContext), (Object)result);
        Assert.assertEquals((Object)this.overdueConfigCache.getOverdueConfig((InternalTenantContext)Mockito.mock(InternalTenantContext.class)), (Object)result);
        Assert.assertEquals((Object)this.overdueConfigCache.getOverdueConfig((InternalTenantContext)Mockito.mock(InternalCallContext.class)), (Object)result);
    }

    @Test(groups={"fast"})
    public void testExistingTenantOverdue() throws OverdueApiException, URISyntaxException, IOException {
        InternalCallContext differentMultiTenantContext = (InternalCallContext)Mockito.mock(InternalCallContext.class);
        Mockito.when((Object)differentMultiTenantContext.getTenantRecordId()).thenReturn((Object)55667788L);
        final AtomicBoolean shouldThrow = new AtomicBoolean(false);
        final Long multiTenantRecordId = this.multiTenantContext.getTenantRecordId();
        final Long otherMultiTenantRecordId = this.otherMultiTenantContext.getTenantRecordId();
        InputStream tenantInputOverdueConfig = UriAccessor.accessUri((URI)new URI(Resources.getResource((String)"OverdueConfig2.xml").toExternalForm()));
        final String tenantOverdueConfigXML = CharStreams.toString((Readable)new InputStreamReader(tenantInputOverdueConfig, "UTF-8"));
        InputStream otherTenantInputOverdueConfig = UriAccessor.accessUri((URI)new URI(Resources.getResource((String)"OverdueConfig.xml").toExternalForm()));
        final String otherTenantOverdueConfigXML = CharStreams.toString((Readable)new InputStreamReader(otherTenantInputOverdueConfig, "UTF-8"));
        Mockito.when((Object)this.tenantInternalApi.getTenantOverdueConfig((InternalTenantContext)Mockito.any(InternalTenantContext.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                if (shouldThrow.get()) {
                    throw new RuntimeException();
                }
                InternalTenantContext internalContext = (InternalTenantContext)invocation.getArguments()[0];
                if (multiTenantRecordId.equals(internalContext.getTenantRecordId())) {
                    return tenantOverdueConfigXML;
                }
                if (otherMultiTenantRecordId.equals(internalContext.getTenantRecordId())) {
                    return otherTenantOverdueConfigXML;
                }
                return null;
            }
        });
        OverdueConfig differentResult = this.overdueConfigCache.getOverdueConfig((InternalTenantContext)differentMultiTenantContext);
        Assert.assertNotNull((Object)differentResult);
        Assert.assertEquals((int)differentResult.getOverdueStatesAccount().getStates().length, (int)1);
        Assert.assertTrue((boolean)differentResult.getOverdueStatesAccount().getStates()[0].isClearState());
        shouldThrow.set(true);
        differentResult = this.overdueConfigCache.getOverdueConfig((InternalTenantContext)differentMultiTenantContext);
        Assert.assertNotNull((Object)differentResult);
        Assert.assertEquals((int)differentResult.getOverdueStatesAccount().getStates().length, (int)1);
        Assert.assertTrue((boolean)differentResult.getOverdueStatesAccount().getStates()[0].isClearState());
        shouldThrow.set(false);
        this.overdueConfigCache.loadDefaultOverdueConfig(Resources.getResource((String)"OverdueConfig.xml").toExternalForm());
        OverdueConfig result = this.overdueConfigCache.getOverdueConfig(this.multiTenantContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.getOverdueStatesAccount().getStates().length, (int)1);
        Assert.assertFalse((boolean)result.getOverdueStatesAccount().getStates()[0].isClearState());
        OverdueConfig otherResult = this.overdueConfigCache.getOverdueConfig(this.otherMultiTenantContext);
        Assert.assertNotNull((Object)otherResult);
        Assert.assertEquals((int)otherResult.getOverdueStatesAccount().getStates().length, (int)1);
        Assert.assertTrue((boolean)otherResult.getOverdueStatesAccount().getStates()[0].isClearState());
        shouldThrow.set(true);
        OverdueConfig result2 = this.overdueConfigCache.getOverdueConfig(this.multiTenantContext);
        Assert.assertEquals((Object)result2, (Object)result);
        InternalCallContext sameMultiTenantContext = (InternalCallContext)Mockito.mock(InternalCallContext.class);
        Mockito.when((Object)sameMultiTenantContext.getAccountRecordId()).thenReturn((Object)9102L);
        Mockito.when((Object)sameMultiTenantContext.getTenantRecordId()).thenReturn((Object)multiTenantRecordId);
        Assert.assertEquals((Object)this.overdueConfigCache.getOverdueConfig((InternalTenantContext)sameMultiTenantContext), (Object)result);
        Assert.assertEquals((Object)this.overdueConfigCache.getOverdueConfig(this.otherMultiTenantContext), (Object)otherResult);
    }
}

