/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.applicator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.events.OverdueChangeInternalEvent;
import org.killbill.billing.overdue.OverdueTestSuiteWithEmbeddedDB;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.DefaultOverdueStatesAccount;
import org.killbill.billing.overdue.config.api.OverdueStateSet;
import org.killbill.xmlloader.XMLLoader;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOverdueStateApplicator
extends OverdueTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testApplicator() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(this.testOverdueHelper.getConfigXml().getBytes());
        DefaultOverdueConfig config = (DefaultOverdueConfig)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, DefaultOverdueConfig.class);
        ImmutableAccountData account = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)account.getId()).thenReturn((Object)UUID.randomUUID());
        DefaultOverdueStatesAccount overdueStateSet = config.getOverdueStatesAccount();
        OverdueState clearState = config.getOverdueStatesAccount().findState("__KILLBILL__CLEAR__OVERDUE_STATE__");
        OverdueState state = config.getOverdueStatesAccount().findState("OD1");
        this.applicator.apply(this.clock.getUTCNow(), (OverdueStateSet)overdueStateSet, null, account, clearState, state, (InternalCallContext)this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        this.checkBussEvent("OD1");
        state = config.getOverdueStatesAccount().findState("OD2");
        this.applicator.apply(this.clock.getUTCNow(), (OverdueStateSet)overdueStateSet, null, account, clearState, state, (InternalCallContext)this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        this.checkBussEvent("OD2");
        state = config.getOverdueStatesAccount().findState("OD3");
        this.applicator.apply(this.clock.getUTCNow(), (OverdueStateSet)overdueStateSet, null, account, clearState, state, (InternalCallContext)this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        this.checkBussEvent("OD3");
    }

    private void checkBussEvent(String state) throws Exception {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                List<OverdueChangeInternalEvent> events = TestOverdueStateApplicator.this.listener.getEventsReceived();
                return events.size() == 1;
            }
        });
        List<OverdueChangeInternalEvent> events = this.listener.getEventsReceived();
        Assert.assertEquals((int)1, (int)events.size());
        Assert.assertEquals((String)state, (String)events.get(0).getNextOverdueStateName());
        this.listener.clearEventsReceived();
    }
}

