/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultDuration
extends ValidatingConfig<DefaultOverdueConfig>
implements Duration {
    @XmlElement(required=true)
    private TimeUnit unit;
    @XmlElement(required=false)
    private Integer number = -1;

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int getNumber() {
        return this.number;
    }

    public DateTime addToDateTime(DateTime dateTime) {
        if (this.number == null && this.unit != TimeUnit.UNLIMITED) {
            return dateTime;
        }
        switch (this.unit) {
            case DAYS: {
                return dateTime.plusDays(this.number.intValue());
            }
            case WEEKS: {
                return dateTime.plusWeeks(this.number.intValue());
            }
            case MONTHS: {
                return dateTime.plusMonths(this.number.intValue());
            }
            case YEARS: {
                return dateTime.plusYears(this.number.intValue());
            }
        }
        throw new IllegalStateException("Unexpected duration unit " + this.unit);
    }

    public LocalDate addToLocalDate(LocalDate localDate) {
        if (this.number == null && this.unit != TimeUnit.UNLIMITED) {
            return localDate;
        }
        switch (this.unit) {
            case DAYS: {
                return localDate.plusDays(this.number.intValue());
            }
            case WEEKS: {
                return localDate.plusWeeks(this.number.intValue());
            }
            case MONTHS: {
                return localDate.plusMonths(this.number.intValue());
            }
            case YEARS: {
                return localDate.plusYears(this.number.intValue());
            }
        }
        throw new IllegalStateException("Unexpected duration unit " + this.unit);
    }

    public Period toJodaPeriod() {
        if (this.number == null && this.unit != TimeUnit.UNLIMITED) {
            return new Period();
        }
        switch (this.unit) {
            case DAYS: {
                return new Period().withDays(this.number.intValue());
            }
            case WEEKS: {
                return new Period().withWeeks(this.number.intValue());
            }
            case MONTHS: {
                return new Period().withMonths(this.number.intValue());
            }
            case YEARS: {
                return new Period().withYears(this.number.intValue());
            }
        }
        throw new IllegalStateException("Unexpected duration unit " + this.unit);
    }

    public ValidationErrors validate(DefaultOverdueConfig catalog, ValidationErrors errors) {
        return errors;
    }

    public DefaultDuration setUnit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public DefaultDuration setNumber(Integer number) {
        this.number = number;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDuration{");
        sb.append("unit=").append(this.unit);
        sb.append(", number=").append(this.number);
        sb.append('}');
        return sb.toString();
    }
}

