/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.caching;

import com.google.inject.Inject;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.tenant.api.TenantKV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueCacheInvalidationCallback
implements TenantInternalApi.CacheInvalidationCallback {
    private static final Logger log = LoggerFactory.getLogger(OverdueCacheInvalidationCallback.class);
    private final OverdueConfigCache overdueConfigCache;

    @Inject
    public OverdueCacheInvalidationCallback(OverdueConfigCache overdueConfigCache) {
        this.overdueConfigCache = overdueConfigCache;
    }

    public void invalidateCache(TenantKV.TenantKey key, Object cookie, InternalTenantContext tenantContext) {
        log.info("Invalidate overdue cache for tenantRecordId='{}'", (Object)tenantContext.getTenantRecordId());
        this.overdueConfigCache.clearOverdueConfig(tenantContext);
    }
}

