/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.caching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.cache.TenantOverdueConfigCacheLoader;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.xmlloader.XMLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheOverdueConfigCache
implements OverdueConfigCache {
    private static final Logger log = LoggerFactory.getLogger(EhCacheOverdueConfigCache.class);
    private final CacheController<Long, OverdueConfig> cacheController;
    private final CacheLoaderArgument cacheLoaderArgument;
    private OverdueConfig defaultOverdueConfig;

    @Inject
    public EhCacheOverdueConfigCache(CacheControllerDispatcher cacheControllerDispatcher) {
        this.cacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_OVERDUE_CONFIG);
        this.cacheLoaderArgument = this.initializeCacheLoaderArgument();
        try {
            URI noOverdueConfigURI = new URI("NoOverdueConfig.xml");
            this.defaultOverdueConfig = (OverdueConfig)XMLLoader.getObjectFromUri((URI)noOverdueConfigURI, DefaultOverdueConfig.class);
        }
        catch (Exception e) {
            this.defaultOverdueConfig = new DefaultOverdueConfig();
            log.error("Exception loading NoOverdueConfig - should never happen!", (Throwable)e);
        }
    }

    public void loadDefaultOverdueConfig(@Nullable String configURI) throws OverdueApiException {
        boolean missingOrCorruptedDefaultConfig;
        try {
            if (configURI == null || configURI.isEmpty()) {
                missingOrCorruptedDefaultConfig = true;
            } else {
                URI u = new URI(configURI);
                this.defaultOverdueConfig = (OverdueConfig)XMLLoader.getObjectFromUri((URI)u, DefaultOverdueConfig.class);
                missingOrCorruptedDefaultConfig = this.defaultOverdueConfig == null;
            }
        }
        catch (Exception e) {
            missingOrCorruptedDefaultConfig = true;
            log.warn("Exception loading default overdue config from " + configURI, (Throwable)e);
        }
        if (missingOrCorruptedDefaultConfig) {
            log.warn("Overdue system disabled: unable to load the overdue config from " + configURI);
        }
    }

    public void loadDefaultOverdueConfig(OverdueConfig config) throws OverdueApiException {
        this.defaultOverdueConfig = config;
    }

    public OverdueConfig getOverdueConfig(InternalTenantContext tenantContext) throws OverdueApiException {
        if (InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID.equals(tenantContext.getTenantRecordId())) {
            return this.defaultOverdueConfig;
        }
        try {
            OverdueConfig overdueConfig = (OverdueConfig)this.cacheController.get((Object)tenantContext.getTenantRecordId(), this.cacheLoaderArgument);
            return overdueConfig != null ? overdueConfig : this.defaultOverdueConfig;
        }
        catch (IllegalStateException e) {
            throw new OverdueApiException(ErrorCode.OVERDUE_INVALID_FOR_TENANT, new Object[]{tenantContext.getTenantRecordId()});
        }
    }

    public void clearOverdueConfig(InternalTenantContext tenantContext) {
        if (!InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID.equals(tenantContext.getTenantRecordId())) {
            this.cacheController.remove((Object)tenantContext.getTenantRecordId());
        }
    }

    private CacheLoaderArgument initializeCacheLoaderArgument() {
        TenantOverdueConfigCacheLoader.LoaderCallback loaderCallback = new TenantOverdueConfigCacheLoader.LoaderCallback(){

            public OverdueConfig loadOverdueConfig(String overdueConfigXML) throws OverdueApiException {
                ByteArrayInputStream overdueConfigStream = new ByteArrayInputStream(overdueConfigXML.getBytes());
                try {
                    URI uri = new URI("/overdueConfig");
                    DefaultOverdueConfig overdueConfig = (DefaultOverdueConfig)XMLLoader.getObjectFromStream((URI)uri, (InputStream)overdueConfigStream, DefaultOverdueConfig.class);
                    return overdueConfig;
                }
                catch (Exception e) {
                    throw new OverdueApiException(ErrorCode.OVERDUE_INVALID_FOR_TENANT, new Object[]{"Problem encountered loading overdue config ", e});
                }
            }
        };
        Object[] args = new Object[]{loaderCallback};
        ObjectType irrelevant = null;
        InternalTenantContext notUsed = null;
        return new CacheLoaderArgument(irrelevant, args, notUsed);
    }
}

