/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.applicator;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.EntitlementInternalApi;
import org.killbill.billing.entitlement.api.BlockingApiException;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.events.OverdueChangeInternalEvent;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueCancellationPolicy;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.applicator.DefaultOverdueChangeEvent;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.overdue.config.api.OverdueException;
import org.killbill.billing.overdue.config.api.OverdueStateSet;
import org.killbill.billing.overdue.notification.OverdueCheckNotificationKey;
import org.killbill.billing.overdue.notification.OverduePoster;
import org.killbill.billing.tag.TagInternalApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverdueStateApplicator {
    private static final Logger log = LoggerFactory.getLogger(OverdueStateApplicator.class);
    private final BlockingInternalApi blockingApi;
    private final OverduePoster checkPoster;
    private final PersistentBus bus;
    private final AccountInternalApi accountApi;
    private final EntitlementApi entitlementApi;
    private final EntitlementInternalApi entitlementInternalApi;
    private final TagInternalApi tagApi;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public OverdueStateApplicator(BlockingInternalApi accessApi, AccountInternalApi accountApi, EntitlementApi entitlementApi, EntitlementInternalApi entitlementInternalApi, @Named(value="overdueNotifierCheck") OverduePoster checkPoster, PersistentBus bus, TagInternalApi tagApi, InternalCallContextFactory internalCallContextFactory) {
        this.blockingApi = accessApi;
        this.accountApi = accountApi;
        this.entitlementApi = entitlementApi;
        this.entitlementInternalApi = entitlementInternalApi;
        this.checkPoster = checkPoster;
        this.tagApi = tagApi;
        this.internalCallContextFactory = internalCallContextFactory;
        this.bus = bus;
    }

    public void apply(DateTime effectiveDate, OverdueStateSet overdueStateSet, BillingState billingState, ImmutableAccountData account, OverdueState previousOverdueState, OverdueState nextOverdueState, InternalCallContext context) throws OverdueException, OverdueApiException {
        OverdueChangeInternalEvent event;
        boolean conditionForNextNotfication;
        if (this.isAccountTaggedWith_OVERDUE_ENFORCEMENT_OFF(context)) {
            log.debug("OverdueStateApplicator: apply returns because account (recordId={}) is set with OVERDUE_ENFORCEMENT_OFF", (Object)context.getAccountRecordId());
            return;
        }
        log.debug("OverdueStateApplicator: time={}, previousState={}, nextState={}, billingState={}", new Object[]{effectiveDate, previousOverdueState, nextOverdueState, billingState});
        OverdueState firstOverdueState = overdueStateSet.getFirstState();
        boolean bl = conditionForNextNotfication = !nextOverdueState.isClearState() || firstOverdueState != null && billingState != null && billingState.getDateOfEarliestUnpaidInvoice() != null;
        if (conditionForNextNotfication) {
            Period reevaluationInterval = this.getReevaluationInterval(overdueStateSet, nextOverdueState);
            if (reevaluationInterval == null) {
                log.debug("OverdueStateApplicator <notificationQ>: missing InitialReevaluationInterval from config, NOT inserting notification for account {}", (Object)account.getId());
            } else {
                log.debug("OverdueStateApplicator <notificationQ>: inserting notification for account={}, time={}", (Object)account.getId(), (Object)effectiveDate.plus((ReadablePeriod)reevaluationInterval));
                this.createFutureNotification(account, effectiveDate.plus((ReadablePeriod)reevaluationInterval), context);
            }
        } else if (nextOverdueState.isClearState()) {
            this.clearFutureNotification(account, context);
        }
        if (previousOverdueState.getName().equals(nextOverdueState.getName())) {
            log.debug("OverdueStateApplicator is no-op: previousState={}, nextState={}", (Object)previousOverdueState, (Object)nextOverdueState);
            return;
        }
        this.cancelSubscriptionsIfRequired(effectiveDate, account, nextOverdueState, context);
        this.avoid_extra_credit_by_toggling_AUTO_INVOICE_OFF(account, previousOverdueState, nextOverdueState, context);
        this.storeNewState(effectiveDate, account, nextOverdueState, context);
        try {
            event = this.createOverdueEvent(account, previousOverdueState.getName(), nextOverdueState.getName(), this.isBlockBillingTransition(previousOverdueState, nextOverdueState), this.isUnblockBillingTransition(previousOverdueState, nextOverdueState), context);
        }
        catch (BlockingApiException e) {
            log.warn("Failed to create OverdueChangeInternalEvent for accountId='{}'", (Object)account.getId(), (Object)e);
            return;
        }
        try {
            this.bus.post((BusEvent)event);
        }
        catch (Exception e) {
            log.warn("Failed to post event {}", (Object)event, (Object)e);
        }
    }

    private Period getReevaluationInterval(OverdueStateSet overdueStateSet, OverdueState nextOverdueState) throws OverdueException {
        try {
            if (nextOverdueState.isClearState()) {
                return overdueStateSet.getInitialReevaluationInterval();
            }
            return nextOverdueState.getAutoReevaluationInterval().toJodaPeriod();
        }
        catch (OverdueApiException e) {
            if (e.getCode() == ErrorCode.OVERDUE_NO_REEVALUATION_INTERVAL.getCode()) {
                return null;
            }
            throw new OverdueException((BillingExceptionBase)e);
        }
    }

    private void avoid_extra_credit_by_toggling_AUTO_INVOICE_OFF(ImmutableAccountData account, OverdueState previousOverdueState, OverdueState nextOverdueState, InternalCallContext context) throws OverdueApiException {
        if (this.isBlockBillingTransition(previousOverdueState, nextOverdueState)) {
            this.set_AUTO_INVOICE_OFF_on_blockedBilling(account.getId(), context);
        } else if (this.isUnblockBillingTransition(previousOverdueState, nextOverdueState)) {
            this.remove_AUTO_INVOICE_OFF_on_clear(account.getId(), context);
        }
    }

    public void clear(DateTime effectiveDate, ImmutableAccountData account, OverdueState previousOverdueState, OverdueState clearState, InternalCallContext context) throws OverdueException {
        OverdueChangeInternalEvent event;
        log.debug("OverdueStateApplicator:clear : time = " + effectiveDate + ", previousState = " + previousOverdueState.getName());
        this.storeNewState(effectiveDate, account, clearState, context);
        this.clearFutureNotification(account, context);
        try {
            this.avoid_extra_credit_by_toggling_AUTO_INVOICE_OFF(account, previousOverdueState, clearState, context);
        }
        catch (OverdueApiException e) {
            throw new OverdueException((BillingExceptionBase)e);
        }
        try {
            event = this.createOverdueEvent(account, previousOverdueState.getName(), clearState.getName(), this.isBlockBillingTransition(previousOverdueState, clearState), this.isUnblockBillingTransition(previousOverdueState, clearState), context);
        }
        catch (BlockingApiException e) {
            log.warn("Failed to create OverdueChangeInternalEvent for accountId='{}'", (Object)account.getId(), (Object)e);
            return;
        }
        try {
            this.bus.post((BusEvent)event);
        }
        catch (Exception e) {
            log.warn("Failed to post event {}", (Object)event, (Object)e);
        }
    }

    private OverdueChangeInternalEvent createOverdueEvent(ImmutableAccountData overdueable, String previousOverdueStateName, String nextOverdueStateName, boolean isBlockedBilling, boolean isUnblockedBilling, InternalCallContext context) throws BlockingApiException {
        return new DefaultOverdueChangeEvent(overdueable.getId(), previousOverdueStateName, nextOverdueStateName, isBlockedBilling, isUnblockedBilling, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
    }

    protected void storeNewState(DateTime effectiveDate, ImmutableAccountData blockable, OverdueState nextOverdueState, InternalCallContext context) throws OverdueException {
        try {
            this.blockingApi.setBlockingState((BlockingState)new DefaultBlockingState(blockable.getId(), BlockingStateType.ACCOUNT, nextOverdueState.getName(), "overdue-service", this.blockChanges(nextOverdueState), this.blockEntitlement(nextOverdueState), this.blockBilling(nextOverdueState), effectiveDate), context);
        }
        catch (Exception e) {
            throw new OverdueException((Throwable)e, ErrorCode.OVERDUE_CAT_ERROR_ENCOUNTERED, new Object[]{blockable.getId(), blockable.getClass().getName()});
        }
    }

    private void set_AUTO_INVOICE_OFF_on_blockedBilling(UUID accountId, InternalCallContext context) throws OverdueApiException {
        try {
            this.tagApi.addTag(accountId, ObjectType.ACCOUNT, ControlTagType.AUTO_INVOICING_OFF.getId(), context);
        }
        catch (TagApiException e) {
            throw new OverdueApiException((BillingExceptionBase)e);
        }
    }

    private void remove_AUTO_INVOICE_OFF_on_clear(UUID accountId, InternalCallContext context) throws OverdueApiException {
        block2: {
            try {
                this.tagApi.removeTag(accountId, ObjectType.ACCOUNT, ControlTagType.AUTO_INVOICING_OFF.getId(), context);
            }
            catch (TagApiException e) {
                if (e.getCode() == ErrorCode.TAG_DOES_NOT_EXIST.getCode()) break block2;
                throw new OverdueApiException((BillingExceptionBase)e);
            }
        }
    }

    private boolean isBlockBillingTransition(OverdueState prevOverdueState, OverdueState nextOverdueState) {
        return !this.blockBilling(prevOverdueState) && this.blockBilling(nextOverdueState);
    }

    private boolean isUnblockBillingTransition(OverdueState prevOverdueState, OverdueState nextOverdueState) {
        return this.blockBilling(prevOverdueState) && !this.blockBilling(nextOverdueState);
    }

    private boolean blockChanges(OverdueState nextOverdueState) {
        return nextOverdueState.isBlockChanges() || nextOverdueState.isDisableEntitlementAndChangesBlocked();
    }

    private boolean blockBilling(OverdueState nextOverdueState) {
        return nextOverdueState.isDisableEntitlementAndChangesBlocked();
    }

    private boolean blockEntitlement(OverdueState nextOverdueState) {
        return nextOverdueState.isDisableEntitlementAndChangesBlocked();
    }

    protected void createFutureNotification(ImmutableAccountData account, DateTime timeOfNextCheck, InternalCallContext context) {
        OverdueCheckNotificationKey notificationKey = new OverdueCheckNotificationKey(account.getId());
        this.checkPoster.insertOverdueNotification(account.getId(), timeOfNextCheck, "overdue-check-queue", notificationKey, context);
    }

    protected void clearFutureNotification(ImmutableAccountData account, InternalCallContext context) {
        this.checkPoster.clearOverdueCheckNotifications(account.getId(), "overdue-check-queue", OverdueCheckNotificationKey.class, context);
    }

    private void cancelSubscriptionsIfRequired(DateTime effectiveDate, ImmutableAccountData account, OverdueState nextOverdueState, InternalCallContext context) throws OverdueException {
        if (nextOverdueState.getOverdueCancellationPolicy() == OverdueCancellationPolicy.NONE) {
            return;
        }
        CallContext callContext = this.internalCallContextFactory.createCallContext(context);
        try {
            BillingActionPolicy actionPolicy;
            switch (nextOverdueState.getOverdueCancellationPolicy()) {
                case END_OF_TERM: {
                    actionPolicy = BillingActionPolicy.END_OF_TERM;
                    break;
                }
                case IMMEDIATE: {
                    actionPolicy = BillingActionPolicy.IMMEDIATE;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected OverdueCancellationPolicy " + nextOverdueState.getOverdueCancellationPolicy());
                }
            }
            LinkedList<Entitlement> toBeCancelled = new LinkedList<Entitlement>();
            this.computeEntitlementsToCancel(account, toBeCancelled, callContext);
            try {
                this.entitlementInternalApi.cancel(toBeCancelled, context.toLocalDate(effectiveDate), actionPolicy, (Iterable)ImmutableList.of(), context);
            }
            catch (EntitlementApiException e) {
                throw new OverdueException((BillingExceptionBase)e);
            }
        }
        catch (EntitlementApiException e) {
            throw new OverdueException((BillingExceptionBase)e);
        }
    }

    private void computeEntitlementsToCancel(ImmutableAccountData account, List<Entitlement> result, CallContext context) throws EntitlementApiException {
        List allEntitlementsForAccountId = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)context);
        Collection allEntitlementsButAddonsForAccountId = Collections2.filter((Collection)allEntitlementsForAccountId, (Predicate)new Predicate<Entitlement>(){

            public boolean apply(Entitlement entitlement) {
                return !ProductCategory.ADD_ON.equals((Object)entitlement.getLastActiveProductCategory());
            }
        });
        result.addAll(allEntitlementsButAddonsForAccountId);
    }

    private boolean isAccountTaggedWith_OVERDUE_ENFORCEMENT_OFF(InternalCallContext context) throws OverdueException {
        try {
            UUID accountId = this.accountApi.getByRecordId(context.getAccountRecordId(), (InternalTenantContext)context);
            List accountTags = this.tagApi.getTags(accountId, ObjectType.ACCOUNT, (InternalTenantContext)context);
            for (Tag cur : accountTags) {
                if (!cur.getTagDefinitionId().equals(ControlTagType.OVERDUE_ENFORCEMENT_OFF.getId())) continue;
                return true;
            }
            return false;
        }
        catch (AccountApiException e) {
            throw new OverdueException((BillingExceptionBase)e);
        }
    }
}

