/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.api;

import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.overdue.api.OverdueApi;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.DefaultOverdueStatesAccount;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.xmlloader.XMLWriter;

public class DefaultOverdueApi
implements OverdueApi {
    private final OverdueConfigCache overdueConfigCache;
    private final BlockingInternalApi blockingInternalApi;
    private final InternalCallContextFactory internalCallContextFactory;
    private final TenantUserApi tenantApi;

    @Inject
    public DefaultOverdueApi(OverdueConfigCache overdueConfigCache, TenantUserApi tenantApi, BlockingInternalApi blockingInternalApi, InternalCallContextFactory internalCallContextFactory) {
        this.overdueConfigCache = overdueConfigCache;
        this.tenantApi = tenantApi;
        this.blockingInternalApi = blockingInternalApi;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public OverdueConfig getOverdueConfig(TenantContext tenantContext) throws OverdueApiException {
        InternalTenantContext internalTenantContext = this.createInternalTenantContext(tenantContext);
        return this.overdueConfigCache.getOverdueConfig(internalTenantContext);
    }

    public void uploadOverdueConfig(String overdueXML, CallContext callContext) throws OverdueApiException {
        try {
            InternalTenantContext internalTenantContext = this.createInternalTenantContext((TenantContext)callContext);
            String tenantKey = TenantKV.TenantKey.OVERDUE_CONFIG.toString();
            if (!this.tenantApi.getTenantValuesForKey(tenantKey, (TenantContext)callContext).isEmpty()) {
                this.tenantApi.deleteTenantKey(tenantKey, callContext);
            }
            this.tenantApi.addTenantKeyValue(tenantKey, overdueXML, callContext);
            this.overdueConfigCache.clearOverdueConfig(internalTenantContext);
        }
        catch (TenantApiException e) {
            throw new OverdueApiException((BillingExceptionBase)e);
        }
    }

    public void uploadOverdueConfig(OverdueConfig overdueConfig, CallContext callContext) throws OverdueApiException {
        try {
            String overdueXML = XMLWriter.writeXML((Object)((DefaultOverdueConfig)overdueConfig), DefaultOverdueConfig.class);
            this.uploadOverdueConfig(overdueXML, callContext);
        }
        catch (Exception e) {
            throw new OverdueApiException(ErrorCode.OVERDUE_INVALID_FOR_TENANT, new Object[]{callContext.getTenantId()});
        }
    }

    public OverdueState getOverdueStateFor(UUID accountId, TenantContext tenantContext) throws OverdueApiException {
        InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContext(accountId, tenantContext);
        BlockingState blockingStateForService = this.blockingInternalApi.getBlockingStateForService(accountId, BlockingStateType.ACCOUNT, "overdue-service", internalTenantContext);
        String stateName = blockingStateForService != null ? blockingStateForService.getStateName() : "__KILLBILL__CLEAR__OVERDUE_STATE__";
        OverdueConfig overdueConfig = this.overdueConfigCache.getOverdueConfig(internalTenantContext);
        DefaultOverdueStatesAccount states = ((DefaultOverdueConfig)overdueConfig).getOverdueStatesAccount();
        return states.findState(stateName);
    }

    private InternalTenantContext createInternalTenantContext(TenantContext tenantContext) {
        return this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(tenantContext);
    }
}

