/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import com.google.inject.Inject;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.overdue.OverdueProperties;
import org.killbill.billing.overdue.listener.OverdueDispatcher;
import org.killbill.billing.overdue.notification.DefaultOverdueNotifierBase;
import org.killbill.billing.overdue.notification.OverdueAsyncBusNotificationKey;
import org.killbill.billing.overdue.notification.OverdueCheckNotifier;
import org.killbill.billing.overdue.notification.OverdueNotifier;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueAsyncBusNotifier
extends DefaultOverdueNotifierBase
implements OverdueNotifier {
    private static final Logger log = LoggerFactory.getLogger(OverdueCheckNotifier.class);
    public static final String OVERDUE_ASYNC_BUS_NOTIFIER_QUEUE = "overdue-async-bus-queue";

    @Inject
    public OverdueAsyncBusNotifier(NotificationQueueService notificationQueueService, OverdueProperties config, InternalCallContextFactory internalCallContextFactory, OverdueDispatcher dispatcher) {
        super(notificationQueueService, config, internalCallContextFactory, dispatcher);
    }

    public String getQueueName() {
        return OVERDUE_ASYNC_BUS_NOTIFIER_QUEUE;
    }

    public void handleReadyNotification(NotificationEvent notificationKey, DateTime eventDate, UUID userToken, Long accountRecordId, Long tenantRecordId) {
        try {
            if (!(notificationKey instanceof OverdueAsyncBusNotificationKey)) {
                log.error("Overdue service received Unexpected notificationKey {}", (Object)notificationKey.getClass().getName());
                return;
            }
            OverdueAsyncBusNotificationKey key = (OverdueAsyncBusNotificationKey)notificationKey;
            switch (key.getAction()) {
                case CLEAR: {
                    this.dispatcher.clearOverdueForAccount(key.getUuidKey(), eventDate, this.createCallContext(userToken, accountRecordId, tenantRecordId));
                    break;
                }
                case REFRESH: {
                    this.dispatcher.processOverdueForAccount(key.getUuidKey(), eventDate, this.createCallContext(userToken, accountRecordId, tenantRecordId));
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected action " + (Object)((Object)key.getAction()) + " for account " + key.getUuidKey());
                }
            }
        }
        catch (IllegalArgumentException e) {
            log.error("The key returned from the queue overdue-async-bus-queue does not contain a valid UUID", (Throwable)e);
        }
    }
}

