/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.listener;

import com.google.inject.Inject;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.overdue.wrapper.OverdueWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueDispatcher {
    Logger log = LoggerFactory.getLogger(OverdueDispatcher.class);
    private final OverdueWrapperFactory factory;

    @Inject
    public OverdueDispatcher(OverdueWrapperFactory factory) {
        this.factory = factory;
    }

    public void processOverdueForAccount(UUID accountId, DateTime effectiveDate, InternalCallContext context) {
        this.processOverdue(accountId, effectiveDate, context);
    }

    public void clearOverdueForAccount(UUID accountId, DateTime effectiveDate, InternalCallContext context) {
        this.clearOverdue(accountId, effectiveDate, context);
    }

    private void processOverdue(UUID accountId, DateTime effectiveDate, InternalCallContext context) {
        try {
            this.factory.createOverdueWrapperFor(accountId, (InternalTenantContext)context).refresh(effectiveDate, context);
        }
        catch (BillingExceptionBase e) {
            this.log.warn("Error processing Overdue for accountId='{}'", (Object)accountId, (Object)e);
        }
    }

    private void clearOverdue(UUID accountId, DateTime effectiveDate, InternalCallContext context) {
        try {
            this.factory.createOverdueWrapperFor(accountId, (InternalTenantContext)context).clear(effectiveDate, context);
        }
        catch (BillingExceptionBase e) {
            this.log.warn("Error processing Overdue for accountId='{}'", (Object)accountId, (Object)e);
        }
    }
}

