/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.glue;

import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.killbill.billing.glue.OverdueModule;
import org.killbill.billing.overdue.OverdueProperties;
import org.killbill.billing.overdue.OverdueService;
import org.killbill.billing.overdue.api.DefaultOverdueApi;
import org.killbill.billing.overdue.api.OverdueApi;
import org.killbill.billing.overdue.applicator.OverdueEmailGenerator;
import org.killbill.billing.overdue.applicator.formatters.DefaultOverdueEmailFormatterFactory;
import org.killbill.billing.overdue.applicator.formatters.OverdueEmailFormatterFactory;
import org.killbill.billing.overdue.caching.EhCacheOverdueConfigCache;
import org.killbill.billing.overdue.caching.OverdueCacheInvalidationCallback;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.overdue.listener.OverdueListener;
import org.killbill.billing.overdue.notification.OverdueAsyncBusNotifier;
import org.killbill.billing.overdue.notification.OverdueAsyncBusPoster;
import org.killbill.billing.overdue.notification.OverdueCheckNotifier;
import org.killbill.billing.overdue.notification.OverdueCheckPoster;
import org.killbill.billing.overdue.notification.OverdueNotifier;
import org.killbill.billing.overdue.notification.OverduePoster;
import org.killbill.billing.overdue.service.DefaultOverdueService;
import org.killbill.billing.overdue.wrapper.OverdueWrapperFactory;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.glue.KillBillModule;
import org.skife.config.ConfigurationObjectFactory;

public class DefaultOverdueModule
extends KillBillModule
implements OverdueModule {
    public static final String OVERDUE_INVALIDATION_CALLBACK = "overdueInvalidationCallback";
    public static final String OVERDUE_NOTIFIER_CHECK_NAMED = "overdueNotifierCheck";
    public static final String OVERDUE_NOTIFIER_ASYNC_BUS_NAMED = "overdueNotifierAsyncBus";

    public DefaultOverdueModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        this.installOverdueUserApi();
        this.installOverdueConfigCache();
        this.installOverdueService();
        this.installOverdueWrapperFactory();
        this.installOverdueEmail();
        OverdueProperties config = (OverdueProperties)new ConfigurationObjectFactory(this.skifeConfigSource).build(OverdueProperties.class);
        this.bind(OverdueProperties.class).toInstance((Object)config);
        this.bind(OverdueListener.class).asEagerSingleton();
        this.bind(OverdueNotifier.class).annotatedWith((Annotation)Names.named((String)OVERDUE_NOTIFIER_CHECK_NAMED)).to(OverdueCheckNotifier.class).asEagerSingleton();
        this.bind(OverdueNotifier.class).annotatedWith((Annotation)Names.named((String)OVERDUE_NOTIFIER_ASYNC_BUS_NAMED)).to(OverdueAsyncBusNotifier.class).asEagerSingleton();
        this.bind(OverduePoster.class).annotatedWith((Annotation)Names.named((String)OVERDUE_NOTIFIER_CHECK_NAMED)).to(OverdueCheckPoster.class).asEagerSingleton();
        this.bind(OverduePoster.class).annotatedWith((Annotation)Names.named((String)OVERDUE_NOTIFIER_ASYNC_BUS_NAMED)).to(OverdueAsyncBusPoster.class).asEagerSingleton();
    }

    protected void installOverdueService() {
        this.bind(OverdueService.class).to(DefaultOverdueService.class).asEagerSingleton();
    }

    protected void installOverdueWrapperFactory() {
        this.bind(OverdueWrapperFactory.class).asEagerSingleton();
    }

    protected void installOverdueEmail() {
        this.bind(OverdueEmailFormatterFactory.class).to(DefaultOverdueEmailFormatterFactory.class).asEagerSingleton();
        this.bind(OverdueEmailGenerator.class).asEagerSingleton();
    }

    public void installOverdueUserApi() {
        this.bind(OverdueApi.class).to(DefaultOverdueApi.class).asEagerSingleton();
    }

    public void installOverdueConfigCache() {
        this.bind(OverdueConfigCache.class).to(EhCacheOverdueConfigCache.class).asEagerSingleton();
        this.bind(TenantInternalApi.CacheInvalidationCallback.class).annotatedWith((Annotation)Names.named((String)OVERDUE_INVALIDATION_CALLBACK)).to(OverdueCacheInvalidationCallback.class).asEagerSingleton();
    }
}

