/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.DefaultOverdueState;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.overdue.config.api.OverdueStateSet;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class DefaultOverdueStateSet
extends ValidatingConfig<DefaultOverdueConfig>
implements OverdueStateSet {
    private static final Period ZERO_PERIOD = new Period();
    private final DefaultOverdueState clearState = new DefaultOverdueState().setName("__KILLBILL__CLEAR__OVERDUE_STATE__").setClearState(true);

    public abstract DefaultOverdueState[] getStates();

    public OverdueState findState(String stateName) throws OverdueApiException {
        if (stateName.equals("__KILLBILL__CLEAR__OVERDUE_STATE__")) {
            return this.clearState;
        }
        for (DefaultOverdueState state : this.getStates()) {
            if (!state.getName().equals(stateName)) continue;
            return state;
        }
        throw new OverdueApiException(ErrorCode.CAT_NO_SUCH_OVERDUE_STATE, new Object[]{stateName});
    }

    public DefaultOverdueState getClearState() throws OverdueApiException {
        return this.clearState;
    }

    public DefaultOverdueState calculateOverdueState(BillingState billingState, LocalDate now) throws OverdueApiException {
        for (DefaultOverdueState overdueState : this.getStates()) {
            if (overdueState.getConditionEvaluation() == null || !overdueState.getConditionEvaluation().evaluate(billingState, now)) continue;
            return overdueState;
        }
        return this.getClearState();
    }

    public ValidationErrors validate(DefaultOverdueConfig root, ValidationErrors errors) {
        block3: {
            for (DefaultOverdueState state : this.getStates()) {
                state.validate(root, errors);
            }
            try {
                this.getClearState();
            }
            catch (OverdueApiException e) {
                if (e.getCode() != ErrorCode.CAT_MISSING_CLEAR_STATE.getCode()) break block3;
                errors.add("Overdue state set is missing a clear state.", root.getURI(), ((Object)((Object)this)).getClass(), "");
            }
        }
        return errors;
    }

    public int size() {
        return this.getStates().length;
    }

    public OverdueState getFirstState() {
        return this.getStates()[this.size() - 1];
    }
}

