/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.overdue.ConditionEvaluation;
import org.killbill.billing.overdue.api.OverdueCondition;
import org.killbill.billing.overdue.config.DefaultDuration;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.payment.api.PaymentResponse;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultOverdueCondition
extends ValidatingConfig<DefaultOverdueConfig>
implements ConditionEvaluation,
OverdueCondition {
    @XmlElement(required=false, name="numberOfUnpaidInvoicesEqualsOrExceeds")
    private Integer numberOfUnpaidInvoicesEqualsOrExceeds;
    @XmlElement(required=false, name="totalUnpaidInvoiceBalanceEqualsOrExceeds")
    private BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds;
    @XmlElement(required=false, name="timeSinceEarliestUnpaidInvoiceEqualsOrExceeds")
    private DefaultDuration timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    @XmlElementWrapper(required=false, name="responseForLastFailedPaymentIn")
    @XmlElement(required=false, name="response")
    private PaymentResponse[] responseForLastFailedPayment;
    @XmlElement(required=false, name="controlTag")
    private ControlTagType controlTag;

    public boolean evaluate(BillingState state, LocalDate date) {
        LocalDate unpaidInvoiceTriggerDate = null;
        if (this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null && state.getDateOfEarliestUnpaidInvoice() != null) {
            unpaidInvoiceTriggerDate = state.getDateOfEarliestUnpaidInvoice().plus((ReadablePeriod)this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds.toJodaPeriod());
        }
        return !(this.numberOfUnpaidInvoicesEqualsOrExceeds != null && state.getNumberOfUnpaidInvoices() < this.numberOfUnpaidInvoicesEqualsOrExceeds || this.totalUnpaidInvoiceBalanceEqualsOrExceeds != null && this.totalUnpaidInvoiceBalanceEqualsOrExceeds.compareTo(state.getBalanceOfUnpaidInvoices()) > 0 || this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null && (unpaidInvoiceTriggerDate == null || unpaidInvoiceTriggerDate.isAfter((ReadablePartial)date)) || this.responseForLastFailedPayment != null && !this.responseIsIn(state.getResponseForLastFailedPayment(), this.responseForLastFailedPayment) || this.controlTag != null && !this.isTagIn(this.controlTag, state.getTags()));
    }

    private boolean responseIsIn(PaymentResponse actualResponse, PaymentResponse[] responseForLastFailedPayment) {
        for (PaymentResponse response : responseForLastFailedPayment) {
            if (!response.equals((Object)actualResponse)) continue;
            return true;
        }
        return false;
    }

    private boolean isTagIn(ControlTagType tagType, Tag[] tags) {
        for (Tag t : tags) {
            if (!t.getTagDefinitionId().equals(tagType.getId())) continue;
            return true;
        }
        return false;
    }

    public ValidationErrors validate(DefaultOverdueConfig root, ValidationErrors errors) {
        return errors;
    }

    public void initialize(DefaultOverdueConfig root, URI uri) {
    }

    public Duration getTimeOffset() {
        if (this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null) {
            return this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
        }
        return new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(0);
    }

    public Integer getNumberOfUnpaidInvoicesEqualsOrExceeds() {
        return this.numberOfUnpaidInvoicesEqualsOrExceeds;
    }

    public BigDecimal getTotalUnpaidInvoiceBalanceEqualsOrExceeds() {
        return this.totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    public Duration getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds() {
        return this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    }

    public PaymentResponse[] getResponseForLastFailedPaymentIn() {
        return this.responseForLastFailedPayment;
    }

    public ControlTagType getControlTagType() {
        return this.controlTag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultOverdueCondition{");
        sb.append("numberOfUnpaidInvoicesEqualsOrExceeds=").append(this.numberOfUnpaidInvoicesEqualsOrExceeds);
        sb.append(", totalUnpaidInvoiceBalanceEqualsOrExceeds=").append(this.totalUnpaidInvoiceBalanceEqualsOrExceeds);
        sb.append(", timeSinceEarliestUnpaidInvoiceEqualsOrExceeds=").append((Object)this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds);
        sb.append(", responseForLastFailedPayment=").append(Arrays.toString(this.responseForLastFailedPayment));
        sb.append(", controlTag=").append(this.controlTag);
        sb.append('}');
        return sb.toString();
    }
}

