/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.applicator;

import com.google.inject.Inject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.applicator.formatters.OverdueEmailFormatterFactory;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.util.email.templates.TemplateEngine;
import org.killbill.billing.util.io.IOUtils;

public class OverdueEmailGenerator {
    private final TemplateEngine templateEngine;
    private final OverdueEmailFormatterFactory overdueEmailFormatterFactory;

    @Inject
    public OverdueEmailGenerator(TemplateEngine templateEngine, OverdueEmailFormatterFactory overdueEmailFormatterFactory) {
        this.templateEngine = templateEngine;
        this.overdueEmailFormatterFactory = overdueEmailFormatterFactory;
    }

    public String generateEmail(Account account, BillingState billingState, Account overdueable, OverdueState nextOverdueState) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("account", account);
        data.put("billingState", this.overdueEmailFormatterFactory.createBillingStateFormatter(billingState));
        data.put("overdueable", overdueable);
        data.put("nextOverdueState", nextOverdueState);
        FileInputStream input = new FileInputStream(nextOverdueState.getEmailNotification().getTemplateName());
        return this.templateEngine.executeTemplateText(IOUtils.toString((InputStream)input), data);
    }
}

