/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.wrapper;

import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.applicator.OverdueStateApplicator;
import org.killbill.billing.overdue.calculator.BillingStateCalculator;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.overdue.config.api.OverdueException;
import org.killbill.billing.overdue.config.api.OverdueStateSet;
import org.killbill.billing.util.globallocker.LockerType;
import org.killbill.clock.Clock;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.LockFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueWrapper {
    public static final String CLEAR_STATE_NAME = "__KILLBILL__CLEAR__OVERDUE_STATE__";
    private static final Logger log = LoggerFactory.getLogger(OverdueWrapper.class);
    private static final int MAX_LOCK_RETRIES = 50;
    private final ImmutableAccountData overdueable;
    private final BlockingInternalApi api;
    private final GlobalLocker locker;
    private final Clock clock;
    private final OverdueStateSet overdueStateSet;
    private final BillingStateCalculator billingStateCalcuator;
    private final OverdueStateApplicator overdueStateApplicator;

    public OverdueWrapper(ImmutableAccountData overdueable, BlockingInternalApi api, OverdueStateSet overdueStateSet, GlobalLocker locker, Clock clock, BillingStateCalculator billingStateCalcuator, OverdueStateApplicator overdueStateApplicator) {
        this.overdueable = overdueable;
        this.overdueStateSet = overdueStateSet;
        this.api = api;
        this.locker = locker;
        this.clock = clock;
        this.billingStateCalcuator = billingStateCalcuator;
        this.overdueStateApplicator = overdueStateApplicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverdueState refresh(InternalCallContext context) throws OverdueException, OverdueApiException {
        if (this.overdueStateSet.size() < 1) {
            return this.overdueStateSet.getClearState();
        }
        GlobalLock lock = null;
        try {
            lock = this.locker.lockWithNumberOfTries(LockerType.ACCNT_INV_PAY.toString(), this.overdueable.getId().toString(), 50);
            OverdueState overdueState = this.refreshWithLock(context);
            return overdueState;
        }
        catch (LockFailedException e) {
            log.warn("Failed to process overdue for accountId='{}'", (Object)this.overdueable.getId(), (Object)e);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return null;
    }

    private OverdueState refreshWithLock(InternalCallContext context) throws OverdueException, OverdueApiException {
        BillingState billingState = this.billingState((InternalTenantContext)context);
        BlockingState blockingStateForService = this.api.getBlockingStateForService(this.overdueable.getId(), BlockingStateType.ACCOUNT, "overdue-service", (InternalTenantContext)context);
        String previousOverdueStateName = blockingStateForService != null ? blockingStateForService.getStateName() : CLEAR_STATE_NAME;
        OverdueState currentOverdueState = this.overdueStateSet.findState(previousOverdueStateName);
        OverdueState nextOverdueState = this.overdueStateSet.calculateOverdueState(billingState, this.clock.getToday(billingState.getAccountTimeZone()));
        this.overdueStateApplicator.apply(this.overdueStateSet, billingState, this.overdueable, currentOverdueState, nextOverdueState, context);
        return nextOverdueState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(InternalCallContext context) throws OverdueException, OverdueApiException {
        GlobalLock lock = null;
        try {
            lock = this.locker.lockWithNumberOfTries(LockerType.ACCNT_INV_PAY.toString(), this.overdueable.getId().toString(), 50);
            this.clearWithLock(context);
        }
        catch (LockFailedException e) {
            log.warn("Failed to clear overdue for accountId='{}'", (Object)this.overdueable.getId(), (Object)e);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private void clearWithLock(InternalCallContext context) throws OverdueException, OverdueApiException {
        BlockingState blockingStateForService = this.api.getBlockingStateForService(this.overdueable.getId(), BlockingStateType.ACCOUNT, "overdue-service", (InternalTenantContext)context);
        String previousOverdueStateName = blockingStateForService != null ? blockingStateForService.getStateName() : CLEAR_STATE_NAME;
        OverdueState previousOverdueState = this.overdueStateSet.findState(previousOverdueStateName);
        this.overdueStateApplicator.clear(this.overdueable, previousOverdueState, this.overdueStateSet.getClearState(), context);
    }

    public BillingState billingState(InternalTenantContext context) throws OverdueException {
        return this.billingStateCalcuator.calculateBillingState(this.overdueable, context);
    }
}

