/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import com.google.inject.Inject;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.overdue.notification.DefaultOverduePosterBase;
import org.killbill.billing.overdue.notification.OverdueCheckNotificationKey;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.jdbi.v2.IDBI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverdueCheckPoster
extends DefaultOverduePosterBase {
    @Inject
    public OverdueCheckPoster(NotificationQueueService notificationQueueService, IDBI dbi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        super(notificationQueueService, dbi, clock, cacheControllerDispatcher, nonEntityDao, internalCallContextFactory);
    }

    @Override
    protected <T extends OverdueCheckNotificationKey> boolean cleanupFutureNotificationsFormTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, Collection<NotificationEventWithMetadata<T>> futureNotifications, DateTime futureNotificationTime, NotificationQueue overdueQueue) {
        boolean shouldInsertNewNotification = true;
        if (!futureNotifications.isEmpty()) {
            int minIndexToDeleteFrom;
            DateTime earliestExistingNotificationDate = futureNotifications.iterator().next().getEffectiveDate();
            if (earliestExistingNotificationDate.isBefore((ReadableInstant)futureNotificationTime)) {
                minIndexToDeleteFrom = 1;
                shouldInsertNewNotification = false;
            } else {
                minIndexToDeleteFrom = 0;
            }
            int index = 0;
            for (NotificationEventWithMetadata<T> cur : futureNotifications) {
                if (minIndexToDeleteFrom <= index) {
                    overdueQueue.removeNotificationFromTransaction(entitySqlDaoWrapperFactory.getHandle().getConnection(), cur.getRecordId());
                }
                ++index;
            }
        }
        return shouldInsertNewNotification;
    }
}

