/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import com.google.inject.Inject;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.overdue.OverdueProperties;
import org.killbill.billing.overdue.listener.OverdueDispatcher;
import org.killbill.billing.overdue.notification.DefaultOverdueNotifierBase;
import org.killbill.billing.overdue.notification.OverdueCheckNotificationKey;
import org.killbill.billing.overdue.notification.OverdueNotifier;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueCheckNotifier
extends DefaultOverdueNotifierBase
implements OverdueNotifier {
    private static final Logger log = LoggerFactory.getLogger(OverdueCheckNotifier.class);
    public static final String OVERDUE_CHECK_NOTIFIER_QUEUE = "overdue-check-queue";

    @Inject
    public OverdueCheckNotifier(NotificationQueueService notificationQueueService, OverdueProperties config, InternalCallContextFactory internalCallContextFactory, OverdueDispatcher dispatcher) {
        super(notificationQueueService, config, internalCallContextFactory, dispatcher);
    }

    public String getQueueName() {
        return OVERDUE_CHECK_NOTIFIER_QUEUE;
    }

    public void handleReadyNotification(NotificationEvent notificationKey, DateTime eventDate, UUID userToken, Long accountRecordId, Long tenantRecordId) {
        try {
            if (!(notificationKey instanceof OverdueCheckNotificationKey)) {
                log.error("Overdue service received Unexpected notificationKey {}", (Object)notificationKey.getClass().getName());
                return;
            }
            OverdueCheckNotificationKey key = (OverdueCheckNotificationKey)notificationKey;
            this.dispatcher.processOverdueForAccount(key.getUuidKey(), this.createCallContext(userToken, accountRecordId, tenantRecordId));
        }
        catch (IllegalArgumentException e) {
            log.error("The key returned from the NextBillingNotificationQueue is not a valid UUID", (Throwable)e);
        }
    }
}

