/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import org.joda.time.Period;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.overdue.ConditionEvaluation;
import org.killbill.billing.overdue.api.EmailNotification;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueCancellationPolicy;
import org.killbill.billing.overdue.api.OverdueCondition;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.config.DefaultDuration;
import org.killbill.billing.overdue.config.DefaultEmailNotification;
import org.killbill.billing.overdue.config.DefaultOverdueCondition;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultOverdueState
extends ValidatingConfig<DefaultOverdueConfig>
implements OverdueState {
    private static final int MAX_NAME_LENGTH = 50;
    @XmlElement(required=false, name="condition")
    private DefaultOverdueCondition condition;
    @XmlAttribute(required=true, name="name")
    @XmlID
    private String name;
    @XmlElement(required=false, name="externalMessage")
    private String externalMessage = "";
    @XmlElement(required=false, name="blockChanges")
    private Boolean blockChanges = false;
    @XmlElement(required=false, name="disableEntitlementAndChangesBlocked")
    private Boolean disableEntitlement = false;
    @XmlElement(required=false, name="subscriptionCancellationPolicy")
    private OverdueCancellationPolicy subscriptionCancellationPolicy = OverdueCancellationPolicy.NONE;
    @XmlElement(required=false, name="isClearState")
    private Boolean isClearState = false;
    @XmlElement(required=false, name="autoReevaluationInterval")
    private DefaultDuration autoReevaluationInterval;
    @XmlElement(required=false, name="enterStateEmailNotification")
    private DefaultEmailNotification enterStateEmailNotification;

    public ConditionEvaluation getConditionEvaluation() {
        return this.condition;
    }

    public OverdueCondition getOverdueCondition() {
        return this.condition;
    }

    public String getName() {
        return this.name;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    public boolean isBlockChanges() {
        return this.blockChanges != false || this.disableEntitlement != false;
    }

    public boolean isDisableEntitlementAndChangesBlocked() {
        return this.disableEntitlement;
    }

    public OverdueCancellationPolicy getOverdueCancellationPolicy() {
        return this.subscriptionCancellationPolicy;
    }

    public Period getAutoReevaluationInterval() throws OverdueApiException {
        if (this.autoReevaluationInterval == null || this.autoReevaluationInterval.getUnit() == TimeUnit.UNLIMITED || this.autoReevaluationInterval.getNumber() == 0) {
            throw new OverdueApiException(ErrorCode.OVERDUE_NO_REEVALUATION_INTERVAL, new Object[]{this.name});
        }
        return this.autoReevaluationInterval.toJodaPeriod();
    }

    protected DefaultOverdueState setName(String name) {
        this.name = name;
        return this;
    }

    protected DefaultOverdueState setClearState(boolean isClearState) {
        this.isClearState = isClearState;
        return this;
    }

    protected DefaultOverdueState setExternalMessage(String externalMessage) {
        this.externalMessage = externalMessage;
        return this;
    }

    protected DefaultOverdueState setDisableEntitlement(boolean cancel) {
        this.disableEntitlement = cancel;
        return this;
    }

    public DefaultOverdueState setSubscriptionCancellationPolicy(OverdueCancellationPolicy policy) {
        this.subscriptionCancellationPolicy = policy;
        return this;
    }

    protected DefaultOverdueState setBlockChanges(boolean cancel) {
        this.blockChanges = cancel;
        return this;
    }

    protected DefaultOverdueState setCondition(DefaultOverdueCondition condition) {
        this.condition = condition;
        return this;
    }

    public boolean isClearState() {
        return this.isClearState;
    }

    public ValidationErrors validate(DefaultOverdueConfig root, ValidationErrors errors) {
        if (this.name.length() > 50) {
            errors.add((Object)new ValidationError(String.format("Name of state '%s' exceeds the maximum length of %d", this.name, 50), root.getURI(), DefaultOverdueState.class, this.name));
        }
        return errors;
    }

    public EmailNotification getEmailNotification() {
        return this.enterStateEmailNotification;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultOverdueState{");
        sb.append("condition=").append((Object)this.condition);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", externalMessage='").append(this.externalMessage).append('\'');
        sb.append(", blockChanges=").append(this.blockChanges);
        sb.append(", disableEntitlement=").append(this.disableEntitlement);
        sb.append(", subscriptionCancellationPolicy=").append(this.subscriptionCancellationPolicy);
        sb.append(", isClearState=").append(this.isClearState);
        sb.append(", autoReevaluationInterval=").append((Object)this.autoReevaluationInterval);
        sb.append(", enterStateEmailNotification=").append(this.enterStateEmailNotification);
        sb.append('}');
        return sb.toString();
    }
}

