/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue;

import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceInternalApi;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.glue.TestOverdueModule;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.mockito.Mockito;
import org.testng.Assert;

public class TestOverdueHelper {
    private final String configXml = "<overdueConfig>   <accountOverdueStates>       <initialReevaluationInterval>           <unit>DAYS</unit><number>100</number>       </initialReevaluationInterval>       <state name=\"OD3\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>DAYS</unit><number>50</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD3</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>true</disableEntitlementAndChangesBlocked>       </state>       <state name=\"OD2\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>DAYS</unit><number>40</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD2</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>true</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>5</number>           </autoReevaluationInterval>       </state>       <state name=\"OD1\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>DAYS</unit><number>30</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD1</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>false</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>100</number>           </autoReevaluationInterval>       </state>   </accountOverdueStates></overdueConfig>";
    private final AccountInternalApi accountInternalApi;
    private final InvoiceInternalApi invoiceInternalApi;
    private final BlockingInternalApi blockingInternalApi;

    @Inject
    public TestOverdueHelper(AccountInternalApi accountInternalApi, InvoiceInternalApi invoiceInternalApi, BlockingInternalApi blockingInternalApi) {
        this.accountInternalApi = accountInternalApi;
        this.invoiceInternalApi = invoiceInternalApi;
        this.blockingInternalApi = blockingInternalApi;
    }

    public void checkStateApplied(OverdueState state) {
        BlockingState result = ((TestOverdueModule.ApplicatorBlockingApi)this.blockingInternalApi).getBlockingState();
        this.checkStateApplied(result, state);
    }

    public void checkStateApplied(BlockingState result, OverdueState state) {
        Assert.assertEquals((String)result.getStateName(), (String)state.getName());
        Assert.assertEquals((boolean)result.isBlockChange(), (boolean)state.isBlockChanges());
        Assert.assertEquals((boolean)result.isBlockEntitlement(), (boolean)state.isDisableEntitlementAndChangesBlocked());
        Assert.assertEquals((boolean)result.isBlockBilling(), (boolean)state.isDisableEntitlementAndChangesBlocked());
    }

    public ImmutableAccountData createImmutableAccountData(LocalDate dateOfLastUnPaidInvoice) throws SubscriptionBaseApiException, AccountApiException {
        UUID accountId = UUID.randomUUID();
        ImmutableAccountData account = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)account.getId()).thenReturn((Object)accountId);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)DateTimeZone.UTC);
        Mockito.when((Object)this.accountInternalApi.getImmutableAccountDataById((UUID)Mockito.eq((Object)account.getId()), (InternalTenantContext)Mockito.any())).thenReturn((Object)account);
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        Mockito.when((Object)invoice.getInvoiceDate()).thenReturn((Object)dateOfLastUnPaidInvoice);
        Mockito.when((Object)invoice.getBalance()).thenReturn((Object)BigDecimal.TEN);
        Mockito.when((Object)invoice.getId()).thenReturn((Object)UUID.randomUUID());
        InvoiceItem item = (InvoiceItem)Mockito.mock(InvoiceItem.class);
        ArrayList<InvoiceItem> items = new ArrayList<InvoiceItem>();
        items.add(item);
        Mockito.when((Object)invoice.getInvoiceItems()).thenReturn(items);
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        invoices.add(invoice);
        Mockito.when((Object)this.invoiceInternalApi.getUnpaidInvoicesByAccountId((UUID)Mockito.any(), (LocalDate)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn(invoices);
        return account;
    }

    public String getConfigXml() {
        return "<overdueConfig>   <accountOverdueStates>       <initialReevaluationInterval>           <unit>DAYS</unit><number>100</number>       </initialReevaluationInterval>       <state name=\"OD3\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>DAYS</unit><number>50</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD3</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>true</disableEntitlementAndChangesBlocked>       </state>       <state name=\"OD2\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>DAYS</unit><number>40</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD2</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>true</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>5</number>           </autoReevaluationInterval>       </state>       <state name=\"OD1\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>DAYS</unit><number>30</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD1</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>false</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>100</number>           </autoReevaluationInterval>       </state>   </accountOverdueStates></overdueConfig>";
    }
}

