/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.wrapper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.overdue.OverdueState;
import org.killbill.billing.overdue.OverdueTestSuiteWithEmbeddedDB;
import org.killbill.billing.overdue.config.OverdueConfig;
import org.killbill.billing.overdue.wrapper.OverdueWrapper;
import org.killbill.xmlloader.XMLLoader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOverdueWrapper
extends OverdueTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testWrapperBasic() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(this.testOverdueHelper.getConfigXml().getBytes());
        OverdueConfig config = (OverdueConfig)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, OverdueConfig.class);
        this.overdueWrapperFactory.setOverdueConfig(config);
        OverdueState state = config.getStateSet().findState("OD1");
        Account account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(31));
        OverdueWrapper wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account);
        wrapper.refresh(this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        state = config.getStateSet().findState("OD2");
        account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(41));
        wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account);
        wrapper.refresh(this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        state = config.getStateSet().findState("OD3");
        account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(51));
        wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account);
        wrapper.refresh(this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
    }

    @Test(groups={"slow"})
    public void testWrapperNoConfig() throws Exception {
        this.overdueWrapperFactory.setOverdueConfig(null);
        ByteArrayInputStream is = new ByteArrayInputStream(this.testOverdueHelper.getConfigXml().getBytes());
        OverdueConfig config = (OverdueConfig)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, OverdueConfig.class);
        OverdueState state = config.getStateSet().findState("__KILLBILL__CLEAR__OVERDUE_STATE__");
        Account account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(31));
        OverdueWrapper wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account);
        OverdueState result = wrapper.refresh(this.internalCallContext);
        Assert.assertEquals((String)result.getName(), (String)state.getName());
        Assert.assertEquals((boolean)result.blockChanges(), (boolean)state.blockChanges());
        Assert.assertEquals((boolean)result.disableEntitlementAndChangesBlocked(), (boolean)state.disableEntitlementAndChangesBlocked());
    }
}

