/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.overdue.OverdueTestSuiteWithEmbeddedDB;
import org.killbill.billing.overdue.notification.OverdueCheckNotificationKey;
import org.killbill.billing.overdue.notification.OverdueCheckPoster;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultOverdueCheckPoster
extends OverdueTestSuiteWithEmbeddedDB {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private EntitySqlDaoTransactionalJdbiWrapper entitySqlDaoTransactionalJdbiWrapper;
    private NotificationQueue overdueQueue;
    private DateTime testReferenceTime;

    @Override
    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.entitySqlDaoTransactionalJdbiWrapper = new EntitySqlDaoTransactionalJdbiWrapper(this.dbi, (Clock)this.clock, this.cacheControllerDispatcher, this.nonEntityDao);
        this.overdueQueue = this.notificationQueueService.getNotificationQueue("overdue-service", "overdue-check-queue");
        Assert.assertTrue((boolean)this.overdueQueue.isStarted());
        this.testReferenceTime = this.clock.getUTCNow();
    }

    @Test(groups={"slow"})
    public void testShouldntInsertMultipleNotificationsPerOverdueable() throws Exception {
        UUID accountId = UUID.randomUUID();
        Account overdueable = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)overdueable.getId()).thenReturn((Object)accountId);
        this.insertOverdueCheckAndVerifyQueueContent(overdueable, 10, 10);
        this.insertOverdueCheckAndVerifyQueueContent(overdueable, 5, 5);
        this.insertOverdueCheckAndVerifyQueueContent(overdueable, 15, 5);
        Assert.assertEquals((int)this.overdueQueue.getFutureNotificationForSearchKey1(OverdueCheckNotificationKey.class, this.internalCallContext.getAccountRecordId()).size(), (int)1);
    }

    private void insertOverdueCheckAndVerifyQueueContent(Account account, int nbDaysInFuture, int expectedNbDaysInFuture) throws IOException {
        DateTime futureNotificationTime = this.testReferenceTime.plusDays(nbDaysInFuture);
        OverdueCheckNotificationKey notificationKey = new OverdueCheckNotificationKey(account.getId());
        this.checkPoster.insertOverdueNotification(account.getId(), futureNotificationTime, "overdue-check-queue", notificationKey, this.internalCallContext);
        Collection<NotificationEventWithMetadata<OverdueCheckNotificationKey>> notificationsForKey = this.getNotificationsForOverdueable(account);
        Assert.assertEquals((int)notificationsForKey.size(), (int)1);
        NotificationEventWithMetadata<OverdueCheckNotificationKey> nm = notificationsForKey.iterator().next();
        Assert.assertEquals((Object)nm.getEvent(), (Object)notificationKey);
        Assert.assertEquals((Object)nm.getEffectiveDate(), (Object)this.testReferenceTime.plusDays(expectedNbDaysInFuture));
    }

    private Collection<NotificationEventWithMetadata<OverdueCheckNotificationKey>> getNotificationsForOverdueable(final Account account) {
        return (Collection)this.entitySqlDaoTransactionalJdbiWrapper.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Collection<NotificationEventWithMetadata<OverdueCheckNotificationKey>>>(){

            public Collection<NotificationEventWithMetadata<OverdueCheckNotificationKey>> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                return ((OverdueCheckPoster)TestDefaultOverdueCheckPoster.this.checkPoster).getFutureNotificationsForAccountInTransaction(entitySqlDaoWrapperFactory, TestDefaultOverdueCheckPoster.this.overdueQueue, account.getId(), OverdueCheckNotificationKey.class, TestDefaultOverdueCheckPoster.this.internalCallContext);
            }
        });
    }
}

