/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.glue;

import java.util.List;
import java.util.UUID;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.glue.KillBillModule;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;

public class ApplicatorMockJunctionModule
extends KillBillModule {
    public ApplicatorMockJunctionModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        this.installBlockingApi();
    }

    public void installBlockingApi() {
        this.bind(BlockingInternalApi.class).toInstance((Object)new ApplicatorBlockingApi());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ApplicatorBlockingApi
    implements BlockingInternalApi {
        private BlockingState blockingState;

        public BlockingState getBlockingState() {
            return this.blockingState;
        }

        public BlockingState getBlockingStateForService(UUID blockableId, BlockingStateType blockingStateType, String serviceName, InternalTenantContext context) {
            if (this.blockingState != null && this.blockingState.getBlockedId().equals(blockableId)) {
                return this.blockingState;
            }
            return DefaultBlockingState.getClearState((BlockingStateType)blockingStateType, (String)serviceName, (Clock)new ClockMock());
        }

        public List<BlockingState> getBlockingAllForAccount(InternalTenantContext context) {
            throw new UnsupportedOperationException();
        }

        public void setBlockingState(BlockingState state, InternalCallContext context) {
            this.blockingState = state;
        }
    }
}

