/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.killbill.billing.overdue.EmailNotification;
import org.killbill.billing.overdue.OverdueTestSuiteNoDB;
import org.killbill.billing.overdue.config.OverdueConfig;
import org.killbill.xmlloader.XMLLoader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOverdueConfig
extends OverdueTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testParseConfig() throws Exception {
        String xml = "<overdueConfig>   <accountOverdueStates>       <initialReevaluationInterval>           <unit>DAYS</unit><number>1</number>       </initialReevaluationInterval>       <state name=\"OD1\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>MONTHS</unit><number>1</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD1</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>false</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>15</number>           </autoReevaluationInterval>       </state>       <state name=\"OD2\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>MONTHS</unit><number>2</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD1</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>true</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>15</number>           </autoReevaluationInterval>           <enterStateEmailNotification>               <subject>ToTo</subject><templateName>Titi</templateName>           </enterStateEmailNotification>       </state>   </accountOverdueStates></overdueConfig>";
        ByteArrayInputStream is = new ByteArrayInputStream("<overdueConfig>   <accountOverdueStates>       <initialReevaluationInterval>           <unit>DAYS</unit><number>1</number>       </initialReevaluationInterval>       <state name=\"OD1\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>MONTHS</unit><number>1</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD1</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>false</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>15</number>           </autoReevaluationInterval>       </state>       <state name=\"OD2\">           <condition>               <timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>                   <unit>MONTHS</unit><number>2</number>               </timeSinceEarliestUnpaidInvoiceEqualsOrExceeds>           </condition>           <externalMessage>Reached OD1</externalMessage>           <blockChanges>true</blockChanges>           <disableEntitlementAndChangesBlocked>true</disableEntitlementAndChangesBlocked>           <autoReevaluationInterval>               <unit>DAYS</unit><number>15</number>           </autoReevaluationInterval>           <enterStateEmailNotification>               <subject>ToTo</subject><templateName>Titi</templateName>           </enterStateEmailNotification>       </state>   </accountOverdueStates></overdueConfig>".getBytes());
        OverdueConfig c = (OverdueConfig)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, OverdueConfig.class);
        Assert.assertEquals((int)c.getStateSet().size(), (int)2);
        Assert.assertNull((Object)c.getStateSet().getStates()[0].getEnterStateEmailNotification());
        Assert.assertNotNull((Object)c.getStateSet().getInitialReevaluationInterval());
        Assert.assertEquals((int)c.getStateSet().getInitialReevaluationInterval().getDays(), (int)1);
        EmailNotification secondNotification = c.getStateSet().getStates()[1].getEnterStateEmailNotification();
        Assert.assertEquals((String)secondNotification.getSubject(), (String)"ToTo");
        Assert.assertEquals((String)secondNotification.getTemplateName(), (String)"Titi");
        Assert.assertFalse((boolean)secondNotification.isHTML());
    }
}

