/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.applicator;

import com.jayway.awaitility.Awaitility;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.events.OverdueChangeInternalEvent;
import org.killbill.billing.overdue.OverdueState;
import org.killbill.billing.overdue.OverdueTestSuiteWithEmbeddedDB;
import org.killbill.billing.overdue.config.DefaultOverdueStateSet;
import org.killbill.billing.overdue.config.OverdueConfig;
import org.killbill.billing.overdue.config.api.OverdueStateSet;
import org.killbill.xmlloader.XMLLoader;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOverdueStateApplicator
extends OverdueTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testApplicator() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(this.testOverdueHelper.getConfigXml().getBytes());
        OverdueConfig config = (OverdueConfig)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, OverdueConfig.class);
        this.overdueWrapperFactory.setOverdueConfig(config);
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getId()).thenReturn((Object)UUID.randomUUID());
        DefaultOverdueStateSet overdueStateSet = config.getStateSet();
        OverdueState clearState = config.getStateSet().findState("__KILLBILL__CLEAR__OVERDUE_STATE__");
        OverdueState state = config.getStateSet().findState("OD1");
        this.applicator.apply((OverdueStateSet)overdueStateSet, null, account, clearState, state, this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        this.checkBussEvent("OD1");
        state = config.getStateSet().findState("OD2");
        this.applicator.apply((OverdueStateSet)overdueStateSet, null, account, clearState, state, this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        this.checkBussEvent("OD2");
        state = config.getStateSet().findState("OD3");
        this.applicator.apply((OverdueStateSet)overdueStateSet, null, account, clearState, state, this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        this.checkBussEvent("OD3");
    }

    private void checkBussEvent(String state) throws Exception {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                List<OverdueChangeInternalEvent> events = TestOverdueStateApplicator.this.listener.getEventsReceived();
                return events.size() == 1;
            }
        });
        List<OverdueChangeInternalEvent> events = this.listener.getEventsReceived();
        Assert.assertEquals((int)1, (int)events.size());
        Assert.assertEquals((String)state, (String)events.get(0).getNextOverdueStateName());
        this.listener.clearEventsReceived();
    }
}

