/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.dao.MockBlockingStateDao;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingModeType;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.junction.plumbing.billing.BlockingCalculator;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBlockingCalculator
extends JunctionTestSuiteNoDB {
    private static final String DISABLED_BUNDLE = "disabled-bundle";
    private static final String CLEAR_BUNDLE = "clear-bundle";
    private final UUID bundleId1 = UUID.randomUUID();
    private final UUID bundleId2 = UUID.randomUUID();
    private Account account;
    private SubscriptionBase subscription1;
    private SubscriptionBase subscription2;
    private SubscriptionBase subscription3;
    private SubscriptionBase subscription4;

    @Override
    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.account = (Account)Mockito.mock(Account.class);
        this.subscription1 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        this.subscription2 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        this.subscription3 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        this.subscription4 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)this.account.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription1.getBundleId()).thenReturn((Object)this.bundleId1);
        Mockito.when((Object)this.subscription2.getBundleId()).thenReturn((Object)this.bundleId1);
        Mockito.when((Object)this.subscription3.getBundleId()).thenReturn((Object)this.bundleId1);
        Mockito.when((Object)this.subscription4.getBundleId()).thenReturn((Object)this.bundleId2);
        Mockito.when((Object)this.subscription1.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription2.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription3.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription4.getId()).thenReturn((Object)UUID.randomUUID());
        ((MockBlockingStateDao)this.blockingStateDao).clear();
    }

    @Test(groups={"fast"})
    public void testInsertBlockingEventsForBundle() {
        DateTime now = this.clock.getUTCNow();
        BillingEvent A = this.createRealEvent(now.minusDays(1).minusHours(1), this.subscription1);
        BillingEvent B = this.createRealEvent(now.minusDays(1), this.subscription2);
        BillingEvent C = this.createRealEvent(now.plusDays(1), this.subscription2);
        BillingEvent D = this.createRealEvent(now.plusDays(3), this.subscription3);
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        billingEvents.add(A);
        billingEvents.add(B);
        billingEvents.add(C);
        billingEvents.add(D);
        ArrayList<BlockingState> blockingStates = new ArrayList<BlockingState>();
        blockingStates.add((BlockingState)new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now));
        blockingStates.add((BlockingState)new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        this.setBlockingStates(blockingStates);
        this.blockingCalculator.insertBlockingEvents(billingEvents, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)billingEvents.size(), (int)7);
        SortedSet s1Events = this.blockingCalculator.filter(billingEvents, this.subscription1);
        Iterator it1 = s1Events.iterator();
        Assert.assertEquals(it1.next(), (Object)A);
        Assert.assertEquals((Object)((BillingEvent)it1.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)it1.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        SortedSet s2Events = this.blockingCalculator.filter(billingEvents, this.subscription2);
        Iterator it2 = s2Events.iterator();
        Assert.assertEquals(it2.next(), (Object)B);
        Assert.assertEquals((Object)((BillingEvent)it2.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)it2.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        SortedSet s3Events = this.blockingCalculator.filter(billingEvents, this.subscription3);
        Iterator it3 = s3Events.iterator();
        Assert.assertEquals(it3.next(), (Object)D);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveOpenPrev() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveOpenPrevFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, null));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e1);
        billingEvents.add(e2);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveOpenFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, null));
        BillingEvent e1 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e1);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e1);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedPrev() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        billingEvents.add(e1);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedPrevBetw() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e1);
        billingEvents.add(e2);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedPrevBetwNext() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        BillingEvent e3 = this.createRealEvent(now.plusDays(3), this.subscription1);
        billingEvents.add(e1);
        billingEvents.add(e2);
        billingEvents.add(e3);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedBetwn() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e2);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedBetweenFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        BillingEvent e3 = this.createRealEvent(now.plusDays(3), this.subscription1);
        billingEvents.add(e2);
        billingEvents.add(e3);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        BillingEvent e3 = this.createRealEvent(now.plusDays(3), this.subscription1);
        billingEvents.add(e3);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsOpenPrev() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsOpenPrevFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsOpenFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedPrev() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)2);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedPrevBetw() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)2);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedPrevBetwNext() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(3), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)2);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedBetwn() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedBetweenFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice());
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<BlockingCalculator.DisabledDuration> disabledDuration = new ArrayList<BlockingCalculator.DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new BlockingCalculator.DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.plusDays(3), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.account, this.subscription1);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testPrecedingBillingEventForSubscription() {
        DateTime now = new DateTime();
        TreeSet<BillingEvent> events = new TreeSet<BillingEvent>();
        events.add(this.createRealEvent(now.minusDays(10), this.subscription1));
        events.add(this.createRealEvent(now.minusDays(6), this.subscription1));
        events.add(this.createRealEvent(now.minusDays(5), this.subscription1));
        events.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        BillingEvent minus11 = this.blockingCalculator.precedingBillingEventForSubscription(now.minusDays(11), events, this.subscription1);
        Assert.assertNull((Object)minus11);
        BillingEvent minus5andAHalf = this.blockingCalculator.precedingBillingEventForSubscription(now.minusDays(5).minusHours(12), events, this.subscription1);
        Assert.assertNotNull((Object)minus5andAHalf);
        Assert.assertEquals((Object)minus5andAHalf.getEffectiveDate(), (Object)now.minusDays(6));
    }

    protected BillingEvent createRealEvent(DateTime effectiveDate, SubscriptionBase subscription) {
        return this.createRealEvent(effectiveDate, subscription, SubscriptionBaseTransitionType.CHANGE);
    }

    protected BillingEvent createRealEvent(DateTime effectiveDate, SubscriptionBase subscription, SubscriptionBaseTransitionType type) {
        Account account = this.account;
        Integer billCycleDay = 1;
        MockPlanPhase planPhase = new MockPlanPhase();
        MockPlan plan = new MockPlan();
        BigDecimal fixedPrice = BigDecimal.TEN;
        BigDecimal recurringPrice = BigDecimal.TEN;
        Currency currency = Currency.USD;
        String description = "";
        BillingModeType billingModeType = BillingModeType.IN_ADVANCE;
        BillingPeriod billingPeriod = BillingPeriod.MONTHLY;
        Long totalOrdering = 0L;
        DateTimeZone tz = DateTimeZone.UTC;
        return new DefaultBillingEvent(account, subscription, effectiveDate, (Plan)plan, (PlanPhase)planPhase, fixedPrice, recurringPrice, currency, billingPeriod, billCycleDay.intValue(), billingModeType, "", totalOrdering.longValue(), type, tz);
    }

    @Test(groups={"fast"})
    public void testFilter() {
        TreeSet<BillingEvent> events = new TreeSet<BillingEvent>();
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription2));
        SortedSet result1 = this.blockingCalculator.filter(events, this.subscription1);
        SortedSet result2 = this.blockingCalculator.filter(events, this.subscription2);
        SortedSet result3 = this.blockingCalculator.filter(events, this.subscription3);
        Assert.assertEquals((int)result1.size(), (int)3);
        Assert.assertEquals((Object)((BillingEvent)result1.first()).getSubscription(), (Object)this.subscription1);
        Assert.assertEquals((Object)((BillingEvent)result1.last()).getSubscription(), (Object)this.subscription1);
        Assert.assertEquals((int)result2.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)result2.first()).getSubscription(), (Object)this.subscription2);
        Assert.assertEquals((int)result3.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testCreateNewDisableEvent() {
        DateTime now = this.clock.getUTCNow();
        MockBillingEvent event = new MockBillingEvent();
        BillingEvent result = this.blockingCalculator.createNewDisableEvent(now, (BillingEvent)event);
        Assert.assertEquals((int)result.getBillCycleDayLocal(), (int)event.getBillCycleDayLocal());
        Assert.assertEquals((Object)result.getEffectiveDate(), (Object)now);
        Assert.assertEquals((Object)result.getPlanPhase(), (Object)event.getPlanPhase());
        Assert.assertEquals((Object)result.getPlan(), (Object)event.getPlan());
        Assert.assertNull((Object)result.getFixedPrice());
        Assert.assertNull((Object)result.getRecurringPrice());
        Assert.assertEquals((Object)result.getCurrency(), (Object)event.getCurrency());
        Assert.assertEquals((String)result.getDescription(), (String)"");
        Assert.assertEquals((Object)result.getBillingMode(), (Object)event.getBillingMode());
        Assert.assertEquals((Object)result.getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)result.getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)result.getTotalOrdering(), (Object)(BlockingCalculator.getGlobalTotalOrder().get() - 1L));
    }

    @Test(groups={"fast"})
    public void testCreateNewReenableEvent() {
        DateTime now = this.clock.getUTCNow();
        MockBillingEvent event = new MockBillingEvent();
        BillingEvent result = this.blockingCalculator.createNewReenableEvent(now, (BillingEvent)event);
        Assert.assertEquals((int)result.getBillCycleDayLocal(), (int)event.getBillCycleDayLocal());
        Assert.assertEquals((Object)result.getEffectiveDate(), (Object)now);
        Assert.assertEquals((Object)result.getPlanPhase(), (Object)event.getPlanPhase());
        Assert.assertEquals((Object)result.getPlan(), (Object)event.getPlan());
        Assert.assertEquals((Object)result.getFixedPrice(), (Object)event.getFixedPrice());
        Assert.assertEquals((Object)result.getRecurringPrice(), (Object)event.getRecurringPrice());
        Assert.assertEquals((Object)result.getCurrency(), (Object)event.getCurrency());
        Assert.assertEquals((String)result.getDescription(), (String)"");
        Assert.assertEquals((Object)result.getBillingMode(), (Object)event.getBillingMode());
        Assert.assertEquals((Object)result.getBillingPeriod(), (Object)event.getBillingPeriod());
        Assert.assertEquals((Object)result.getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)result.getTotalOrdering(), (Object)(BlockingCalculator.getGlobalTotalOrder().get() - 1L));
    }

    @Test(groups={"fast"})
    public void testCreateBundleSubscriptionMap() {
        TreeSet<BillingEvent> events = new TreeSet<BillingEvent>();
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription2));
        events.add(this.createBillingEvent(this.subscription3));
        events.add(this.createBillingEvent(this.subscription4));
        Hashtable map = this.blockingCalculator.createBundleSubscriptionMap(events);
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((int)map.keySet().size(), (int)2);
        Assert.assertEquals((int)((List)map.get(this.bundleId1)).size(), (int)3);
        Assert.assertEquals((int)((List)map.get(this.bundleId2)).size(), (int)1);
    }

    private BillingEvent createBillingEvent(SubscriptionBase subscription) {
        BillingEvent result = (BillingEvent)Mockito.mock(BillingEvent.class);
        Mockito.when((Object)result.getSubscription()).thenReturn((Object)subscription);
        Mockito.when((Object)result.compareTo(Mockito.any())).thenReturn((Object)1);
        return result;
    }

    @Test(groups={"fast"})
    public void testCreateDisablePairs() {
        UUID ovdId = UUID.randomUUID();
        UUID ovdId2 = UUID.randomUUID();
        DateTime now = this.clock.getUTCNow();
        ArrayList<DefaultBlockingState> blockingEvents = new ArrayList<DefaultBlockingState>();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        List pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd());
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(2));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(2));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(3)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(3));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(3)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(4)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(4));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(3)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(3));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(3)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertEquals((Object)((BlockingCalculator.DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(3));
    }

    @Test(groups={"fast"})
    public void testSimpleWithClearBlockingDuration() throws Exception {
        UUID ovdId = UUID.randomUUID();
        BillingEvent trial = this.createRealEvent(new LocalDate(2012, 5, 1).toDateTimeAtStartOfDay(DateTimeZone.UTC), this.subscription1, SubscriptionBaseTransitionType.CREATE);
        BillingEvent phase = this.createRealEvent(new LocalDate(2012, 5, 31).toDateTimeAtStartOfDay(DateTimeZone.UTC), this.subscription1, SubscriptionBaseTransitionType.PHASE);
        BillingEvent upgrade = this.createRealEvent(new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC), this.subscription1, SubscriptionBaseTransitionType.CHANGE);
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        billingEvents.add(trial);
        billingEvents.add(phase);
        billingEvents.add(upgrade);
        ArrayList<BlockingState> blockingEvents = new ArrayList<BlockingState>();
        blockingEvents.add((BlockingState)new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, false, false, new LocalDate(2012, 7, 5).toDateTimeAtStartOfDay(DateTimeZone.UTC)));
        blockingEvents.add((BlockingState)new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, new LocalDate(2012, 7, 15).toDateTimeAtStartOfDay(DateTimeZone.UTC)));
        blockingEvents.add((BlockingState)new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC)));
        blockingEvents.add((BlockingState)new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC)));
        this.setBlockingStates(blockingEvents);
        this.blockingCalculator.insertBlockingEvents(billingEvents, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)billingEvents.size(), (int)5);
        ArrayList events = new ArrayList(billingEvents);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)new LocalDate(2012, 5, 1).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getEffectiveDate(), (Object)new LocalDate(2012, 5, 31).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.PHASE);
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getEffectiveDate(), (Object)new LocalDate(2012, 7, 15).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(3)).getEffectiveDate(), (Object)new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(3)).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(4)).getEffectiveDate(), (Object)new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(4)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CHANGE);
    }

    private void setBlockingStates(List<BlockingState> blockingStates) {
        for (BlockingState blockingState : blockingStates) {
            this.blockingStateDao.setBlockingState(blockingState, (Clock)this.clock, this.internalCallContext);
        }
    }

    private class MockBillingEvent
    extends DefaultBillingEvent {
        public MockBillingEvent() {
            super(TestBlockingCalculator.this.account, TestBlockingCalculator.this.subscription1, TestBlockingCalculator.this.clock.getUTCNow(), null, null, BigDecimal.ZERO, BigDecimal.TEN, Currency.USD, BillingPeriod.ANNUAL, 4, BillingModeType.IN_ADVANCE, "", 3L, SubscriptionBaseTransitionType.CREATE, DateTimeZone.UTC);
        }
    }
}

