/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.dao.MockBlockingStateDao;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.junction.BillingModeType;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.mock.MockEffectiveSubscriptionEvent;
import org.killbill.billing.mock.MockSubscription;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.dao.MockTagDao;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBillingApi
extends JunctionTestSuiteNoDB {
    private static final String DISABLED_BUNDLE = "disabled-bundle";
    private static final String CLEAR_BUNDLE = "clear-bundle";
    private static final UUID eventId = new UUID(0L, 0L);
    private static final UUID subId = new UUID(1L, 0L);
    private static final UUID bunId = new UUID(2L, 0L);
    private List<EffectiveSubscriptionInternalEvent> effectiveSubscriptionTransitions;
    private SubscriptionBase subscription;
    private MockCatalog catalog;

    @Override
    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        SubscriptionBaseBundle bundle = (SubscriptionBaseBundle)Mockito.mock(SubscriptionBaseBundle.class);
        Mockito.when((Object)bundle.getId()).thenReturn((Object)bunId);
        ImmutableList bundles = ImmutableList.of((Object)bundle);
        this.effectiveSubscriptionTransitions = new LinkedList<EffectiveSubscriptionInternalEvent>();
        DateTime subscriptionStartDate = this.clock.getUTCNow().minusDays(3);
        this.subscription = new MockSubscription(subId, bunId, null, subscriptionStartDate, this.effectiveSubscriptionTransitions);
        ImmutableList subscriptions = ImmutableList.of((Object)this.subscription);
        Mockito.when((Object)this.subscriptionInternalApi.getBundlesForAccount((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)bundles);
        Mockito.when((Object)this.subscriptionInternalApi.getSubscriptionsForBundle((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)subscriptions);
        Mockito.when((Object)this.subscriptionInternalApi.getSubscriptionFromId((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)this.subscription);
        Mockito.when((Object)this.subscriptionInternalApi.getBundleFromId((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)bundle);
        Mockito.when((Object)this.subscriptionInternalApi.getBaseSubscription((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)this.subscription);
        Mockito.when((Object)this.subscriptionInternalApi.getBillingTransitions((SubscriptionBase)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn(this.effectiveSubscriptionTransitions);
        Mockito.when((Object)this.subscriptionInternalApi.getAllTransitions((SubscriptionBase)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn(this.effectiveSubscriptionTransitions);
        this.catalog = (MockCatalog)this.catalogService.getCurrentCatalog();
        Mockito.when((Object)this.catalogService.getFullCatalog()).thenReturn((Object)this.catalog);
        this.catalog.setBillingAlignment(BillingAlignment.ACCOUNT);
        ((MockBlockingStateDao)this.blockingStateDao).clear();
        ((MockTagDao)this.tagDao).clear();
    }

    @Test(groups={"fast"})
    public void testBillingEventsEmpty() throws AccountApiException {
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(new UUID(0L, 0L), this.internalCallContext);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testBillingEventsNoBillingPeriod() throws CatalogApiException, AccountApiException {
        Plan nextPlan = this.catalog.findPlan("PickupTrialEvergreen10USD", this.clock.getUTCNow());
        PlanPhase nextPhase = nextPlan.getAllPhases()[0];
        DateTime now = this.createSubscriptionCreationEvent(nextPlan, nextPhase);
        Account account = this.createAccount(10);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, nextPlan, account.getBillCycleDayLocal(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsSubscriptionAligned() throws CatalogApiException, AccountApiException {
        Plan nextPlan = this.catalog.findPlan("PickupTrialEvergreen10USD", this.clock.getUTCNow());
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        DateTime now = this.createSubscriptionCreationEvent(nextPlan, nextPhase);
        Account account = this.createAccount(1);
        this.catalog.setBillingAlignment(BillingAlignment.SUBSCRIPTION);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, nextPlan, this.subscription.getStartDate().getDayOfMonth(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsAccountAligned() throws CatalogApiException, AccountApiException {
        Plan nextPlan = this.catalog.findPlan("PickupTrialEvergreen10USD", this.clock.getUTCNow());
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        DateTime now = this.createSubscriptionCreationEvent(nextPlan, nextPhase);
        Account account = this.createAccount(32);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, nextPlan, 32, subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsBundleAligned() throws CatalogApiException, AccountApiException {
        Plan nextPlan = this.catalog.findPlan("Horn1USD", this.clock.getUTCNow());
        PlanPhase nextPhase = nextPlan.getAllPhases()[0];
        DateTime now = this.createSubscriptionCreationEvent(nextPlan, nextPhase);
        Account account = this.createAccount(1);
        this.catalog.setBillingAlignment(BillingAlignment.BUNDLE);
        ((MockSubscription)this.subscription).setPlan(this.catalog.findPlan("PickupTrialEvergreen10USD", now));
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, nextPlan, this.subscription.getStartDate().getDayOfMonth(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsWithBlock() throws CatalogApiException, AccountApiException {
        Plan nextPlan = this.catalog.findPlan("PickupTrialEvergreen10USD", this.clock.getUTCNow());
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        DateTime now = this.createSubscriptionCreationEvent(nextPlan, nextPhase);
        Account account = this.createAccount(32);
        this.blockingStateDao.setBlockingState((BlockingState)new DefaultBlockingState(bunId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)), (Clock)this.clock, this.internalCallContext);
        this.blockingStateDao.setBlockingState((BlockingState)new DefaultBlockingState(bunId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)), (Clock)this.clock, this.internalCallContext);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), this.internalCallContext);
        Assert.assertEquals((int)events.size(), (int)3);
        Iterator it = events.iterator();
        this.checkEvent((BillingEvent)it.next(), nextPlan, account.getBillCycleDayLocal(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString(), nextPhase.getFixedPrice(), nextPhase.getRecurringPrice());
        this.checkEvent((BillingEvent)it.next(), nextPlan, account.getBillCycleDayLocal(), subId, now.plusDays(1), nextPhase, SubscriptionBaseTransitionType.START_BILLING_DISABLED.toString(), null, null);
        this.checkEvent((BillingEvent)it.next(), nextPlan, account.getBillCycleDayLocal(), subId, now.plusDays(2), nextPhase, SubscriptionBaseTransitionType.END_BILLING_DISABLED.toString(), nextPhase.getFixedPrice(), nextPhase.getRecurringPrice());
    }

    @Test(groups={"fast"})
    public void testBillingEventsAutoInvoicingOffAccount() throws CatalogApiException, AccountApiException, TagApiException {
        Plan nextPlan = this.catalog.findPlan("PickupTrialEvergreen10USD", this.clock.getUTCNow());
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        this.createSubscriptionCreationEvent(nextPlan, nextPhase);
        Account account = this.createAccount(32);
        this.tagInternalApi.addTag(account.getId(), ObjectType.ACCOUNT, ControlTagType.AUTO_INVOICING_OFF.getId(), this.internalCallContext);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), this.internalCallContext);
        Assert.assertEquals((boolean)events.isAccountAutoInvoiceOff(), (boolean)true);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testBillingEventsAutoInvoicingOffBundle() throws CatalogApiException, AccountApiException, TagApiException {
        Plan nextPlan = this.catalog.findPlan("PickupTrialEvergreen10USD", this.clock.getUTCNow());
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        this.createSubscriptionCreationEvent(nextPlan, nextPhase);
        Account account = this.createAccount(32);
        this.tagInternalApi.addTag(bunId, ObjectType.BUNDLE, ControlTagType.AUTO_INVOICING_OFF.getId(), this.internalCallContext);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), this.internalCallContext);
        Assert.assertEquals((int)events.getSubscriptionIdsWithAutoInvoiceOff().size(), (int)1);
        Assert.assertEquals(events.getSubscriptionIdsWithAutoInvoiceOff().get(0), (Object)subId);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    private void checkFirstEvent(SortedSet<BillingEvent> events, Plan nextPlan, int BCD, UUID id, DateTime time, PlanPhase nextPhase, String desc) throws CatalogApiException {
        Assert.assertEquals((int)events.size(), (int)1);
        this.checkEvent(events.first(), nextPlan, BCD, id, time, nextPhase, desc, nextPhase.getFixedPrice(), nextPhase.getRecurringPrice());
    }

    private void checkEvent(BillingEvent event, Plan nextPlan, int BCD, UUID id, DateTime time, PlanPhase nextPhase, String desc, InternationalPrice fixedPrice, InternationalPrice recurringPrice) throws CatalogApiException {
        if (fixedPrice != null) {
            Assert.assertEquals((Object)fixedPrice.getPrice(Currency.USD), (Object)event.getFixedPrice());
        } else {
            Assert.assertNull((Object)event.getFixedPrice());
        }
        if (recurringPrice != null) {
            Assert.assertEquals((Object)recurringPrice.getPrice(Currency.USD), (Object)event.getRecurringPrice());
        } else {
            Assert.assertNull((Object)event.getRecurringPrice());
        }
        Assert.assertEquals((int)BCD, (int)event.getBillCycleDayLocal());
        Assert.assertEquals((Object)id, (Object)event.getSubscription().getId());
        Assert.assertEquals((int)time.getDayOfMonth(), (int)event.getEffectiveDate().getDayOfMonth());
        Assert.assertEquals((Object)nextPhase, (Object)event.getPlanPhase());
        Assert.assertEquals((Object)nextPlan, (Object)event.getPlan());
        if (!SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)event.getTransitionType())) {
            Assert.assertEquals((Object)nextPhase.getBillingPeriod(), (Object)event.getBillingPeriod());
        }
        Assert.assertEquals((Object)BillingModeType.IN_ADVANCE, (Object)event.getBillingMode());
        Assert.assertEquals((String)desc, (String)event.getTransitionType().toString());
    }

    private Account createAccount(int billCycleDay) throws AccountApiException {
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getBillCycleDayLocal()).thenReturn((Object)billCycleDay);
        Mockito.when((Object)account.getCurrency()).thenReturn((Object)Currency.USD);
        Mockito.when((Object)account.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)DateTimeZone.UTC);
        Mockito.when((Object)this.accountInternalApi.getAccountById((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)account);
        return account;
    }

    private DateTime createSubscriptionCreationEvent(Plan nextPlan, PlanPhase nextPhase) throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        DateTime then = now.minusDays(1);
        PriceList nextPriceList = this.catalog.findPriceList("DEFAULT", now);
        MockEffectiveSubscriptionEvent t = new MockEffectiveSubscriptionEvent(eventId, subId, bunId, then, now, null, null, null, null, Entitlement.EntitlementState.ACTIVE, nextPlan.getName(), nextPhase.getName(), nextPriceList.getName(), Long.valueOf(1L), SubscriptionBaseTransitionType.CREATE, Integer.valueOf(1), null, Long.valueOf(1L), Long.valueOf(2L), null);
        this.effectiveSubscriptionTransitions.add((EffectiveSubscriptionInternalEvent)t);
        return now;
    }
}

