/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.glue;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.util.Map;
import org.killbill.billing.GuicyKillbillTestNoDBModule;
import org.killbill.billing.catalog.MockCatalogModule;
import org.killbill.billing.junction.glue.TestJunctionModule;
import org.killbill.billing.mock.glue.MockAccountModule;
import org.killbill.billing.mock.glue.MockNonEntityDaoModule;
import org.killbill.billing.mock.glue.MockSubscriptionModule;
import org.killbill.billing.mock.glue.MockTagModule;
import org.killbill.billing.util.bus.InMemoryBusModule;
import org.killbill.notificationq.MockNotificationQueueService;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;

public class TestJunctionModuleNoDB
extends TestJunctionModule {
    public TestJunctionModuleNoDB(ConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        super.configure();
        this.install((Module)new GuicyKillbillTestNoDBModule());
        this.install((Module)new MockNonEntityDaoModule());
        this.install((Module)new InMemoryBusModule(this.configSource));
        this.install((Module)new MockAccountModule());
        this.install((Module)new MockCatalogModule());
        this.install((Module)new MockSubscriptionModule());
        this.install((Module)new TestJunctionModule.MockEntitlementModuleForJunction());
        this.install((Module)new MockTagModule());
        this.installNotificationQueue();
    }

    private void installNotificationQueue() {
        this.bind(NotificationQueueService.class).to(MockNotificationQueueService.class).asEagerSingleton();
        this.configureNotificationQueueConfig();
    }

    protected void configureNotificationQueueConfig() {
        NotificationQueueConfig config = (NotificationQueueConfig)new ConfigurationObjectFactory(this.configSource).buildWithReplacements(NotificationQueueConfig.class, (Map)ImmutableMap.of((Object)"instanceName", (Object)"main"));
        this.bind(NotificationQueueConfig.class).toInstance((Object)config);
    }
}

