/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.math.BigDecimal;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.killbill.billing.GuicyKillbillTestSuiteNoDB;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogInternalApi;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.entitlement.dao.BlockingStateDao;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingInternalApi;
import org.killbill.billing.junction.glue.TestJunctionModuleNoDB;
import org.killbill.billing.junction.plumbing.billing.BlockingCalculator;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.DefaultSubscriptionBillingEvent;
import org.killbill.billing.subscription.api.user.SubscriptionBillingEvent;
import org.killbill.billing.tag.TagInternalApi;
import org.killbill.billing.util.tag.dao.TagDao;
import org.killbill.bus.api.PersistentBus;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class JunctionTestSuiteNoDB
extends GuicyKillbillTestSuiteNoDB {
    @Inject
    protected AccountInternalApi accountInternalApi;
    @Inject
    protected BillingInternalApi billingInternalApi;
    @Inject
    protected BlockingCalculator blockingCalculator;
    @Inject
    protected CatalogService catalogService;
    @Inject
    protected CatalogInternalApi catalogInternalApi;
    @Inject
    protected SubscriptionBaseInternalApi subscriptionInternalApi;
    @Inject
    protected PersistentBus bus;
    @Inject
    protected TagDao tagDao;
    @Inject
    protected TagInternalApi tagInternalApi;
    @Inject
    protected BlockingStateDao blockingStateDao;

    @BeforeClass(groups={"fast"})
    protected void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestJunctionModuleNoDB(this.configSource, this.clock)});
        injector.injectMembers((Object)this);
    }

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        this.bus.startQueue();
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() {
        if (this.hasFailed()) {
            return;
        }
        this.bus.stopQueue();
    }

    protected BillingEvent createEvent(SubscriptionBase sub, DateTime effectiveDate, SubscriptionBaseTransitionType type) throws CatalogApiException {
        return this.createEvent(sub, effectiveDate, type, 1L);
    }

    protected BillingEvent createEvent(SubscriptionBase sub, DateTime effectiveDate, SubscriptionBaseTransitionType type, long totalOrdering) throws CatalogApiException {
        boolean billCycleDay = true;
        MockPlan shotgun = new MockPlan();
        MockPlanPhase shotgunMonthly = this.createMockMonthlyPlanPhase(null, BigDecimal.ZERO, PhaseType.TRIAL);
        DefaultSubscriptionBillingEvent subscriptionBillingEvent = new DefaultSubscriptionBillingEvent(type, (Plan)shotgun, (PlanPhase)shotgunMonthly, effectiveDate, Long.valueOf(totalOrdering), Integer.valueOf(1), Integer.valueOf(1), effectiveDate);
        return new DefaultBillingEvent((SubscriptionBillingEvent)subscriptionBillingEvent, sub, 1, null, Currency.USD);
    }

    protected MockPlanPhase createMockMonthlyPlanPhase(@Nullable BigDecimal recurringRate, @Nullable BigDecimal fixedRate, PhaseType phaseType) {
        return new MockPlanPhase(recurringRate == null ? null : new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(recurringRate, Currency.USD)}), fixedRate == null ? null : new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedRate, Currency.USD)}), BillingPeriod.MONTHLY, phaseType);
    }

    protected SubscriptionBase subscription(UUID id) {
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getId()).thenReturn((Object)id);
        return subscription;
    }
}

