/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.DefaultBaseEntitlementWithAddOnsSpecifier;
import org.killbill.billing.entitlement.api.DefaultEntitlementSpecifier;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteWithEmbeddedDB;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultInternalBillingApi
extends JunctionTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testRecurringInArrear() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(0));
        Assert.assertEquals((Object)account.getBillCycleDayLocal(), (Object)0);
        String bundleKey = UUID.randomUUID().toString();
        DefaultEntitlementSpecifier entitlementSpecifierBase = new DefaultEntitlementSpecifier(new PlanPhaseSpecifier("Cannon", BillingPeriod.MONTHLY, "DEFAULT", null));
        DefaultBaseEntitlementWithAddOnsSpecifier specifier = new DefaultBaseEntitlementWithAddOnsSpecifier(null, bundleKey, List.of(entitlementSpecifierBase), null, null, false);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        this.entitlementApi.createBaseEntitlementsWithAddOns(account.getId(), List.of(specifier), false, Collections.emptyList(), (CallContext)this.callContext);
        this.assertListenerStatus();
        List entitlements = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlements.size(), (int)1);
        Assert.assertEquals((String)((Entitlement)entitlements.get(0)).getLastActiveProduct().getName(), (String)"Cannon");
        Assert.assertNull((Object)((Entitlement)entitlements.get(0)).getBillCycleDayLocal());
        Account accountNoBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountNoBCD.getBillCycleDayLocal(), (Object)0);
        List events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)1);
        Assert.assertEquals((int)((BillingEvent)events.get(0)).getBillCycleDayLocal(), (int)7);
        Account accountWithBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountWithBCD.getBillCycleDayLocal(), (Object)7);
        List entitlementsUpdated = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlementsUpdated.size(), (int)1);
        Assert.assertEquals((String)((Entitlement)entitlementsUpdated.get(0)).getLastActiveProduct().getName(), (String)"Cannon");
        Assert.assertEquals((Object)((Entitlement)entitlementsUpdated.get(0)).getBillCycleDayLocal(), (Object)7);
        events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)1);
        Assert.assertEquals((int)((BillingEvent)events.get(0)).getBillCycleDayLocal(), (int)7);
    }

    @Test(groups={"slow"})
    public void testUsageInArrear() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(0));
        Assert.assertEquals((Object)account.getBillCycleDayLocal(), (Object)0);
        String bundleKey = UUID.randomUUID().toString();
        DefaultEntitlementSpecifier entitlementSpecifierBase = new DefaultEntitlementSpecifier(new PlanPhaseSpecifier("Trebuchet", BillingPeriod.NO_BILLING_PERIOD, "DEFAULT", null));
        DefaultBaseEntitlementWithAddOnsSpecifier specifier = new DefaultBaseEntitlementWithAddOnsSpecifier(null, bundleKey, List.of(entitlementSpecifierBase), null, null, false);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        this.entitlementApi.createBaseEntitlementsWithAddOns(account.getId(), List.of(specifier), false, Collections.emptyList(), (CallContext)this.callContext);
        this.assertListenerStatus();
        List entitlements = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlements.size(), (int)1);
        Assert.assertEquals((String)((Entitlement)entitlements.get(0)).getLastActiveProduct().getName(), (String)"Trebuchet");
        Assert.assertNull((Object)((Entitlement)entitlements.get(0)).getBillCycleDayLocal());
        Account accountNoBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountNoBCD.getBillCycleDayLocal(), (Object)0);
        List events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)1);
        Assert.assertEquals((int)((BillingEvent)events.get(0)).getBillCycleDayLocal(), (int)7);
        Account accountWithBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountWithBCD.getBillCycleDayLocal(), (Object)7);
        List entitlementsUpdated = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlementsUpdated.size(), (int)1);
        Assert.assertEquals((String)((Entitlement)entitlementsUpdated.get(0)).getLastActiveProduct().getName(), (String)"Trebuchet");
        Assert.assertEquals((Object)((Entitlement)entitlementsUpdated.get(0)).getBillCycleDayLocal(), (Object)7);
        events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)1);
        Assert.assertEquals((int)((BillingEvent)events.get(0)).getBillCycleDayLocal(), (int)7);
    }

    @Test(groups={"slow"}, description="https://github.com/killbill/killbill/issues/865")
    public void testBCDUpdateMultipleSubscriptionsAccountAligned() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(0));
        Assert.assertEquals((Object)account.getBillCycleDayLocal(), (Object)0);
        String bundleKey1 = UUID.randomUUID().toString();
        DefaultEntitlementSpecifier entitlementSpecifierBase1 = new DefaultEntitlementSpecifier(new PlanPhaseSpecifier("Shotgun", BillingPeriod.MONTHLY, "DEFAULT", null));
        DefaultEntitlementSpecifier entitlementSpecifierAO1 = new DefaultEntitlementSpecifier(new PlanPhaseSpecifier("Cabinet", BillingPeriod.TRIANNUAL, "DEFAULT", null));
        DefaultBaseEntitlementWithAddOnsSpecifier specifier1 = new DefaultBaseEntitlementWithAddOnsSpecifier(null, bundleKey1, List.of(entitlementSpecifierBase1, entitlementSpecifierAO1), null, null, false);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        this.entitlementApi.createBaseEntitlementsWithAddOns(account.getId(), List.of(specifier1), false, Collections.emptyList(), (CallContext)this.callContext);
        this.assertListenerStatus();
        List entitlements = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlements.size(), (int)2);
        Assert.assertEquals((String)((Entitlement)entitlements.get(0)).getLastActiveProduct().getName(), (String)"Shotgun");
        Assert.assertNull((Object)((Entitlement)entitlements.get(0)).getBillCycleDayLocal());
        Assert.assertEquals((String)((Entitlement)entitlements.get(1)).getLastActiveProduct().getName(), (String)"Cabinet");
        Assert.assertNull((Object)((Entitlement)entitlements.get(1)).getBillCycleDayLocal());
        Account accountNoBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountNoBCD.getBillCycleDayLocal(), (Object)0);
        List<Object> events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)3);
        for (BillingEvent billingEvent : events) {
            Assert.assertEquals((int)billingEvent.getBillCycleDayLocal(), (int)7);
        }
        Account accountWithBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountWithBCD.getBillCycleDayLocal(), (Object)7);
        List entitlementsUpdated = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlementsUpdated.size(), (int)2);
        Assert.assertEquals((String)((Entitlement)entitlementsUpdated.get(0)).getLastActiveProduct().getName(), (String)"Shotgun");
        Assert.assertEquals((Object)((Entitlement)entitlementsUpdated.get(0)).getBillCycleDayLocal(), (Object)7);
        Assert.assertEquals((String)((Entitlement)entitlementsUpdated.get(1)).getLastActiveProduct().getName(), (String)"Cabinet");
        Assert.assertEquals((Object)((Entitlement)entitlementsUpdated.get(1)).getBillCycleDayLocal(), (Object)7);
        events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)3);
        for (BillingEvent billingEvent : events) {
            Assert.assertEquals((int)billingEvent.getBillCycleDayLocal(), (int)7);
        }
    }

    @Test(groups={"slow"})
    public void testBCDUpdateMultipleSubscriptionsAccountAndSubscriptionAligned() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(0));
        Assert.assertEquals((Object)account.getBillCycleDayLocal(), (Object)0);
        String bundleKey1 = UUID.randomUUID().toString();
        String bundleKey2 = UUID.randomUUID().toString();
        DefaultEntitlementSpecifier entitlementSpecifierBase1 = new DefaultEntitlementSpecifier(new PlanPhaseSpecifier("Pistol", BillingPeriod.ANNUAL, "gunclubDiscountNoTrial", null));
        DefaultEntitlementSpecifier entitlementSpecifierBase2 = new DefaultEntitlementSpecifier(new PlanPhaseSpecifier("Pistol", BillingPeriod.MONTHLY, "DEFAULT", null));
        DefaultBaseEntitlementWithAddOnsSpecifier specifier1 = new DefaultBaseEntitlementWithAddOnsSpecifier(null, bundleKey1, List.of(entitlementSpecifierBase1), null, null, false);
        DefaultBaseEntitlementWithAddOnsSpecifier specifier2 = new DefaultBaseEntitlementWithAddOnsSpecifier(null, bundleKey2, List.of(entitlementSpecifierBase2), null, null, false);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        this.entitlementApi.createBaseEntitlementsWithAddOns(account.getId(), List.of(specifier1, specifier2), false, Collections.emptyList(), (CallContext)this.callContext);
        this.assertListenerStatus();
        List entitlements = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlements.size(), (int)2);
        for (Entitlement entitlement : entitlements) {
            if ("pistol-annual-gunclub-discount-notrial".equals(entitlement.getLastActivePlan().getName())) {
                Assert.assertEquals((Object)entitlement.getBillCycleDayLocal(), (Object)7);
                continue;
            }
            Assert.assertNull((Object)entitlement.getBillCycleDayLocal());
        }
        Account accountNoBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountNoBCD.getBillCycleDayLocal(), (Object)0);
        List<Object> events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)4);
        for (BillingEvent billingEvent : events) {
            if ("pistol-annual-gunclub-discount-notrial".equals(billingEvent.getPlan().getName())) {
                Assert.assertEquals((int)billingEvent.getBillCycleDayLocal(), (int)7);
                continue;
            }
            Assert.assertEquals((int)billingEvent.getBillCycleDayLocal(), (int)6);
        }
        Account accountWithBCD = this.accountApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountWithBCD.getBillCycleDayLocal(), (Object)6);
        List entitlementsUpdated = this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)entitlementsUpdated.size(), (int)2);
        for (Entitlement entitlement : entitlementsUpdated) {
            if ("pistol-annual-gunclub-discount-notrial".equals(entitlement.getLastActivePlan().getName())) {
                Assert.assertEquals((Object)entitlement.getBillCycleDayLocal(), (Object)7);
                continue;
            }
            Assert.assertEquals((Object)entitlement.getBillCycleDayLocal(), (Object)6);
        }
        events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)4);
        for (BillingEvent billingEvent : events) {
            if ("pistol-annual-gunclub-discount-notrial".equals(billingEvent.getPlan().getName())) {
                Assert.assertEquals((int)billingEvent.getBillCycleDayLocal(), (int)7);
                continue;
            }
            Assert.assertEquals((int)billingEvent.getBillCycleDayLocal(), (int)6);
        }
    }

    @Test(groups={"slow"}, description="Check blocking states with same effective date are correctly handled", invocationCount=10)
    public void testBlockingStatesWithSameEffectiveDate() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(7));
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        PlanPhaseSpecifier spec = new PlanPhaseSpecifier("Shotgun", BillingPeriod.MONTHLY, "DEFAULT", null);
        UUID entitlementId = this.entitlementApi.createBaseEntitlement(account.getId(), (EntitlementSpecifier)new DefaultEntitlementSpecifier(spec), account.getExternalKey(), null, null, false, true, Collections.emptyList(), (CallContext)this.callContext);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(entitlementId, false, (TenantContext)this.callContext);
        SubscriptionBase subscription = this.subscriptionInternalApi.getSubscriptionFromId(entitlement.getId(), false, (InternalTenantContext)this.internalCallContext);
        this.assertListenerStatus();
        DateTime block1Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state1 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), true, true, true, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state1, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state2 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), false, false, false, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state2, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(5);
        DateTime block2Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state3 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_BLOCKED", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), true, true, true, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state3, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state4 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_CLEAR", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), false, false, false, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state4, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        DateTime block3Date = block2Date.plusDays(3);
        this.testListener.pushExpectedEvent(TestApiListener.NextEvent.PHASE);
        this.clock.addDays(50);
        this.assertListenerStatus();
        DateTime block4Date = this.clock.getUTCNow();
        DateTime block5Date = block4Date.plusDays(3);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state6 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_CLEAR-something", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), false, false, false, block5Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state6, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state5 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_BLOCKED-something", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), true, true, true, block4Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state5, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state7 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED-something2", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), true, true, true, block3Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state7, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state8 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR-something2", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), false, false, false, block4Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state8, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        this.clock.addDays(5);
        this.assertListenerStatus();
        List events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)3);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)subscription.getStartDate());
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((int)((BillingEvent)events.get(1)).getEffectiveDate().compareTo((ReadableInstant)block3Date), (int)0);
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((int)((BillingEvent)events.get(2)).getEffectiveDate().compareTo((ReadableInstant)block5Date), (int)0);
    }

    @Test(groups={"slow"}, description="Check unblock then block states with same effective date are correctly handled", invocationCount=10)
    public void testUnblockThenBlockBlockingStatesWithSameEffectiveDate() throws Exception {
        this.testUnblockThenBlockBlockingStatesWithSimilarEffectiveDate((ReadablePeriod)Seconds.ZERO);
    }

    @Test(groups={"slow"}, description="Check unblock then block states with almost the same effective date are correctly handled", invocationCount=10)
    public void testUnblockThenBlockBlockingStatesWithAlmostSameEffectiveDate() throws Exception {
        this.testUnblockThenBlockBlockingStatesWithSimilarEffectiveDate((ReadablePeriod)Seconds.ONE);
    }

    private void testUnblockThenBlockBlockingStatesWithSimilarEffectiveDate(ReadablePeriod delay) throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(7));
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        PlanPhaseSpecifier spec = new PlanPhaseSpecifier("Shotgun", BillingPeriod.MONTHLY, "DEFAULT", null);
        UUID entitlementId = this.entitlementApi.createBaseEntitlement(account.getId(), (EntitlementSpecifier)new DefaultEntitlementSpecifier(spec), account.getExternalKey(), null, null, false, true, Collections.emptyList(), (CallContext)this.callContext);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(entitlementId, false, (TenantContext)this.callContext);
        SubscriptionBase subscription = this.subscriptionInternalApi.getSubscriptionFromId(entitlement.getId(), false, (InternalTenantContext)this.internalCallContext);
        this.assertListenerStatus();
        DateTime block1Date = subscription.getStartDate().plus(delay);
        this.clock.setTime(block1Date);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state1 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), true, true, true, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state1, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(1);
        DateTime block2Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state2 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), false, false, false, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state2, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state3 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", KillbillService.KILLBILL_SERVICES.ENTITLEMENT_SERVICE.getServiceName(), true, true, true, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state3, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(3);
        this.assertListenerStatus();
        List events = List.copyOf(this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, null, (InternalCallContext)this.internalCallContext));
        if (delay.toPeriod().toStandardDuration().compareTo((ReadableDuration)Period.ZERO.toStandardDuration()) == 0) {
            Assert.assertEquals((int)events.size(), (int)0);
        } else {
            Assert.assertEquals((int)events.size(), (int)2);
            Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
            Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)subscription.getStartDate());
            Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
            Assert.assertEquals((Object)((BillingEvent)events.get(1)).getEffectiveDate(), (Object)block1Date);
        }
    }
}

