/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEventSet;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultBillingEventSet
extends JunctionTestSuiteNoDB {
    private Usage mockUsage(String name) {
        Usage usage = (Usage)Mockito.mock(Usage.class);
        Mockito.when((Object)usage.getName()).thenReturn((Object)name);
        return usage;
    }

    private BillingEvent createDefaultBillingEvent(String usageName) {
        try {
            List<Usage> usages = List.of(this.mockUsage(usageName));
            BillingEvent billingEvent = this.createEvent(this.subscription(UUID.randomUUID()), DateTime.now(), SubscriptionBaseTransitionType.CREATE);
            BillingEvent spied = (BillingEvent)Mockito.spy((Object)billingEvent);
            Mockito.when((Object)spied.getUsages()).thenReturn(usages);
            return spied;
        }
        catch (CatalogApiException e) {
            throw new RuntimeException("There's problem in test structure if this is happened.");
        }
    }

    @Test(groups={"fast"})
    public void getUsages() {
        BillingEvent e1 = this.createDefaultBillingEvent("A");
        BillingEvent e2 = this.createDefaultBillingEvent("B");
        BillingEvent e3 = this.createDefaultBillingEvent("C");
        DefaultBillingEventSet billingEventSet = new DefaultBillingEventSet(false, false, false);
        billingEventSet.addAll(List.of(e1, e2, e3));
        Map usages = billingEventSet.getUsages();
        Assert.assertNotNull((Object)usages);
        Assert.assertEquals((int)usages.size(), (int)3);
    }

    @Test(groups={"fast"})
    public void getUsagesWithCatalogApiException() {
        BillingEvent e1 = this.createDefaultBillingEvent("A");
        BillingEvent e2 = this.createDefaultBillingEvent("B");
        BillingEvent e3 = this.createDefaultBillingEvent("C");
        try {
            ((BillingEvent)Mockito.doAnswer(invocationOnMock -> {
                throw new CatalogApiException(ErrorCode.__UNKNOWN_ERROR_CODE, new Object[0]);
            }).when((Object)e3)).getUsages();
        }
        catch (CatalogApiException e) {
            throw new RuntimeException("There's problem in test structure if this is happened.");
        }
        DefaultBillingEventSet billingEventSet = new DefaultBillingEventSet(false, false, false);
        billingEventSet.addAll(List.of(e1, e2, e3));
        try {
            billingEventSet.getUsages();
            Assert.fail((String)"Error because in this test, e3.getUsages() modified to throw an exception");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to retrieve usage section for billing event"));
        }
    }
}

