/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogInternalApi;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.junction.BillingInternalApi;
import org.killbill.billing.junction.plumbing.billing.BlockingCalculator;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEventSet;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.killbill.billing.subscription.api.user.SubscriptionBillingEvent;
import org.killbill.billing.tag.TagInternalApi;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.bcd.BillCycleDayCalculator;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInternalBillingApi
implements BillingInternalApi {
    private static final Logger log = LoggerFactory.getLogger(DefaultInternalBillingApi.class);
    private static final int MAX_NB_EVENTS_TO_PRINT = 20;
    private final AccountInternalApi accountApi;
    private final SubscriptionBaseInternalApi subscriptionApi;
    private final CatalogInternalApi catalogInternalApi;
    private final BlockingCalculator blockCalculator;
    private final TagInternalApi tagApi;

    @Inject
    public DefaultInternalBillingApi(AccountInternalApi accountApi, SubscriptionBaseInternalApi subscriptionApi, BlockingCalculator blockCalculator, CatalogInternalApi catalogInternalApi, TagInternalApi tagApi) {
        this.accountApi = accountApi;
        this.subscriptionApi = subscriptionApi;
        this.catalogInternalApi = catalogInternalApi;
        this.blockCalculator = blockCalculator;
        this.tagApi = tagApi;
    }

    public BillingEventSet getBillingEventsForAccountAndUpdateAccountBCD(UUID accountId, DryRunArguments dryRunArguments, InternalCallContext context) throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        VersionedCatalog fullCatalog = this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)context);
        List tagsForAccount = this.tagApi.getTagsForAccount(false, (InternalTenantContext)context);
        List<Tag> accountTags = this.getTagsForObjectType(ObjectType.ACCOUNT, tagsForAccount, null);
        boolean found_AUTO_INVOICING_OFF = this.is_AUTO_INVOICING_OFF(accountTags);
        boolean found_INVOICING_DRAFT = this.is_AUTO_INVOICING_DRAFT(accountTags);
        boolean found_INVOICING_REUSE_DRAFT = this.is_AUTO_INVOICING_REUSE_DRAFT(accountTags);
        HashSet<UUID> skippedSubscriptions = new HashSet<UUID>();
        if (found_AUTO_INVOICING_OFF) {
            DefaultBillingEventSet result = new DefaultBillingEventSet(true, found_INVOICING_DRAFT, found_INVOICING_REUSE_DRAFT);
            log.info("Account is AUTO_INVOICING_OFF: no billing event for accountId='{}'", (Object)accountId);
            return result;
        }
        Map subscriptionsForAccount = this.subscriptionApi.getSubscriptionsForAccount(fullCatalog, (InternalTenantContext)context);
        List bundles = this.subscriptionApi.getBundlesForAccount(accountId, (InternalTenantContext)context);
        ImmutableAccountData account = this.accountApi.getImmutableAccountDataById(accountId, (InternalTenantContext)context);
        DefaultBillingEventSet result = new DefaultBillingEventSet(false, found_INVOICING_DRAFT, found_INVOICING_REUSE_DRAFT);
        this.addBillingEventsForBundles(bundles, account, dryRunArguments, context, result, skippedSubscriptions, subscriptionsForAccount, fullCatalog, tagsForAccount);
        if (result.isEmpty()) {
            log.info("No billing event for accountId='{}'", (Object)accountId);
            return result;
        }
        StringBuilder logStringBuilder = new StringBuilder("Computed billing events for accountId='").append(accountId).append("'");
        this.eventsToString(logStringBuilder, result);
        if (this.blockCalculator.insertBlockingEvents(result, skippedSubscriptions, subscriptionsForAccount, fullCatalog, (InternalTenantContext)context)) {
            logStringBuilder.append("\nBilling Events After Blocking");
            this.eventsToString(logStringBuilder, result);
        }
        log.info(logStringBuilder.toString());
        return result;
    }

    private void eventsToString(StringBuilder stringBuilder, SortedSet<BillingEvent> events) {
        int n = 0;
        for (BillingEvent event : events) {
            if (n > 20) {
                stringBuilder.append("\n").append(String.format("... and %s more ...", events.size() - n));
                break;
            }
            stringBuilder.append("\n").append(event.toString());
            ++n;
        }
    }

    private void addBillingEventsForBundles(List<SubscriptionBaseBundle> bundles, ImmutableAccountData account, DryRunArguments dryRunArguments, InternalCallContext context, DefaultBillingEventSet result, Set<UUID> skipSubscriptionsSet, Map<UUID, List<SubscriptionBase>> subscriptionsForAccount, VersionedCatalog catalog, List<Tag> tagsForAccount) throws AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        int currentAccountBCD = this.accountApi.getBCD((InternalTenantContext)context);
        this.addBillingEventsForBundles(bundles, account, dryRunArguments, context, result, skipSubscriptionsSet, subscriptionsForAccount, catalog, tagsForAccount, currentAccountBCD);
    }

    private void addBillingEventsForBundles(List<SubscriptionBaseBundle> bundles, ImmutableAccountData account, DryRunArguments dryRunArguments, InternalCallContext context, DefaultBillingEventSet result, Set<UUID> skipSubscriptionsSet, Map<UUID, List<SubscriptionBase>> subscriptionsForAccount, VersionedCatalog catalog, List<Tag> tagsForAccount, int currentAccountBCD) throws AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        if (dryRunArguments != null && dryRunArguments.getAction() == SubscriptionEventType.START_BILLING && dryRunArguments.getBundleId() == null) {
            UUID fakeBundleId = UUIDs.randomUUID();
            List subscriptions = this.subscriptionApi.getSubscriptionsForBundle(fakeBundleId, dryRunArguments, (InternalTenantContext)context);
            this.addBillingEventsForSubscription(account, subscriptions, null, currentAccountBCD, context, result, skipSubscriptionsSet, catalog);
        }
        for (SubscriptionBaseBundle bundle : bundles) {
            DryRunArguments dryRunArgumentsForBundle = dryRunArguments != null && dryRunArguments.getBundleId() != null && dryRunArguments.getBundleId().equals(bundle.getId()) ? dryRunArguments : null;
            List subscriptions = dryRunArgumentsForBundle == null || dryRunArgumentsForBundle.getAction() == null ? this.getSubscriptionsForAccountByBundleId(subscriptionsForAccount, bundle.getId()) : this.subscriptionApi.getSubscriptionsForBundle(bundle.getId(), dryRunArgumentsForBundle, (InternalTenantContext)context);
            List<Tag> bundleTags = this.getTagsForObjectType(ObjectType.BUNDLE, tagsForAccount, bundle.getId());
            boolean found_AUTO_INVOICING_OFF = this.is_AUTO_INVOICING_OFF(bundleTags);
            if (found_AUTO_INVOICING_OFF) {
                for (SubscriptionBase subscription : subscriptions) {
                    result.getSubscriptionIdsWithAutoInvoiceOff().add(subscription.getId());
                }
                continue;
            }
            SubscriptionBase baseSubscription = subscriptions != null && !subscriptions.isEmpty() ? (SubscriptionBase)subscriptions.get(0) : null;
            this.addBillingEventsForSubscription(account, subscriptions, baseSubscription, currentAccountBCD, context, result, skipSubscriptionsSet, catalog);
        }
        if (currentAccountBCD == 0) {
            boolean dryRunMode;
            Integer accountBCDCandidate = this.computeAccountBCD(result);
            if (accountBCDCandidate == null) {
                return;
            }
            result.clear();
            this.addBillingEventsForBundles(bundles, account, dryRunArguments, context, result, skipSubscriptionsSet, subscriptionsForAccount, catalog, tagsForAccount, accountBCDCandidate);
            boolean bl = dryRunMode = dryRunArguments != null;
            if (!dryRunMode) {
                log.info("Setting account BCD='{}', accountId='{}'", (Object)accountBCDCandidate, (Object)account.getId());
                this.accountApi.updateBCD(account.getExternalKey(), accountBCDCandidate.intValue(), context);
            }
        }
    }

    private Integer computeAccountBCD(BillingEventSet result) throws CatalogApiException {
        BillingEvent oldestAccountAlignedBillingEvent = null;
        for (BillingEvent event : result) {
            boolean hasUsage;
            if (event.getBillingAlignment() != BillingAlignment.ACCOUNT) continue;
            BigDecimal recurringPrice = event.getRecurringPrice();
            boolean hasRecurringPrice = recurringPrice != null;
            boolean bl = hasUsage = event.getUsages() != null && !event.getUsages().isEmpty();
            if (!hasRecurringPrice && !hasUsage || oldestAccountAlignedBillingEvent != null && event.getEffectiveDate().compareTo((ReadableInstant)oldestAccountAlignedBillingEvent.getEffectiveDate()) >= 0 && (event.getEffectiveDate().compareTo((ReadableInstant)oldestAccountAlignedBillingEvent.getEffectiveDate()) != 0 || event.getTotalOrdering().compareTo(oldestAccountAlignedBillingEvent.getTotalOrdering()) >= 0)) continue;
            oldestAccountAlignedBillingEvent = event;
        }
        if (oldestAccountAlignedBillingEvent == null) {
            return null;
        }
        int accountBCDCandidate = oldestAccountAlignedBillingEvent.getBillCycleDayLocal();
        Preconditions.checkState((accountBCDCandidate > 0 ? 1 : 0) != 0, (Object)("Wrong Account BCD calculation for event: " + oldestAccountAlignedBillingEvent));
        return accountBCDCandidate;
    }

    private void addBillingEventsForSubscription(ImmutableAccountData account, @Nullable List<SubscriptionBase> subscriptions, SubscriptionBase baseSubscription, int currentAccountBCD, InternalCallContext context, DefaultBillingEventSet result, Set<UUID> skipSubscriptionsSet, VersionedCatalog catalog) throws SubscriptionBaseApiException, CatalogApiException {
        if (subscriptions == null) {
            return;
        }
        HashMap<UUID, Integer> bcdCache = new HashMap<UUID, Integer>();
        for (SubscriptionBase subscription : subscriptions) {
            List billingTransitions = this.subscriptionApi.getSubscriptionBillingEvents(catalog, subscription, (InternalTenantContext)context);
            if (billingTransitions.isEmpty() || ((SubscriptionBillingEvent)billingTransitions.get(0)).getType() != SubscriptionBaseTransitionType.CREATE && ((SubscriptionBillingEvent)billingTransitions.get(0)).getType() != SubscriptionBaseTransitionType.TRANSFER) {
                log.warn("Skipping billing events for subscription " + subscription.getId() + ": Does not start with a valid CREATE transition");
                skipSubscriptionsSet.add(subscription.getId());
                return;
            }
            Integer overridenBCD = null;
            int bcdLocal = 0;
            BillingAlignment alignment = null;
            for (SubscriptionBillingEvent transition : billingTransitions) {
                if (transition.getType() != SubscriptionBaseTransitionType.CANCEL) {
                    PlanPhaseSpecifier spec = new PlanPhaseSpecifier(transition.getPlan().getName(), transition.getPlanPhase().getPhaseType());
                    alignment = subscription.getBillingAlignment(spec, transition.getEffectiveDate(), catalog);
                    overridenBCD = transition.getBcdLocal() != null ? transition.getBcdLocal() : overridenBCD;
                    bcdLocal = overridenBCD != null ? overridenBCD.intValue() : this.calculateBcdForTransition(alignment, bcdCache, baseSubscription, subscription, currentAccountBCD, (InternalTenantContext)context);
                }
                DefaultBillingEvent event = new DefaultBillingEvent(transition, subscription, bcdLocal, alignment, account.getCurrency());
                result.add(event);
            }
        }
    }

    private int calculateBcdForTransition(BillingAlignment realBillingAlignment, Map<UUID, Integer> bcdCache, SubscriptionBase baseSubscription, SubscriptionBase subscription, int accountBillCycleDayLocal, InternalTenantContext internalTenantContext) {
        BillingAlignment alignment = realBillingAlignment;
        if (alignment == BillingAlignment.ACCOUNT && accountBillCycleDayLocal == 0) {
            alignment = BillingAlignment.SUBSCRIPTION;
        }
        return BillCycleDayCalculator.calculateBcdForAlignment(bcdCache, (SubscriptionBase)subscription, (SubscriptionBase)baseSubscription, (BillingAlignment)alignment, (InternalTenantContext)internalTenantContext, (int)accountBillCycleDayLocal);
    }

    private boolean is_AUTO_INVOICING_OFF(List<Tag> tags) {
        return ControlTagType.isAutoInvoicingOff((Collection)Collections2.transform(tags, (Function)new Function<Tag, UUID>(){

            public UUID apply(Tag tag) {
                return tag.getTagDefinitionId();
            }
        }));
    }

    private boolean is_AUTO_INVOICING_DRAFT(List<Tag> tags) {
        return Iterables.any(tags, (Predicate)new Predicate<Tag>(){

            public boolean apply(Tag input) {
                return input.getTagDefinitionId().equals(ControlTagType.AUTO_INVOICING_DRAFT.getId());
            }
        });
    }

    private boolean is_AUTO_INVOICING_REUSE_DRAFT(List<Tag> tags) {
        return Iterables.any(tags, (Predicate)new Predicate<Tag>(){

            public boolean apply(Tag input) {
                return input.getTagDefinitionId().equals(ControlTagType.AUTO_INVOICING_REUSE_DRAFT.getId());
            }
        });
    }

    private List<Tag> getTagsForObjectType(final ObjectType objectType, List<Tag> tags, final @Nullable UUID objectId) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(tags, (Predicate)new Predicate<Tag>(){

            public boolean apply(Tag input) {
                if (objectId == null) {
                    return objectType == input.getObjectType();
                }
                return objectType == input.getObjectType() && objectId.equals(input.getObjectId());
            }
        }));
    }

    private List<SubscriptionBase> getSubscriptionsForAccountByBundleId(Map<UUID, List<SubscriptionBase>> subscriptionsForAccount, UUID bundleId) {
        return subscriptionsForAccount.containsKey(bundleId) ? subscriptionsForAccount.get(bundleId) : ImmutableList.of();
    }
}

