/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.SubscriptionBillingEvent;

public class DefaultBillingEvent
implements BillingEvent {
    private final UUID subscriptionId;
    private final UUID bundleId;
    private final int billCycleDayLocal;
    private final BillingAlignment billingAlignment;
    private final DateTime effectiveDate;
    private final PlanPhase planPhase;
    private final Plan plan;
    private final BillingPeriod billingPeriod;
    private final BigDecimal recurringPrice;
    private final BigDecimal fixedPrice;
    private final List<Usage> usages;
    private final Currency currency;
    private final String description;
    private final SubscriptionBaseTransitionType type;
    private final Long totalOrdering;
    private final boolean isCancelledOrBlocked;
    private final DateTime catalogEffectiveDate;

    public DefaultBillingEvent(SubscriptionBillingEvent inputEvent, SubscriptionBase subscription, int billCycleDayLocal, BillingAlignment billingAlignment, Currency currency) throws CatalogApiException {
        this.subscriptionId = subscription.getId();
        this.bundleId = subscription.getBundleId();
        this.isCancelledOrBlocked = inputEvent.getType() == SubscriptionBaseTransitionType.CANCEL;
        this.type = inputEvent.getType();
        this.plan = inputEvent.getPlan();
        this.planPhase = inputEvent.getPlanPhase();
        this.catalogEffectiveDate = inputEvent.getCatalogEffectiveDate();
        this.currency = currency;
        this.billCycleDayLocal = billCycleDayLocal;
        this.billingAlignment = billingAlignment;
        this.description = inputEvent.getType().toString();
        this.effectiveDate = inputEvent.getEffectiveDate();
        this.totalOrdering = inputEvent.getTotalOrdering();
        this.billingPeriod = DefaultBillingEvent.computeRecurringBillingPeriod(this.isCancelledOrBlocked, this.planPhase);
        this.fixedPrice = DefaultBillingEvent.computeFixedPrice(this.isCancelledOrBlocked, this.planPhase, currency, this.type);
        this.recurringPrice = DefaultBillingEvent.computeRecurringPrice(this.isCancelledOrBlocked, this.planPhase, currency);
        this.usages = DefaultBillingEvent.computeUsages(this.isCancelledOrBlocked, this.planPhase);
    }

    public DefaultBillingEvent(UUID subscriptionId, UUID bundleId, DateTime effectiveDate, Plan plan, PlanPhase planPhase, BigDecimal fixedPrice, BigDecimal recurringPrice, List<Usage> usages, Currency currency, BillingPeriod billingPeriod, int billCycleDayLocal, String description, long totalOrdering, SubscriptionBaseTransitionType type, boolean isDisableEvent) {
        this.subscriptionId = subscriptionId;
        this.bundleId = bundleId;
        this.catalogEffectiveDate = new DateTime((Object)plan.getCatalog().getEffectiveDate());
        this.effectiveDate = effectiveDate;
        this.isCancelledOrBlocked = isDisableEvent;
        this.plan = plan;
        this.planPhase = planPhase;
        this.billingPeriod = billingPeriod;
        this.fixedPrice = fixedPrice;
        this.recurringPrice = recurringPrice;
        this.usages = usages;
        this.currency = currency;
        this.billCycleDayLocal = billCycleDayLocal;
        this.description = description;
        this.type = type;
        this.totalOrdering = totalOrdering;
        this.billingAlignment = null;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public int getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public BillingAlignment getBillingAlignment() {
        return this.billingAlignment;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public PlanPhase getPlanPhase() {
        return this.planPhase;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public String getDescription() {
        return this.description;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public SubscriptionBaseTransitionType getTransitionType() {
        return this.type;
    }

    public Long getTotalOrdering() {
        return this.totalOrdering;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public BigDecimal getRecurringPrice() {
        return this.recurringPrice;
    }

    public List<Usage> getUsages() {
        return this.usages;
    }

    private static BigDecimal computeFixedPrice(boolean isCancelledOrBlocked, PlanPhase effectivePlanPhase, Currency currency, SubscriptionBaseTransitionType type) throws CatalogApiException {
        if (isCancelledOrBlocked || type == SubscriptionBaseTransitionType.BCD_CHANGE) {
            return null;
        }
        return effectivePlanPhase.getFixed() != null && effectivePlanPhase.getFixed().getPrice() != null ? effectivePlanPhase.getFixed().getPrice().getPrice(currency) : null;
    }

    private static BigDecimal computeRecurringPrice(boolean isCancelledOrBlocked, PlanPhase effectivePlanPhase, Currency currency) throws CatalogApiException {
        if (isCancelledOrBlocked) {
            return null;
        }
        return effectivePlanPhase.getRecurring() != null && effectivePlanPhase.getRecurring().getRecurringPrice() != null ? effectivePlanPhase.getRecurring().getRecurringPrice().getPrice(currency) : null;
    }

    private static BillingPeriod computeRecurringBillingPeriod(boolean isCancelledOrBlocked, PlanPhase effectivePlanPhase) {
        if (isCancelledOrBlocked) {
            return BillingPeriod.NO_BILLING_PERIOD;
        }
        return effectivePlanPhase.getRecurring() != null ? effectivePlanPhase.getRecurring().getBillingPeriod() : BillingPeriod.NO_BILLING_PERIOD;
    }

    private static List<Usage> computeUsages(boolean isCancelledOrBlocked, PlanPhase effectivePlanPhase) {
        if (isCancelledOrBlocked) {
            return ImmutableList.of();
        }
        ArrayList result = effectivePlanPhase.getUsages().length > 0 ? Lists.newArrayList() : ImmutableList.of();
        for (Usage usage : effectivePlanPhase.getUsages()) {
            result.add(usage);
        }
        return result;
    }

    public DateTime getCatalogEffectiveDate() {
        return this.catalogEffectiveDate;
    }

    public int compareTo(BillingEvent e1) {
        if (!this.subscriptionId.equals(e1.getSubscriptionId())) {
            return this.subscriptionId.compareTo(e1.getSubscriptionId());
        }
        if (!this.getEffectiveDate().equals((Object)e1.getEffectiveDate())) {
            return this.getEffectiveDate().compareTo((ReadableInstant)e1.getEffectiveDate());
        }
        if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
            if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
                return -1;
            }
            return 1;
        }
        if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
            if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
                return 1;
            }
            return -1;
        }
        if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
            if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
                return 1;
            }
            return -1;
        }
        if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
            if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
                return -1;
            }
            return 1;
        }
        return this.getTotalOrdering().compareTo(e1.getTotalOrdering());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBillingEvent that = (DefaultBillingEvent)o;
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.billCycleDayLocal != that.billCycleDayLocal) {
            return false;
        }
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.fixedPrice != null ? !this.fixedPrice.equals(that.fixedPrice) : that.fixedPrice != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.effectiveDate != null ? !this.effectiveDate.equals((Object)that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (this.plan != null ? !this.plan.equals(that.plan) : that.plan != null) {
            return false;
        }
        if (this.planPhase != null ? !this.planPhase.equals(that.planPhase) : that.planPhase != null) {
            return false;
        }
        if (this.totalOrdering != null ? !this.totalOrdering.equals(that.totalOrdering) : that.totalOrdering != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = 31 * this.billCycleDayLocal;
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.planPhase != null ? this.planPhase.hashCode() : 0);
        result = 31 * result + (this.plan != null ? this.plan.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.totalOrdering != null ? this.totalOrdering.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultBillingEvent");
        sb.append("{type=").append(this.type);
        sb.append(", effectiveDate=").append(this.effectiveDate);
        if (this.planPhase != null) {
            sb.append(", planPhaseName=").append(this.planPhase.getName());
        }
        sb.append(", subscriptionId=").append(this.subscriptionId);
        sb.append(", totalOrdering=").append(this.totalOrdering);
        sb.append('}');
        return sb.toString();
    }
}

