/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

class DisabledDuration
implements Comparable<DisabledDuration> {
    private final DateTime start;
    private DateTime end;

    public DisabledDuration(DateTime start, DateTime end) {
        this.start = start;
        this.end = end;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public void setEnd(DateTime end) {
        this.end = end;
    }

    @Override
    public int compareTo(DisabledDuration o) {
        int result = this.start.compareTo((ReadableInstant)o.getStart());
        if (result == 0) {
            if (this.end == null && o.getEnd() == null) {
                result = 0;
            } else if (this.end != null && o.getEnd() != null) {
                result = this.end.compareTo((ReadableInstant)o.getEnd());
            } else {
                if (o.getEnd() == null) {
                    return -1;
                }
                return 1;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisabledDuration)) {
            return false;
        }
        DisabledDuration that = (DisabledDuration)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        return result;
    }

    public boolean isDisjoint(DisabledDuration o) {
        return this.end != null && this.end.compareTo((ReadableInstant)o.getStart()) < 0;
    }

    public static DisabledDuration mergeDuration(DisabledDuration d1, DisabledDuration d2) {
        Preconditions.checkState((d1.getStart().compareTo((ReadableInstant)d2.getStart()) <= 0 ? 1 : 0) != 0);
        Preconditions.checkState((!d1.isDisjoint(d2) ? 1 : 0) != 0);
        DateTime endDate = d1.getEnd() != null && d2.getEnd() != null ? (d1.getEnd().compareTo((ReadableInstant)d2.getEnd()) < 0 ? d2.getEnd() : d1.getEnd()) : null;
        return new DisabledDuration(d1.getStart(), endDate);
    }
}

