/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.junction.plumbing.billing.DisabledDuration;

public class BlockingStateService {
    final Map<UUID, BlockingState> perObjectTypeFirstBlockingState = new HashMap<UUID, BlockingState>();
    private final List<DisabledDuration> result = new ArrayList<DisabledDuration>();

    public List<DisabledDuration> build() {
        for (BlockingState cur : this.perObjectTypeFirstBlockingState.values()) {
            if (cur == null) continue;
            this.addDisabledDuration(cur, null);
        }
        return this.result;
    }

    public void addBlockingState(BlockingState currentBlockingState) {
        BlockingState firstBlockingState = this.perObjectTypeFirstBlockingState.get(currentBlockingState.getBlockedId());
        if (currentBlockingState.isBlockBilling() && firstBlockingState == null) {
            this.perObjectTypeFirstBlockingState.put(currentBlockingState.getBlockedId(), currentBlockingState);
        } else if (!currentBlockingState.isBlockBilling() && firstBlockingState != null) {
            this.addDisabledDuration(firstBlockingState, currentBlockingState.getEffectiveDate());
            this.perObjectTypeFirstBlockingState.put(currentBlockingState.getBlockedId(), null);
        }
    }

    private void addDisabledDuration(BlockingState firstBlockingState, @Nullable DateTime disableDurationEndDate) {
        if (disableDurationEndDate == null || Days.daysBetween((ReadableInstant)firstBlockingState.getEffectiveDate(), (ReadableInstant)disableDurationEndDate).getDays() >= 1) {
            this.result.add(new DisabledDuration(firstBlockingState.getEffectiveDate(), disableDurationEndDate));
        }
    }
}

