/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.dao.MockBlockingStateDao;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.mock.MockEffectiveSubscriptionEvent;
import org.killbill.billing.mock.MockSubscription;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.DefaultSubscriptionBillingEvent;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.killbill.billing.subscription.api.user.SubscriptionBillingEvent;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.catalog.CatalogDateHelper;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.dao.MockTagDao;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestBillingApi
extends JunctionTestSuiteNoDB {
    private static final String DISABLED_BUNDLE = "disabled-bundle";
    private static final String CLEAR_BUNDLE = "clear-bundle";
    private static final UUID eventId = new UUID(0L, 0L);
    private static final UUID subId = new UUID(1L, 0L);
    private static final UUID bunId = new UUID(2L, 0L);
    private static final String bunKey = bunId.toString();
    private List<SubscriptionBillingEvent> billingTransitions;
    private List<EffectiveSubscriptionInternalEvent> effectiveSubscriptionTransitions;
    private SubscriptionBase subscription;
    private MockCatalog catalog;

    @Override
    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeMethod();
        SubscriptionBaseBundle bundle = (SubscriptionBaseBundle)Mockito.mock(SubscriptionBaseBundle.class);
        Mockito.when((Object)bundle.getId()).thenReturn((Object)bunId);
        ImmutableList bundles = ImmutableList.of((Object)bundle);
        this.billingTransitions = new LinkedList<SubscriptionBillingEvent>();
        this.effectiveSubscriptionTransitions = new LinkedList<EffectiveSubscriptionInternalEvent>();
        DateTime subscriptionStartDate = this.clock.getUTCNow().minusDays(3);
        this.subscription = new MockSubscription(subId, bunId, null, null, subscriptionStartDate, subscriptionStartDate);
        ImmutableList subscriptions = ImmutableList.of((Object)this.subscription);
        Mockito.when((Object)this.subscriptionInternalApi.getBundlesForAccount((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)bundles);
        Mockito.when((Object)this.subscriptionInternalApi.getSubscriptionsForBundle((UUID)Mockito.any(), (DryRunArguments)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)subscriptions);
        Mockito.when((Object)this.subscriptionInternalApi.getSubscriptionsForAccount((VersionedCatalog)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)ImmutableMap.builder().put((Object)bunId, (Object)subscriptions).build());
        Mockito.when((Object)this.subscriptionInternalApi.getSubscriptionFromId((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)this.subscription);
        Mockito.when((Object)this.subscriptionInternalApi.getBundleFromId((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)bundle);
        Mockito.when((Object)this.subscriptionInternalApi.getBaseSubscription((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)this.subscription);
        Mockito.when((Object)this.subscriptionInternalApi.getSubscriptionBillingEvents((VersionedCatalog)Mockito.any(), (SubscriptionBase)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn(this.billingTransitions);
        Mockito.when((Object)this.subscriptionInternalApi.getAllTransitions((SubscriptionBase)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn(this.effectiveSubscriptionTransitions);
        VersionedCatalog versionedCatalog = this.catalogService.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext);
        this.catalog = (MockCatalog)Iterables.getLast((Iterable)versionedCatalog.getVersions());
        Mockito.when((Object)this.catalogService.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext)).thenReturn((Object)versionedCatalog);
        ((MockSubscription)this.subscription).setBillingAlignment(BillingAlignment.ACCOUNT);
        ((MockBlockingStateDao)this.blockingStateDao).clear();
        ((MockTagDao)this.tagDao).clear();
    }

    @Test(groups={"fast"})
    public void testBillingEventsEmpty() throws AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(new UUID(0L, 0L), null, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testBillingEventsNoBillingPeriod() throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        DefaultPlan nextPlan = this.catalog.findPlan("3-PickupTrialEvergreen10USD");
        PlanPhase nextPhase = nextPlan.getAllPhases()[0];
        DateTime now = this.createSubscriptionCreationEvent((Plan)nextPlan, nextPhase);
        Account account = this.createAccount(10);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, (Plan)nextPlan, account.getBillCycleDayLocal(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsSubscriptionAligned() throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        DefaultPlan nextPlan = this.catalog.findPlan("3-PickupTrialEvergreen10USD");
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        DateTime now = this.createSubscriptionCreationEvent((Plan)nextPlan, nextPhase);
        Account account = this.createAccount(1);
        ((MockSubscription)this.subscription).setBillingAlignment(BillingAlignment.SUBSCRIPTION);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, (Plan)nextPlan, this.subscription.getStartDate().getDayOfMonth(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsAccountAligned() throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        DefaultPlan nextPlan = this.catalog.findPlan("3-PickupTrialEvergreen10USD");
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        DateTime now = this.createSubscriptionCreationEvent((Plan)nextPlan, nextPhase);
        Account account = this.createAccount(32);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, (Plan)nextPlan, 32, subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsBundleAligned() throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        DefaultPlan nextPlan = this.catalog.findPlan("7-Horn1USD");
        PlanPhase nextPhase = nextPlan.getAllPhases()[0];
        DateTime now = this.createSubscriptionCreationEvent((Plan)nextPlan, nextPhase);
        Account account = this.createAccount(1);
        ((MockSubscription)this.subscription).setPlan((Plan)this.catalog.findPlan("3-PickupTrialEvergreen10USD"));
        ((MockSubscription)this.subscription).setBillingAlignment(BillingAlignment.BUNDLE);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext);
        this.checkFirstEvent((SortedSet<BillingEvent>)events, (Plan)nextPlan, this.subscription.getStartDate().getDayOfMonth(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString());
    }

    @Test(groups={"fast"})
    public void testBillingEventsWithBlock() throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        DefaultPlan nextPlan = this.catalog.findPlan("3-PickupTrialEvergreen10USD");
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        DateTime now = this.createSubscriptionCreationEvent((Plan)nextPlan, nextPhase);
        Account account = this.createAccount(32);
        DefaultBlockingState blockingState1 = new DefaultBlockingState(bunId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1));
        DefaultBlockingState blockingState2 = new DefaultBlockingState(bunId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2));
        this.blockingStateDao.setBlockingStatesAndPostBlockingTransitionEvent((Map)ImmutableMap.of((Object)blockingState1, (Object)Optional.absent(), (Object)blockingState2, (Object)Optional.absent()), (InternalCallContext)this.internalCallContext);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)events.size(), (int)3);
        Iterator it = events.iterator();
        this.checkEvent((BillingEvent)it.next(), (Plan)nextPlan, account.getBillCycleDayLocal(), subId, now, nextPhase, SubscriptionBaseTransitionType.CREATE.toString(), nextPhase.getFixed().getPrice(), nextPhase.getRecurring().getRecurringPrice());
        this.checkEvent((BillingEvent)it.next(), (Plan)nextPlan, account.getBillCycleDayLocal(), subId, now.plusDays(1), nextPhase, SubscriptionBaseTransitionType.START_BILLING_DISABLED.toString(), null, null);
        this.checkEvent((BillingEvent)it.next(), (Plan)nextPlan, account.getBillCycleDayLocal(), subId, now.plusDays(2), nextPhase, SubscriptionBaseTransitionType.END_BILLING_DISABLED.toString(), nextPhase.getFixed().getPrice(), nextPhase.getRecurring().getRecurringPrice());
    }

    @Test(groups={"fast"})
    public void testBillingEventsAutoInvoicingOffAccount() throws CatalogApiException, AccountApiException, TagApiException, SubscriptionBaseApiException {
        DefaultPlan nextPlan = this.catalog.findPlan("3-PickupTrialEvergreen10USD");
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        this.createSubscriptionCreationEvent((Plan)nextPlan, nextPhase);
        Account account = this.createAccount(32);
        this.tagInternalApi.addTag(account.getId(), ObjectType.ACCOUNT, ControlTagType.AUTO_INVOICING_OFF.getId(), (InternalCallContext)this.internalCallContext);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((boolean)events.isAccountAutoInvoiceOff(), (boolean)true);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testBillingEventsAutoInvoicingOffBundle() throws CatalogApiException, AccountApiException, TagApiException, SubscriptionBaseApiException {
        DefaultPlan nextPlan = this.catalog.findPlan("3-PickupTrialEvergreen10USD");
        PlanPhase nextPhase = nextPlan.getAllPhases()[1];
        this.createSubscriptionCreationEvent((Plan)nextPlan, nextPhase);
        Account account = this.createAccount(32);
        this.tagInternalApi.addTag(bunId, ObjectType.BUNDLE, ControlTagType.AUTO_INVOICING_OFF.getId(), (InternalCallContext)this.internalCallContext);
        BillingEventSet events = this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)events.getSubscriptionIdsWithAutoInvoiceOff().size(), (int)1);
        Assert.assertEquals(events.getSubscriptionIdsWithAutoInvoiceOff().get(0), (Object)subId);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    private void checkFirstEvent(SortedSet<BillingEvent> events, Plan nextPlan, int BCD, UUID id, DateTime time, PlanPhase nextPhase, String desc) throws CatalogApiException {
        Assert.assertEquals((int)events.size(), (int)1);
        this.checkEvent(events.first(), nextPlan, BCD, id, time, nextPhase, desc, nextPhase.getFixed().getPrice(), nextPhase.getRecurring().getRecurringPrice());
    }

    private void checkEvent(BillingEvent event, Plan nextPlan, int BCD, UUID id, DateTime time, PlanPhase nextPhase, String desc, InternationalPrice fixedPrice, InternationalPrice recurringPrice) throws CatalogApiException {
        if (fixedPrice != null) {
            Assert.assertEquals((Object)fixedPrice.getPrice(Currency.USD), (Object)event.getFixedPrice());
        } else {
            Assert.assertNull((Object)event.getFixedPrice());
        }
        if (recurringPrice != null) {
            Assert.assertEquals((Object)recurringPrice.getPrice(Currency.USD), (Object)event.getRecurringPrice());
        } else {
            Assert.assertNull((Object)event.getRecurringPrice());
        }
        Assert.assertEquals((int)BCD, (int)event.getBillCycleDayLocal());
        Assert.assertEquals((Object)id, (Object)event.getSubscriptionId());
        Assert.assertEquals((int)time.getDayOfMonth(), (int)event.getEffectiveDate().getDayOfMonth());
        Assert.assertEquals((Object)nextPhase, (Object)event.getPlanPhase());
        Assert.assertEquals((Object)nextPlan, (Object)event.getPlan());
        if (!SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)event.getTransitionType())) {
            Assert.assertEquals((Object)nextPhase.getRecurring().getBillingPeriod(), (Object)event.getBillingPeriod());
        }
        Assert.assertEquals((String)desc, (String)event.getTransitionType().toString());
    }

    private Account createAccount(int billCycleDay) throws AccountApiException {
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getBillCycleDayLocal()).thenReturn((Object)billCycleDay);
        Mockito.when((Object)account.getCurrency()).thenReturn((Object)Currency.USD);
        Mockito.when((Object)account.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)DateTimeZone.UTC);
        Mockito.when((Object)this.accountInternalApi.getAccountById((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)account);
        Mockito.when((Object)this.accountInternalApi.getImmutableAccountDataById((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)account);
        Mockito.when((Object)this.accountInternalApi.getBCD((InternalTenantContext)Mockito.any())).thenReturn((Object)billCycleDay);
        return account;
    }

    private DateTime createSubscriptionCreationEvent(Plan nextPlan, PlanPhase nextPhase) throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        DateTime then = now.minusDays(1);
        MockEffectiveSubscriptionEvent t = new MockEffectiveSubscriptionEvent(eventId, subId, bunId, bunKey, then, now, null, null, null, null, null, Entitlement.EntitlementState.ACTIVE, nextPlan.getName(), nextPhase.getName(), nextPlan.getPriceList().getName(), null, Long.valueOf(1L), SubscriptionBaseTransitionType.CREATE, Integer.valueOf(1), null, Long.valueOf(1L), Long.valueOf(2L), null);
        this.effectiveSubscriptionTransitions.add((EffectiveSubscriptionInternalEvent)t);
        this.billingTransitions.add((SubscriptionBillingEvent)new DefaultSubscriptionBillingEvent(SubscriptionBaseTransitionType.CREATE, nextPlan, nextPhase, now, Long.valueOf(1L), null, CatalogDateHelper.toUTCDateTime((Date)nextPlan.getCatalog().getEffectiveDate())));
        return now;
    }
}

