/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.glue;

import com.google.inject.Module;
import org.killbill.billing.entitlement.api.svcs.DefaultInternalBlockingApi;
import org.killbill.billing.entitlement.block.BlockingChecker;
import org.killbill.billing.entitlement.block.MockBlockingChecker;
import org.killbill.billing.entitlement.dao.BlockingStateDao;
import org.killbill.billing.entitlement.dao.MockBlockingStateDao;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.junction.glue.DefaultJunctionModule;
import org.killbill.billing.mock.glue.MockEntitlementModule;
import org.killbill.billing.mock.glue.MockTenantModule;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.glue.CacheModule;
import org.killbill.billing.util.glue.CallContextModule;
import org.killbill.billing.util.glue.ConfigModule;
import org.killbill.billing.util.glue.KillBillShiroModule;
import org.killbill.billing.util.glue.SecurityModule;

public class TestJunctionModule
extends DefaultJunctionModule {
    public TestJunctionModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        super.configure();
        this.install((Module)new CacheModule(this.configSource));
        this.install((Module)new ConfigModule(this.configSource));
        this.install((Module)new CallContextModule(this.configSource));
        this.install((Module)new MockTenantModule(this.configSource));
        this.install((Module)new KillBillShiroModuleOnlyIniRealm(this.configSource));
        this.install((Module)new SecurityModule(this.configSource));
    }

    private static class KillBillShiroModuleOnlyIniRealm
    extends KillBillShiroModule {
        public KillBillShiroModuleOnlyIniRealm(KillbillConfigSource configSource) {
            super(configSource);
        }

        protected void configureJDBCRealm() {
        }

        protected void configureLDAPRealm() {
        }
    }

    public class MockEntitlementModuleForJunction
    extends MockEntitlementModule {
        public MockEntitlementModuleForJunction(KillbillConfigSource configSource) {
            super(configSource);
        }

        public void installBlockingApi() {
            this.bind(BlockingInternalApi.class).to(DefaultInternalBlockingApi.class).asEagerSingleton();
        }

        public void installBlockingStateDao() {
            this.bind(BlockingStateDao.class).to(MockBlockingStateDao.class).asEagerSingleton();
        }

        public void installBlockingChecker() {
            this.bind(BlockingChecker.class).to(MockBlockingChecker.class).asEagerSingleton();
        }
    }
}

