/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogInternalApi;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.events.SubscriptionInternalEvent;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.junction.BillingInternalApi;
import org.killbill.billing.junction.plumbing.billing.BlockingCalculator;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEventSet;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.killbill.billing.tag.TagInternalApi;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.bcd.BillCycleDayCalculator;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInternalBillingApi
implements BillingInternalApi {
    private static final Logger log = LoggerFactory.getLogger(DefaultInternalBillingApi.class);
    private final AccountInternalApi accountApi;
    private final SubscriptionBaseInternalApi subscriptionApi;
    private final CatalogInternalApi catalogInternalApi;
    private final BlockingCalculator blockCalculator;
    private final TagInternalApi tagApi;

    @Inject
    public DefaultInternalBillingApi(AccountInternalApi accountApi, SubscriptionBaseInternalApi subscriptionApi, BlockingCalculator blockCalculator, CatalogInternalApi catalogInternalApi, TagInternalApi tagApi) {
        this.accountApi = accountApi;
        this.subscriptionApi = subscriptionApi;
        this.catalogInternalApi = catalogInternalApi;
        this.blockCalculator = blockCalculator;
        this.tagApi = tagApi;
    }

    public BillingEventSet getBillingEventsForAccountAndUpdateAccountBCD(UUID accountId, DryRunArguments dryRunArguments, InternalCallContext context) throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        DefaultBillingEventSet result;
        Catalog fullCatalog = this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)context);
        List tagsForAccount = this.tagApi.getTagsForAccount(false, (InternalTenantContext)context);
        List<Tag> accountTags = this.getTagsForObjectType(ObjectType.ACCOUNT, tagsForAccount, null);
        boolean found_AUTO_INVOICING_OFF = this.is_AUTO_INVOICING_OFF(accountTags);
        boolean found_INVOICING_DRAFT = this.is_AUTO_INVOICING_DRAFT(accountTags);
        boolean found_INVOICING_REUSE_DRAFT = this.is_AUTO_INVOICING_REUSE_DRAFT(accountTags);
        HashSet<UUID> skippedSubscriptions = new HashSet<UUID>();
        if (found_AUTO_INVOICING_OFF) {
            result = new DefaultBillingEventSet(true, found_INVOICING_DRAFT, found_INVOICING_REUSE_DRAFT);
        } else {
            List bundles = this.subscriptionApi.getBundlesForAccount(accountId, (InternalTenantContext)context);
            ImmutableAccountData account = this.accountApi.getImmutableAccountDataById(accountId, (InternalTenantContext)context);
            result = new DefaultBillingEventSet(false, found_INVOICING_DRAFT, found_INVOICING_REUSE_DRAFT);
            this.addBillingEventsForBundles(bundles, account, dryRunArguments, context, result, skippedSubscriptions, fullCatalog, tagsForAccount);
        }
        if (result.isEmpty()) {
            log.info("No billing event for accountId='{}'", (Object)accountId);
            return result;
        }
        StringBuilder logStringBuilder = new StringBuilder("Computed billing events for accountId='").append(accountId).append("'");
        this.eventsToString(logStringBuilder, result);
        if (this.blockCalculator.insertBlockingEvents(result, skippedSubscriptions, fullCatalog, (InternalTenantContext)context)) {
            logStringBuilder.append("\nBilling Events After Blocking");
            this.eventsToString(logStringBuilder, result);
        }
        log.info(logStringBuilder.toString());
        return result;
    }

    private void eventsToString(StringBuilder stringBuilder, SortedSet<BillingEvent> events) {
        for (BillingEvent event : events) {
            stringBuilder.append("\n").append(event.toString());
        }
    }

    private void addBillingEventsForBundles(List<SubscriptionBaseBundle> bundles, ImmutableAccountData account, DryRunArguments dryRunArguments, InternalCallContext context, DefaultBillingEventSet result, Set<UUID> skipSubscriptionsSet, Catalog catalog, List<Tag> tagsForAccount) throws AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        boolean dryRunMode;
        boolean bl = dryRunMode = dryRunArguments != null;
        if (dryRunArguments != null && dryRunArguments.getAction() == SubscriptionEventType.START_BILLING && dryRunArguments.getBundleId() == null) {
            UUID fakeBundleId = UUIDs.randomUUID();
            List subscriptions = this.subscriptionApi.getSubscriptionsForBundle(fakeBundleId, dryRunArguments, (InternalTenantContext)context);
            this.addBillingEventsForSubscription(account, subscriptions, null, dryRunMode, context, result, skipSubscriptionsSet, catalog);
        }
        Map subscriptionsForAccount = this.subscriptionApi.getSubscriptionsForAccount(catalog, (InternalTenantContext)context);
        for (SubscriptionBaseBundle bundle : bundles) {
            DryRunArguments dryRunArgumentsForBundle = dryRunArguments != null && dryRunArguments.getBundleId() != null && dryRunArguments.getBundleId().equals(bundle.getId()) ? dryRunArguments : null;
            List subscriptions = dryRunArgumentsForBundle == null || dryRunArgumentsForBundle.getAction() == null ? this.getSubscriptionsForAccountByBundleId(subscriptionsForAccount, bundle.getId()) : this.subscriptionApi.getSubscriptionsForBundle(bundle.getId(), dryRunArgumentsForBundle, (InternalTenantContext)context);
            List<Tag> bundleTags = this.getTagsForObjectType(ObjectType.BUNDLE, tagsForAccount, bundle.getId());
            boolean found_AUTO_INVOICING_OFF = this.is_AUTO_INVOICING_OFF(bundleTags);
            if (found_AUTO_INVOICING_OFF) {
                for (SubscriptionBase subscription : subscriptions) {
                    result.getSubscriptionIdsWithAutoInvoiceOff().add(subscription.getId());
                }
                continue;
            }
            SubscriptionBase baseSubscription = subscriptions != null && !subscriptions.isEmpty() ? (SubscriptionBase)subscriptions.get(0) : null;
            this.addBillingEventsForSubscription(account, subscriptions, baseSubscription, dryRunMode, context, result, skipSubscriptionsSet, catalog);
        }
    }

    private void addBillingEventsForSubscription(ImmutableAccountData account, List<SubscriptionBase> subscriptions, SubscriptionBase baseSubscription, boolean dryRunMode, InternalCallContext context, DefaultBillingEventSet result, Set<UUID> skipSubscriptionsSet, Catalog catalog) throws AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        boolean updatedAccountBCD = dryRunMode;
        HashMap<UUID, Integer> bcdCache = new HashMap<UUID, Integer>();
        int currentAccountBCD = this.accountApi.getBCD(account.getId(), (InternalTenantContext)context);
        for (SubscriptionBase subscription : subscriptions) {
            List billingTransitions = this.subscriptionApi.getBillingTransitions(subscription, (InternalTenantContext)context);
            if (billingTransitions.isEmpty() || ((EffectiveSubscriptionInternalEvent)billingTransitions.get(0)).getTransitionType() != SubscriptionBaseTransitionType.CREATE && ((EffectiveSubscriptionInternalEvent)billingTransitions.get(0)).getTransitionType() != SubscriptionBaseTransitionType.TRANSFER) {
                log.warn("Skipping billing events for subscription " + subscription.getId() + ": Does not start with a valid CREATE transition");
                skipSubscriptionsSet.add(subscription.getId());
                return;
            }
            Integer overridenBCD = null;
            for (EffectiveSubscriptionInternalEvent transition : billingTransitions) {
                int bcdLocal;
                overridenBCD = transition.getNextBillCycleDayLocal() != null ? transition.getNextBillCycleDayLocal() : overridenBCD;
                int n = bcdLocal = overridenBCD != null ? overridenBCD.intValue() : this.calculateBcdForTransition(catalog, bcdCache, baseSubscription, subscription, currentAccountBCD, transition, (InternalTenantContext)context);
                if (currentAccountBCD == 0 && !updatedAccountBCD) {
                    log.info("Setting account BCD='{}', accountId='{}'", (Object)bcdLocal, (Object)account.getId());
                    this.accountApi.updateBCD(account.getExternalKey(), bcdLocal, context);
                    updatedAccountBCD = true;
                }
                DefaultBillingEvent event = new DefaultBillingEvent((SubscriptionInternalEvent)transition, subscription, bcdLocal, account.getCurrency(), catalog);
                result.add(event);
            }
        }
    }

    private int calculateBcdForTransition(Catalog catalog, Map<UUID, Integer> bcdCache, SubscriptionBase baseSubscription, SubscriptionBase subscription, int accountBillCycleDayLocal, EffectiveSubscriptionInternalEvent transition, InternalTenantContext internalTenantContext) throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        BillingAlignment alignment = catalog.billingAlignment(this.getPlanPhaseSpecifierFromTransition(catalog, (SubscriptionInternalEvent)transition), transition.getEffectiveTransitionTime(), subscription.getStartDate());
        return BillCycleDayCalculator.calculateBcdForAlignment(bcdCache, (SubscriptionBase)subscription, (SubscriptionBase)baseSubscription, (BillingAlignment)alignment, (InternalTenantContext)internalTenantContext, (int)accountBillCycleDayLocal);
    }

    private PlanPhaseSpecifier getPlanPhaseSpecifierFromTransition(Catalog catalog, SubscriptionInternalEvent transition) throws CatalogApiException {
        Plan prevPlan = transition.getPreviousPlan() != null ? catalog.findPlan(transition.getPreviousPlan(), transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
        Plan nextPlan = transition.getNextPlan() != null ? catalog.findPlan(transition.getNextPlan(), transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
        Plan plan = transition.getTransitionType() != SubscriptionBaseTransitionType.CANCEL ? nextPlan : prevPlan;
        PlanPhase prevPhase = prevPlan != null && transition.getPreviousPhase() != null ? prevPlan.findPhase(transition.getPreviousPhase()) : null;
        PlanPhase nextPhase = nextPlan != null && transition.getNextPhase() != null ? nextPlan.findPhase(transition.getNextPhase()) : null;
        PlanPhase phase = transition.getTransitionType() != SubscriptionBaseTransitionType.CANCEL ? nextPhase : prevPhase;
        return new PlanPhaseSpecifier(plan.getName(), phase.getPhaseType());
    }

    private boolean is_AUTO_INVOICING_OFF(List<Tag> tags) {
        return ControlTagType.isAutoInvoicingOff((Collection)Collections2.transform(tags, (Function)new Function<Tag, UUID>(){

            public UUID apply(Tag tag) {
                return tag.getTagDefinitionId();
            }
        }));
    }

    private boolean is_AUTO_INVOICING_DRAFT(List<Tag> tags) {
        return Iterables.any(tags, (Predicate)new Predicate<Tag>(){

            public boolean apply(Tag input) {
                return input.getTagDefinitionId().equals(ControlTagType.AUTO_INVOICING_DRAFT.getId());
            }
        });
    }

    private boolean is_AUTO_INVOICING_REUSE_DRAFT(List<Tag> tags) {
        return Iterables.any(tags, (Predicate)new Predicate<Tag>(){

            public boolean apply(Tag input) {
                return input.getTagDefinitionId().equals(ControlTagType.AUTO_INVOICING_REUSE_DRAFT.getId());
            }
        });
    }

    private List<Tag> getTagsForObjectType(final ObjectType objectType, List<Tag> tags, final @Nullable UUID objectId) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(tags, (Predicate)new Predicate<Tag>(){

            public boolean apply(Tag input) {
                if (objectId == null) {
                    return objectType == input.getObjectType();
                }
                return objectType == input.getObjectType() && objectId.equals(input.getObjectId());
            }
        }));
    }

    private List<SubscriptionBase> getSubscriptionsForAccountByBundleId(Map<UUID, List<SubscriptionBase>> subscriptionsForAccount, UUID bundleId) {
        return subscriptionsForAccount.containsKey(bundleId) ? subscriptionsForAccount.get(bundleId) : ImmutableList.of();
    }
}

