/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBillingEventSet
extends TreeSet<BillingEvent>
implements SortedSet<BillingEvent>,
BillingEventSet {
    private static final long serialVersionUID = 1L;
    private final boolean accountAutoInvoiceOff;
    private final boolean accountAutoInvoiceDraft;
    private final boolean accountAutoInvoiceReuseDraft;
    private final List<UUID> subscriptionIdsWithAutoInvoiceOff;

    public DefaultBillingEventSet(boolean accountAutoInvoiceOff, boolean accountAutoInvoiceDraft, boolean accountAutoInvoiceReuseDraft) {
        this.accountAutoInvoiceOff = accountAutoInvoiceOff;
        this.accountAutoInvoiceDraft = accountAutoInvoiceDraft;
        this.accountAutoInvoiceReuseDraft = accountAutoInvoiceReuseDraft;
        this.subscriptionIdsWithAutoInvoiceOff = new ArrayList<UUID>();
    }

    public boolean isAccountAutoInvoiceOff() {
        return this.accountAutoInvoiceOff;
    }

    public boolean isAccountAutoInvoiceDraft() {
        return this.accountAutoInvoiceDraft;
    }

    public boolean isAccountAutoInvoiceReuseDraft() {
        return this.accountAutoInvoiceReuseDraft;
    }

    public List<UUID> getSubscriptionIdsWithAutoInvoiceOff() {
        return this.subscriptionIdsWithAutoInvoiceOff;
    }

    public Map<String, Usage> getUsages() {
        Iterable allUsages = Iterables.concat((Iterable)Iterables.transform((Iterable)this, (Function)new Function<BillingEvent, List<Usage>>(){

            public List<Usage> apply(BillingEvent input) {
                return input.getUsages();
            }
        }));
        if (!allUsages.iterator().hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, Usage> result = new HashMap<String, Usage>();
        for (Usage cur : Sets.newHashSet((Iterable)allUsages)) {
            result.put(cur.getName(), cur);
        }
        return result;
    }

    @Override
    public String toString() {
        return "DefaultBillingEventSet [accountAutoInvoiceOff=" + this.accountAutoInvoiceOff + ", subscriptionIdsWithAutoInvoiceOff=" + this.subscriptionIdsWithAutoInvoiceOff + ", Events=" + super.toString() + "]";
    }
}

