/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.events.SubscriptionInternalEvent;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBillingEvent
implements BillingEvent {
    private final int billCycleDayLocal;
    private final SubscriptionBase subscription;
    private final DateTime effectiveDate;
    private final PlanPhase planPhase;
    private final Plan plan;
    private final BigDecimal fixedPrice;
    private final Currency currency;
    private final String description;
    private final BillingPeriod billingPeriod;
    private final SubscriptionBaseTransitionType type;
    private final Long totalOrdering;
    private final List<Usage> usages;
    private final Catalog catalog;
    private final boolean isDisableEvent;
    private final PlanPhase nextPlanPhase;
    private final DateTime catalogEffectiveDate;

    public DefaultBillingEvent(SubscriptionInternalEvent transition, SubscriptionBase subscription, int billCycleDayLocal, Currency currency, Catalog catalog) throws CatalogApiException {
        boolean isActive;
        boolean bl = isActive = transition.getTransitionType() != SubscriptionBaseTransitionType.CANCEL;
        if (isActive) {
            String planName = transition.getNextPlan();
            this.plan = planName != null ? catalog.findPlan(planName, transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
            String planPhaseName = transition.getNextPhase();
            this.nextPlanPhase = this.planPhase = planPhaseName != null && this.plan != null ? this.plan.findPhase(planPhaseName) : null;
            this.billingPeriod = this.getRecurringBillingPeriod(this.nextPlanPhase);
        } else {
            String planName = transition.getPreviousPlan();
            Plan prevPlan = this.plan = planName != null ? catalog.findPlan(planName, transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
            String planPhaseName = transition.getPreviousPhase();
            this.planPhase = planPhaseName != null && this.plan != null ? this.plan.findPhase(planPhaseName) : null;
            this.nextPlanPhase = null;
            String prevPhaseName = transition.getPreviousPhase();
            PlanPhase prevPlanPhase = prevPhaseName != null && prevPlan != null ? prevPlan.findPhase(prevPhaseName) : null;
            this.billingPeriod = this.getRecurringBillingPeriod(prevPlanPhase);
        }
        this.catalogEffectiveDate = this.plan == null ? null : new DateTime((Object)this.plan.getCatalog().getEffectiveDate());
        this.billCycleDayLocal = billCycleDayLocal;
        this.catalog = catalog;
        this.currency = currency;
        this.description = transition.getTransitionType().toString();
        this.effectiveDate = transition.getEffectiveTransitionTime();
        this.fixedPrice = transition.getTransitionType() != SubscriptionBaseTransitionType.BCD_CHANGE ? this.getFixedPrice(this.nextPlanPhase, currency) : null;
        this.isDisableEvent = false;
        this.subscription = subscription;
        this.totalOrdering = transition.getTotalOrdering();
        this.type = transition.getTransitionType();
        this.usages = this.initializeUsage(isActive);
    }

    public DefaultBillingEvent(SubscriptionBase subscription, DateTime effectiveDate, boolean isActive, Plan plan, PlanPhase planPhase, BigDecimal fixedPrice, Currency currency, BillingPeriod billingPeriod, int billCycleDayLocal, String description, long totalOrdering, SubscriptionBaseTransitionType type, Catalog catalog, boolean isDisableEvent) throws CatalogApiException {
        this.catalog = catalog;
        this.subscription = subscription;
        this.effectiveDate = effectiveDate;
        this.plan = plan;
        this.planPhase = planPhase;
        this.fixedPrice = fixedPrice;
        this.currency = currency;
        this.billingPeriod = billingPeriod;
        this.billCycleDayLocal = billCycleDayLocal;
        this.description = description;
        this.type = type;
        this.totalOrdering = totalOrdering;
        this.usages = this.initializeUsage(isActive);
        this.isDisableEvent = isDisableEvent;
        this.nextPlanPhase = isDisableEvent ? null : planPhase;
        this.catalogEffectiveDate = plan != null ? new DateTime((Object)plan.getCatalog().getEffectiveDate()) : null;
    }

    public int compareTo(BillingEvent e1) {
        if (!this.getSubscription().getId().equals(e1.getSubscription().getId())) {
            return this.getSubscription().getId().compareTo(e1.getSubscription().getId());
        }
        if (!this.getEffectiveDate().equals((Object)e1.getEffectiveDate())) {
            return this.getEffectiveDate().compareTo((ReadableInstant)e1.getEffectiveDate());
        }
        if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
            if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
                return -1;
            }
            return 1;
        }
        if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
            if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
                return 1;
            }
            return -1;
        }
        if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
            if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
                return 1;
            }
            return -1;
        }
        if (SubscriptionBaseTransitionType.END_BILLING_DISABLED.equals((Object)e1.getTransitionType())) {
            if (SubscriptionBaseTransitionType.START_BILLING_DISABLED.equals((Object)this.getTransitionType())) {
                return -1;
            }
            return 1;
        }
        return this.getTotalOrdering().compareTo(e1.getTotalOrdering());
    }

    public int getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public SubscriptionBase getSubscription() {
        return this.subscription;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public PlanPhase getPlanPhase() {
        return this.planPhase;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public BigDecimal getRecurringPrice(DateTime effectiveDate) throws CatalogApiException {
        if (this.isDisableEvent || this.nextPlanPhase == null) {
            return null;
        }
        PlanPhase effectivePlanPhase = effectiveDate != null ? this.catalog.findPhase(this.nextPlanPhase.getName(), effectiveDate, this.subscription.getStartDate()) : this.nextPlanPhase;
        return this.getRecurringPrice(effectivePlanPhase, this.currency);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public SubscriptionBaseTransitionType getTransitionType() {
        return this.type;
    }

    public Long getTotalOrdering() {
        return this.totalOrdering;
    }

    public List<Usage> getUsages() {
        return this.usages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultBillingEvent");
        sb.append("{type=").append(this.type);
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", planPhaseName=").append(this.planPhase.getName());
        sb.append(", subscriptionId=").append(this.subscription.getId());
        sb.append(", totalOrdering=").append(this.totalOrdering);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBillingEvent that = (DefaultBillingEvent)o;
        if (this.billCycleDayLocal != that.billCycleDayLocal) {
            return false;
        }
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.fixedPrice != null ? !this.fixedPrice.equals(that.fixedPrice) : that.fixedPrice != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.effectiveDate != null ? !this.effectiveDate.equals((Object)that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (this.plan != null ? !this.plan.equals(that.plan) : that.plan != null) {
            return false;
        }
        if (this.planPhase != null ? !this.planPhase.equals(that.planPhase) : that.planPhase != null) {
            return false;
        }
        if (this.subscription != null ? !this.subscription.equals(that.subscription) : that.subscription != null) {
            return false;
        }
        if (this.totalOrdering != null ? !this.totalOrdering.equals(that.totalOrdering) : that.totalOrdering != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = 31 * this.billCycleDayLocal;
        result = 31 * result + (this.subscription != null ? this.subscription.hashCode() : 0);
        result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.planPhase != null ? this.planPhase.hashCode() : 0);
        result = 31 * result + (this.plan != null ? this.plan.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.totalOrdering != null ? this.totalOrdering.hashCode() : 0);
        return result;
    }

    private BigDecimal getFixedPrice(@Nullable PlanPhase nextPhase, Currency currency) throws CatalogApiException {
        return nextPhase != null && nextPhase.getFixed() != null && nextPhase.getFixed().getPrice() != null ? nextPhase.getFixed().getPrice().getPrice(currency) : null;
    }

    private BigDecimal getRecurringPrice(@Nullable PlanPhase nextPhase, Currency currency) throws CatalogApiException {
        return nextPhase != null && nextPhase.getRecurring() != null && nextPhase.getRecurring().getRecurringPrice() != null ? nextPhase.getRecurring().getRecurringPrice().getPrice(currency) : null;
    }

    private BillingPeriod getRecurringBillingPeriod(@Nullable PlanPhase nextPhase) {
        if (nextPhase == null) {
            return BillingPeriod.NO_BILLING_PERIOD;
        }
        return nextPhase.getRecurring() != null ? nextPhase.getRecurring().getBillingPeriod() : BillingPeriod.NO_BILLING_PERIOD;
    }

    private List<Usage> initializeUsage(boolean isActive) {
        Object result = ImmutableList.of();
        if (!isActive) {
            return result;
        }
        if (this.planPhase != null && this.planPhase.getUsages().length > 0) {
            result = Lists.newArrayList();
            for (Usage usage : this.planPhase.getUsages()) {
                result.add(usage);
            }
        }
        return result;
    }

    public DateTime getCatalogEffectiveDate() {
        return this.catalogEffectiveDate;
    }
}

