/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.junction.plumbing.billing.DisabledDuration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDisabledDuration
extends JunctionTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testCompare0() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusHours(10));
        DisabledDuration d2 = new DisabledDuration(now, now.plusHours(10));
        Assert.assertEquals((int)d1.compareTo(d2), (int)0);
        Assert.assertTrue((boolean)d1.equals((Object)d2));
    }

    @Test(groups={"fast"})
    public void testCompare1() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusHours(10));
        DisabledDuration d2 = new DisabledDuration(now.plusSeconds(1), now.plusHours(10));
        Assert.assertEquals((int)d1.compareTo(d2), (int)-1);
        Assert.assertEquals((int)d2.compareTo(d1), (int)1);
    }

    @Test(groups={"fast"})
    public void testCompare2() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusHours(10));
        DisabledDuration d2 = new DisabledDuration(now.plusSeconds(1), now.plusHours(10));
        Assert.assertEquals((int)d1.compareTo(d2), (int)-1);
        Assert.assertEquals((int)d2.compareTo(d1), (int)1);
    }

    @Test(groups={"fast"})
    public void testCompare3() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(1));
        DisabledDuration d2 = new DisabledDuration(now, now.plusDays(2));
        Assert.assertEquals((int)d1.compareTo(d2), (int)-1);
        Assert.assertEquals((int)d2.compareTo(d1), (int)1);
    }

    @Test(groups={"fast"})
    public void testCompare4() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(1));
        DisabledDuration d2 = new DisabledDuration(now, null);
        Assert.assertEquals((int)d1.compareTo(d2), (int)-1);
        Assert.assertEquals((int)d2.compareTo(d1), (int)1);
    }

    @Test(groups={"fast"})
    public void testCompare5() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, null);
        DisabledDuration d2 = new DisabledDuration(now, now.plusDays(1));
        Assert.assertEquals((int)d1.compareTo(d2), (int)1);
        Assert.assertEquals((int)d2.compareTo(d1), (int)-1);
    }

    @Test(groups={"fast"})
    public void testDisjoint1() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(1));
        DisabledDuration d2 = new DisabledDuration(now, now.plusDays(2));
        Assert.assertFalse((boolean)d1.isDisjoint(d2));
    }

    @Test(groups={"fast"})
    public void testDisjoint2() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(1), now.plusDays(12));
        Assert.assertFalse((boolean)d1.isDisjoint(d2));
    }

    @Test(groups={"fast"})
    public void testDisjoint3() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(1), now.plusDays(4));
        Assert.assertFalse((boolean)d1.isDisjoint(d2));
    }

    @Test(groups={"fast"})
    public void testDisjoint4() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(10), now.plusDays(15));
        Assert.assertFalse((boolean)d1.isDisjoint(d2));
    }

    @Test(groups={"fast"})
    public void testDisjoint5() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(11), now.plusDays(15));
        Assert.assertTrue((boolean)d1.isDisjoint(d2));
    }

    @Test(groups={"fast"})
    public void testMergeDuration1() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(1), now.plusDays(15));
        DisabledDuration result = DisabledDuration.mergeDuration((DisabledDuration)d1, (DisabledDuration)d2);
        Assert.assertEquals((int)result.getStart().compareTo((ReadableInstant)now), (int)0);
        Assert.assertEquals((int)result.getEnd().compareTo((ReadableInstant)now.plusDays(15)), (int)0);
    }

    @Test(groups={"fast"})
    public void testMergeDuration2() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(15));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(1), now.plusDays(10));
        DisabledDuration result = DisabledDuration.mergeDuration((DisabledDuration)d1, (DisabledDuration)d2);
        Assert.assertEquals((int)result.getStart().compareTo((ReadableInstant)now), (int)0);
        Assert.assertEquals((int)result.getEnd().compareTo((ReadableInstant)now.plusDays(15)), (int)0);
    }

    @Test(groups={"fast"})
    public void testMergeDuration3() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, null);
        DisabledDuration d2 = new DisabledDuration(now.plusDays(1), now.plusDays(10));
        DisabledDuration result = DisabledDuration.mergeDuration((DisabledDuration)d1, (DisabledDuration)d2);
        Assert.assertEquals((int)result.getStart().compareTo((ReadableInstant)now), (int)0);
        Assert.assertNull((Object)result.getEnd());
    }

    @Test(groups={"fast"})
    public void testMergeDuration4() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(1), null);
        DisabledDuration result = DisabledDuration.mergeDuration((DisabledDuration)d1, (DisabledDuration)d2);
        Assert.assertEquals((int)result.getStart().compareTo((ReadableInstant)now), (int)0);
        Assert.assertNull((Object)result.getEnd());
    }

    @Test(groups={"fast"}, expectedExceptions={IllegalStateException.class})
    public void testMergeDurationInvalid1() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now, now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now.plusDays(11), null);
        DisabledDuration.mergeDuration((DisabledDuration)d1, (DisabledDuration)d2);
    }

    @Test(groups={"fast"}, expectedExceptions={IllegalStateException.class})
    public void testMergeDurationInvalid2() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DisabledDuration d1 = new DisabledDuration(now.plusDays(1), now.plusDays(10));
        DisabledDuration d2 = new DisabledDuration(now, null);
        DisabledDuration.mergeDuration((DisabledDuration)d1, (DisabledDuration)d2);
    }
}

