/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.DefaultEntitlementSpecifier;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteWithEmbeddedDB;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultInternalBillingApi
extends JunctionTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"}, description="Check blocking states with same effective date are correctly handled", invocationCount=10)
    public void testBlockingStatesWithSameEffectiveDate() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(7));
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        PlanPhaseSpecifier spec = new PlanPhaseSpecifier("Shotgun", BillingPeriod.MONTHLY, "DEFAULT", null);
        UUID entitlementId = this.entitlementApi.createBaseEntitlement(account.getId(), (EntitlementSpecifier)new DefaultEntitlementSpecifier(spec), account.getExternalKey(), null, null, false, true, (Iterable)ImmutableList.of(), (CallContext)this.callContext);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(entitlementId, (TenantContext)this.callContext);
        SubscriptionBase subscription = this.subscriptionInternalApi.getSubscriptionFromId(entitlement.getId(), (InternalTenantContext)this.internalCallContext);
        this.assertListenerStatus();
        DateTime block1Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state1 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", "entitlement-service", true, true, true, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state1, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state2 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR", "entitlement-service", false, false, false, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state2, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(5);
        DateTime block2Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state3 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_BLOCKED", "entitlement-service", true, true, true, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state3, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state4 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_CLEAR", "entitlement-service", false, false, false, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state4, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        DateTime block3Date = block2Date.plusDays(3);
        this.testListener.pushExpectedEvent(TestApiListener.NextEvent.PHASE);
        this.clock.addDays(50);
        this.assertListenerStatus();
        DateTime block4Date = this.clock.getUTCNow();
        DateTime block5Date = block4Date.plusDays(3);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state6 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_CLEAR-something", "entitlement-service", false, false, false, block5Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state6, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state5 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_BLOCKED-something", "entitlement-service", true, true, true, block4Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state5, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state7 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED-something2", "entitlement-service", true, true, true, block3Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state7, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state8 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR-something2", "entitlement-service", false, false, false, block4Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state8, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        this.clock.addDays(5);
        this.assertListenerStatus();
        ImmutableList events = ImmutableList.copyOf((Collection)this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext));
        Assert.assertEquals((int)events.size(), (int)3);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)subscription.getStartDate());
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getEffectiveDate(), (Object)block3Date);
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getEffectiveDate(), (Object)block5Date);
    }

    @Test(groups={"slow"}, description="Check unblock then block states with same effective date are correctly handled", invocationCount=10)
    public void testUnblockThenBlockBlockingStatesWithSameEffectiveDate() throws Exception {
        this.testUnblockThenBlockBlockingStatesWithSimilarEffectiveDate((ReadablePeriod)Seconds.ZERO);
    }

    @Test(groups={"slow"}, description="Check unblock then block states with almost the same effective date are correctly handled", invocationCount=10)
    public void testUnblockThenBlockBlockingStatesWithAlmostSameEffectiveDate() throws Exception {
        this.testUnblockThenBlockBlockingStatesWithSimilarEffectiveDate((ReadablePeriod)Seconds.ONE);
    }

    private void testUnblockThenBlockBlockingStatesWithSimilarEffectiveDate(ReadablePeriod delay) throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.createAccount(this.getAccountData(7));
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.CREATE, TestApiListener.NextEvent.BLOCK});
        PlanPhaseSpecifier spec = new PlanPhaseSpecifier("Shotgun", BillingPeriod.MONTHLY, "DEFAULT", null);
        UUID entitlementId = this.entitlementApi.createBaseEntitlement(account.getId(), (EntitlementSpecifier)new DefaultEntitlementSpecifier(spec), account.getExternalKey(), null, null, false, true, (Iterable)ImmutableList.of(), (CallContext)this.callContext);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(entitlementId, (TenantContext)this.callContext);
        SubscriptionBase subscription = this.subscriptionInternalApi.getSubscriptionFromId(entitlement.getId(), (InternalTenantContext)this.internalCallContext);
        this.assertListenerStatus();
        DateTime block1Date = subscription.getStartDate().plus(delay);
        this.clock.setTime(block1Date);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state1 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", "entitlement-service", true, true, true, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state1, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(1);
        DateTime block2Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state2 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR", "entitlement-service", false, false, false, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state2, (InternalCallContext)this.internalCallContext);
        DefaultBlockingState state3 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", "entitlement-service", true, true, true, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state3, (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(3);
        this.assertListenerStatus();
        ImmutableList events = ImmutableList.copyOf((Collection)this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), null, (InternalCallContext)this.internalCallContext));
        if (delay.toPeriod().toStandardDuration().compareTo((ReadableDuration)Period.ZERO.toStandardDuration()) == 0) {
            Assert.assertEquals((int)events.size(), (int)0);
        } else {
            Assert.assertEquals((int)events.size(), (int)2);
            Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
            Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)subscription.getStartDate());
            Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
            Assert.assertEquals((Object)((BillingEvent)events.get(1)).getEffectiveDate(), (Object)block1Date);
        }
    }
}

