/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.junction.plumbing.billing.BlockingStateService;
import org.killbill.billing.junction.plumbing.billing.DisabledDuration;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBlockingStateService
extends JunctionTestSuiteNoDB {
    private UUID accountId;
    private UUID bundleId;
    private UUID subscriptionId;

    @Override
    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.accountId = UUID.randomUUID();
        this.bundleId = UUID.randomUUID();
        this.subscriptionId = UUID.randomUUID();
    }

    @Test(groups={"fast"})
    public void testInterlaceTypes() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.SUBSCRIPTION_BUNDLE, true, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(2)));
        input.add(this.createBillingBlockingState(BlockingStateType.SUBSCRIPTION_BUNDLE, false, testInit.plusDays(3)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit, testInit.plusDays(2)), (Object)new DisabledDuration(testInit.plusDays(1), testInit.plusDays(3)));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testInterlaceTypesWithNoEnd() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.SUBSCRIPTION_BUNDLE, true, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(2)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit, testInit.plusDays(2)), (Object)new DisabledDuration(testInit.plusDays(1), null));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testMultipleDisabledDurations() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit.plusDays(2)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(3)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit, testInit.plusDays(1)), (Object)new DisabledDuration(testInit.plusDays(2), testInit.plusDays(3)));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testSameBlockingDates() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.SUBSCRIPTION_BUNDLE, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.SUBSCRIPTION_BUNDLE, false, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(2)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit, testInit.plusDays(1)), (Object)new DisabledDuration(testInit, testInit.plusDays(2)));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testSameBlockingUnblockingDates() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of();
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testBlockingUnblockingDatesLessThanADay1() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusHours(10)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of();
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testBlockingUnblockingDatesLessThanADay2() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit.plusDays(1)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit, testInit.plusDays(1)), (Object)new DisabledDuration(testInit.plusDays(1), null));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testBlockingUnblockingDatesLessThanADay3() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(1)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit, testInit.plusDays(1)));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testBlockingUnblockingDatesLessThanADay4() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, false, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit.plusDays(1)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit, testInit.plusDays(1)), (Object)new DisabledDuration(testInit.plusDays(1), null));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    @Test(groups={"fast"})
    public void testStartingWithUnblock() throws Exception {
        ArrayList<BlockingState> input = new ArrayList<BlockingState>();
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime testInit = new DateTime(2017, 4, 29, 14, 15, 53, tz);
        this.clock.setTime(testInit);
        input.add(this.createBillingBlockingState(BlockingStateType.SUBSCRIPTION_BUNDLE, false, testInit));
        input.add(this.createBillingBlockingState(BlockingStateType.ACCOUNT, true, testInit.plusDays(1)));
        input.add(this.createBillingBlockingState(BlockingStateType.SUBSCRIPTION_BUNDLE, true, testInit.plusDays(2)));
        BlockingStateService test = new BlockingStateService();
        for (BlockingState cur : input) {
            test.addBlockingState(cur);
        }
        List result = test.build();
        ImmutableList expected = ImmutableList.of((Object)new DisabledDuration(testInit.plusDays(2), null), (Object)new DisabledDuration(testInit.plusDays(1), null));
        this.verify(result, (List<DisabledDuration>)expected);
    }

    private void verify(List<DisabledDuration> actual, List<DisabledDuration> expected) {
        Assert.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < actual.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < expected.size(); ++j) {
                if (!actual.get(i).equals((Object)expected.get(j))) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    private BlockingState createBillingBlockingState(BlockingStateType type, boolean blockBilling, DateTime effectiveDate) {
        UUID blockedId;
        switch (type) {
            case ACCOUNT: {
                blockedId = this.accountId;
                break;
            }
            case SUBSCRIPTION_BUNDLE: {
                blockedId = this.bundleId;
                break;
            }
            case SUBSCRIPTION: {
                blockedId = this.subscriptionId;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpexted type");
            }
        }
        return new DefaultBlockingState(blockedId, type, UUID.randomUUID().toString(), "SVC", false, false, blockBilling, effectiveDate);
    }
}

