/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.dao.MockBlockingStateDao;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.junction.plumbing.billing.BlockingCalculator;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.junction.plumbing.billing.DisabledDuration;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestBlockingCalculator
extends JunctionTestSuiteNoDB {
    private static final String DISABLED_BUNDLE = "disabled-bundle";
    private static final String CLEAR_BUNDLE = "clear-bundle";
    private final UUID bundleId1 = UUID.randomUUID();
    private final UUID bundleId2 = UUID.randomUUID();
    private Account account;
    private SubscriptionBase subscription1;
    private SubscriptionBase subscription2;
    private SubscriptionBase subscription3;
    private SubscriptionBase subscription4;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeMethod();
        this.account = (Account)Mockito.mock(Account.class);
        this.subscription1 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        this.subscription2 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        this.subscription3 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        this.subscription4 = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)this.account.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription1.getBundleId()).thenReturn((Object)this.bundleId1);
        Mockito.when((Object)this.subscription2.getBundleId()).thenReturn((Object)this.bundleId1);
        Mockito.when((Object)this.subscription3.getBundleId()).thenReturn((Object)this.bundleId1);
        Mockito.when((Object)this.subscription4.getBundleId()).thenReturn((Object)this.bundleId2);
        Mockito.when((Object)this.subscription1.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription2.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription3.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.subscription4.getId()).thenReturn((Object)UUID.randomUUID());
        ((MockBlockingStateDao)this.blockingStateDao).clear();
    }

    @Test(groups={"fast"})
    public void testInsertBlockingEventsForBundle() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        BillingEvent A = this.createRealEvent(now.minusDays(1).minusHours(1), this.subscription1);
        BillingEvent B = this.createRealEvent(now.minusDays(1), this.subscription2);
        BillingEvent C = this.createRealEvent(now.plusDays(1), this.subscription2);
        BillingEvent D = this.createRealEvent(now.plusDays(3), this.subscription3);
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        billingEvents.add(A);
        billingEvents.add(B);
        billingEvents.add(C);
        billingEvents.add(D);
        DefaultBlockingState blockingState1 = new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now);
        DefaultBlockingState blockingState2 = new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2));
        this.blockingStateDao.setBlockingStatesAndPostBlockingTransitionEvent((Map)ImmutableMap.of((Object)blockingState1, (Object)Optional.absent(), (Object)blockingState2, (Object)Optional.absent()), (InternalCallContext)this.internalCallContext);
        this.blockingCalculator.insertBlockingEvents(billingEvents, new HashSet(), this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)billingEvents.size(), (int)7);
        SortedSet s1Events = this.blockingCalculator.filter(billingEvents, this.subscription1);
        Iterator it1 = s1Events.iterator();
        Assert.assertEquals(it1.next(), (Object)A);
        Assert.assertEquals((Object)((BillingEvent)it1.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)it1.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        SortedSet s2Events = this.blockingCalculator.filter(billingEvents, this.subscription2);
        Iterator it2 = s2Events.iterator();
        Assert.assertEquals(it2.next(), (Object)B);
        Assert.assertEquals((Object)((BillingEvent)it2.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)it2.next()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        SortedSet s3Events = this.blockingCalculator.filter(billingEvents, this.subscription3);
        Iterator it3 = s3Events.iterator();
        Assert.assertEquals(it3.next(), (Object)D);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveOpenPrev() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveOpenPrevFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e1);
        billingEvents.add(e2);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveOpenFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        BillingEvent e1 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e1);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e1);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveOpenSameTime() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        BillingEvent e1 = this.createRealEvent(now, this.subscription1);
        billingEvents.add(e1);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e1);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedPrev() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        billingEvents.add(e1);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedPrevBetw() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e1);
        billingEvents.add(e2);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedPrevBetwNext() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        BillingEvent e1 = this.createRealEvent(now.minusDays(1), this.subscription1);
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        BillingEvent e3 = this.createRealEvent(now.plusDays(3), this.subscription1);
        billingEvents.add(e1);
        billingEvents.add(e2);
        billingEvents.add(e3);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedBetwn() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        billingEvents.add(e2);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedBetweenFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        BillingEvent e2 = this.createRealEvent(now.plusDays(1), this.subscription1);
        BillingEvent e3 = this.createRealEvent(now.plusDays(3), this.subscription1);
        billingEvents.add(e2);
        billingEvents.add(e3);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results.first(), (Object)e2);
    }

    @Test(groups={"fast"})
    public void testEventsToRemoveClosedFollow() {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        BillingEvent e3 = this.createRealEvent(now.plusDays(3), this.subscription1);
        billingEvents.add(e3);
        SortedSet results = this.blockingCalculator.eventsToRemove(disabledDuration, billingEvents);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsOpenPrev() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsOpenPrevFollow() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsOpenFollow() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsOpenSameTime() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, null));
        billingEvents.add(this.createRealEvent(now, this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedPrev() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)2);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(null), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedPrevBetw() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)2);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(null), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedPrevBetwNext() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        billingEvents.add(this.createRealEvent(now.plusDays(3), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)2);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getEffectiveDate(), (Object)now);
        Assert.assertNull((Object)((BillingEvent)results.first()).getFixedPrice());
        Assert.assertNull((Object)((BillingEvent)results.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.first()).getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)((BillingEvent)results.first()).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(null), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedBetwn() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(null), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedBetweenFollow() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.plusDays(1), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)results.last()).getEffectiveDate(), (Object)now.plusDays(2));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getRecurringPrice(null), (Object)((BillingEvent)billingEvents.first()).getRecurringPrice(null));
        Assert.assertEquals((Object)((BillingEvent)results.last()).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
    }

    @Test(groups={"fast"})
    public void testCreateNewEventsClosedFollow() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        ArrayList<DisabledDuration> disabledDuration = new ArrayList<DisabledDuration>();
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        disabledDuration.add(new DisabledDuration(now, now.plusDays(2)));
        billingEvents.add(this.createRealEvent(now.plusDays(3), this.subscription1));
        SortedSet results = this.blockingCalculator.createNewEvents(disabledDuration, billingEvents, this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)results.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testPrecedingBillingEventForSubscription() {
        DateTime now = new DateTime();
        TreeSet<BillingEvent> events = new TreeSet<BillingEvent>();
        events.add(this.createRealEvent(now.minusDays(10), this.subscription1));
        events.add(this.createRealEvent(now.minusDays(6), this.subscription1));
        events.add(this.createRealEvent(now.minusDays(5), this.subscription1));
        events.add(this.createRealEvent(now.minusDays(1), this.subscription1));
        BillingEvent minus11 = this.blockingCalculator.precedingBillingEventForSubscription(now.minusDays(11), events);
        Assert.assertNull((Object)minus11);
        BillingEvent minus5andAHalf = this.blockingCalculator.precedingBillingEventForSubscription(now.minusDays(5).minusHours(12), events);
        Assert.assertNotNull((Object)minus5andAHalf);
        Assert.assertEquals((Object)minus5andAHalf.getEffectiveDate(), (Object)now.minusDays(6));
    }

    protected BillingEvent createRealEvent(DateTime effectiveDate, SubscriptionBase subscription) {
        return this.createRealEvent(effectiveDate, subscription, SubscriptionBaseTransitionType.CHANGE);
    }

    protected BillingEvent createRealEvent(DateTime effectiveDate, SubscriptionBase subscription, SubscriptionBaseTransitionType type) {
        try {
            Integer billCycleDay = 1;
            MockPlan plan = new MockPlan();
            Currency currency = Currency.USD;
            String description = "";
            BillingPeriod billingPeriod = BillingPeriod.MONTHLY;
            Long totalOrdering = 0L;
            DateTimeZone tz = DateTimeZone.UTC;
            PlanPhase planPhase = (PlanPhase)Mockito.mock(PlanPhase.class);
            InternationalPrice recurringPrice = (InternationalPrice)Mockito.mock(InternationalPrice.class);
            Mockito.when((Object)recurringPrice.getPrice((Currency)Mockito.any())).thenReturn((Object)BigDecimal.TEN);
            Recurring recurring = (Recurring)Mockito.mock(Recurring.class);
            Mockito.when((Object)recurring.getRecurringPrice()).thenReturn((Object)recurringPrice);
            Mockito.when((Object)planPhase.getRecurring()).thenReturn((Object)recurring);
            Mockito.when((Object)planPhase.getUsages()).thenReturn((Object)new DefaultUsage[0]);
            BigDecimal fixedPrice = BigDecimal.TEN;
            return new DefaultBillingEvent(subscription, effectiveDate, true, (Plan)plan, planPhase, fixedPrice, currency, billingPeriod, billCycleDay.intValue(), "", totalOrdering.longValue(), type, null, false);
        }
        catch (CatalogApiException e) {
            Assert.fail((String)"", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    @Test(groups={"fast"})
    public void testFilter() {
        TreeSet<BillingEvent> events = new TreeSet<BillingEvent>();
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription2));
        SortedSet result1 = this.blockingCalculator.filter(events, this.subscription1);
        SortedSet result2 = this.blockingCalculator.filter(events, this.subscription2);
        SortedSet result3 = this.blockingCalculator.filter(events, this.subscription3);
        Assert.assertEquals((int)result1.size(), (int)3);
        Assert.assertEquals((Object)((BillingEvent)result1.first()).getSubscription(), (Object)this.subscription1);
        Assert.assertEquals((Object)((BillingEvent)result1.last()).getSubscription(), (Object)this.subscription1);
        Assert.assertEquals((int)result2.size(), (int)1);
        Assert.assertEquals((Object)((BillingEvent)result2.first()).getSubscription(), (Object)this.subscription2);
        Assert.assertEquals((int)result3.size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testCreateNewDisableEvent() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        MockBillingEvent event = new MockBillingEvent();
        BillingEvent result = this.blockingCalculator.createNewDisableEvent(now, (BillingEvent)event, null);
        Assert.assertEquals((int)result.getBillCycleDayLocal(), (int)event.getBillCycleDayLocal());
        Assert.assertEquals((Object)result.getEffectiveDate(), (Object)now);
        Assert.assertEquals((Object)result.getPlanPhase(), (Object)event.getPlanPhase());
        Assert.assertEquals((Object)result.getPlan(), (Object)event.getPlan());
        Assert.assertNull((Object)result.getFixedPrice());
        Assert.assertNull((Object)result.getRecurringPrice(null));
        Assert.assertEquals((Object)result.getCurrency(), (Object)event.getCurrency());
        Assert.assertEquals((String)result.getDescription(), (String)"");
        Assert.assertEquals((Object)result.getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
        Assert.assertEquals((Object)result.getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)result.getTotalOrdering(), (Object)(BlockingCalculator.getGlobalTotalOrder().get() - 1L));
    }

    @Test(groups={"fast"})
    public void testCreateNewReenableEvent() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        MockBillingEvent event = new MockBillingEvent();
        BillingEvent result = this.blockingCalculator.createNewReenableEvent(now, (BillingEvent)event, null, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)result.getBillCycleDayLocal(), (int)event.getBillCycleDayLocal());
        Assert.assertEquals((Object)result.getEffectiveDate(), (Object)now);
        Assert.assertEquals((Object)result.getPlanPhase(), (Object)event.getPlanPhase());
        Assert.assertEquals((Object)result.getPlan(), (Object)event.getPlan());
        Assert.assertEquals((Object)result.getFixedPrice(), (Object)event.getFixedPrice());
        Assert.assertEquals((Object)result.getRecurringPrice(null), (Object)event.getRecurringPrice(null));
        Assert.assertEquals((Object)result.getCurrency(), (Object)event.getCurrency());
        Assert.assertEquals((String)result.getDescription(), (String)"");
        Assert.assertEquals((Object)result.getBillingPeriod(), (Object)event.getBillingPeriod());
        Assert.assertEquals((Object)result.getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)result.getTotalOrdering(), (Object)(BlockingCalculator.getGlobalTotalOrder().get() - 1L));
    }

    @Test(groups={"fast"})
    public void testCreateBundleSubscriptionMap() {
        TreeSet<BillingEvent> events = new TreeSet<BillingEvent>();
        events.add(this.createBillingEvent(this.subscription1));
        events.add(this.createBillingEvent(this.subscription2));
        events.add(this.createBillingEvent(this.subscription3));
        events.add(this.createBillingEvent(this.subscription4));
        Hashtable map = this.blockingCalculator.createBundleSubscriptionMap(events);
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((int)map.keySet().size(), (int)2);
        Assert.assertEquals((int)((List)map.get(this.bundleId1)).size(), (int)3);
        Assert.assertEquals((int)((List)map.get(this.bundleId2)).size(), (int)1);
    }

    private BillingEvent createBillingEvent(SubscriptionBase subscription) {
        BillingEvent result = (BillingEvent)Mockito.mock(BillingEvent.class);
        Mockito.when((Object)result.getSubscription()).thenReturn((Object)subscription);
        Mockito.when((Object)result.compareTo(Mockito.any())).thenReturn((Object)1);
        return result;
    }

    @Test(groups={"fast"})
    public void testCreateDisablePairs() {
        UUID ovdId = UUID.randomUUID();
        UUID ovdId2 = UUID.randomUUID();
        DateTime now = this.clock.getUTCNow();
        ArrayList<DefaultBlockingState> blockingEvents = new ArrayList<DefaultBlockingState>();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        List pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNull((Object)((DisabledDuration)pairs.get(0)).getEnd());
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(2));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(2));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(3)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(3));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(3)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(4)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getStart());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertNotNull((Object)((DisabledDuration)pairs.get(0)).getEnd());
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(4));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(3)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(3));
        blockingEvents = new ArrayList();
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(1)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(2)));
        blockingEvents.add(new DefaultBlockingState(ovdId2, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, now.plusDays(3)));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getStart(), (Object)now.plusDays(1));
        Assert.assertEquals((Object)((DisabledDuration)pairs.get(0)).getEnd(), (Object)now.plusDays(3));
    }

    @Test(groups={"fast"})
    public void testCreateAndMergeDisablePairs() {
        ArrayList<DefaultBlockingState> blockingEvents = new ArrayList<DefaultBlockingState>();
        UUID ovdId = UUID.randomUUID();
        DateTime entitlementStartDate = this.clock.getUTCNow();
        DateTime blockEffectiveDate = entitlementStartDate.plusSeconds(1);
        DateTime unblockEffectiveDate = blockEffectiveDate.plusDays(2);
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, entitlementStartDate));
        List pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)0);
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, blockEffectiveDate));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertEquals((int)((DisabledDuration)pairs.get(0)).getStart().compareTo((ReadableInstant)blockEffectiveDate), (int)0);
        Assert.assertNull((Object)((DisabledDuration)pairs.get(0)).getEnd());
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, unblockEffectiveDate));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertEquals((int)((DisabledDuration)pairs.get(0)).getStart().compareTo((ReadableInstant)blockEffectiveDate), (int)0);
        Assert.assertEquals((int)((DisabledDuration)pairs.get(0)).getEnd().compareTo((ReadableInstant)unblockEffectiveDate), (int)0);
        blockingEvents.add(new DefaultBlockingState(ovdId, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, unblockEffectiveDate));
        pairs = this.blockingCalculator.createBlockingDurations(blockingEvents);
        Assert.assertEquals((int)pairs.size(), (int)1);
        Assert.assertEquals((int)((DisabledDuration)pairs.get(0)).getStart().compareTo((ReadableInstant)blockEffectiveDate), (int)0);
        Assert.assertNull((Object)((DisabledDuration)pairs.get(0)).getEnd());
    }

    @Test(groups={"fast"})
    public void testSimpleWithClearBlockingDuration() throws Exception {
        BillingEvent trial = this.createRealEvent(new LocalDate(2012, 5, 1).toDateTimeAtStartOfDay(DateTimeZone.UTC), this.subscription1, SubscriptionBaseTransitionType.CREATE);
        BillingEvent phase = this.createRealEvent(new LocalDate(2012, 5, 31).toDateTimeAtStartOfDay(DateTimeZone.UTC), this.subscription1, SubscriptionBaseTransitionType.PHASE);
        BillingEvent upgrade = this.createRealEvent(new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC), this.subscription1, SubscriptionBaseTransitionType.CHANGE);
        TreeSet<BillingEvent> billingEvents = new TreeSet<BillingEvent>();
        billingEvents.add(trial);
        billingEvents.add(phase);
        billingEvents.add(upgrade);
        DefaultBlockingState blockingState1 = new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, false, false, new LocalDate(2012, 7, 5).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        DefaultBlockingState blockingState2 = new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, new LocalDate(2012, 7, 15).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        DefaultBlockingState blockingState3 = new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, DISABLED_BUNDLE, "test", true, true, true, new LocalDate(2012, 7, 24).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        DefaultBlockingState blockingState4 = new DefaultBlockingState(this.bundleId1, BlockingStateType.SUBSCRIPTION_BUNDLE, CLEAR_BUNDLE, "test", false, false, false, new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        this.blockingStateDao.setBlockingStatesAndPostBlockingTransitionEvent((Map)ImmutableMap.of((Object)blockingState1, (Object)Optional.absent(), (Object)blockingState2, (Object)Optional.absent(), (Object)blockingState3, (Object)Optional.absent(), (Object)blockingState4, (Object)Optional.absent()), (InternalCallContext)this.internalCallContext);
        this.blockingCalculator.insertBlockingEvents(billingEvents, new HashSet(), this.catalogInternalApi.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)billingEvents.size(), (int)5);
        ArrayList events = new ArrayList(billingEvents);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)new LocalDate(2012, 5, 1).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getEffectiveDate(), (Object)new LocalDate(2012, 5, 31).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.PHASE);
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getEffectiveDate(), (Object)new LocalDate(2012, 7, 15).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(3)).getEffectiveDate(), (Object)new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(3)).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(4)).getEffectiveDate(), (Object)new LocalDate(2012, 7, 25).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        Assert.assertEquals((Object)((BillingEvent)events.get(4)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CHANGE);
    }

    private class MockBillingEvent
    extends DefaultBillingEvent {
        public MockBillingEvent() throws CatalogApiException {
            super(TestBlockingCalculator.this.subscription1, TestBlockingCalculator.this.clock.getUTCNow(), true, null, null, BigDecimal.ZERO, Currency.USD, BillingPeriod.ANNUAL, 4, "", 3L, SubscriptionBaseTransitionType.CREATE, null, false);
        }
    }
}

