/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.junction.plumbing.billing.BlockingStateService;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.junction.plumbing.billing.DisabledDuration;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingCalculator {
    private static final AtomicLong globaltotalOrder = new AtomicLong();
    private final BlockingInternalApi blockingApi;

    @Inject
    public BlockingCalculator(BlockingInternalApi blockingApi) {
        this.blockingApi = blockingApi;
    }

    public boolean insertBlockingEvents(SortedSet<BillingEvent> billingEvents, Set<UUID> skippedSubscriptions, Catalog catalog, InternalTenantContext context) throws CatalogApiException {
        if (billingEvents.size() <= 0) {
            return false;
        }
        Hashtable<UUID, List<SubscriptionBase>> bundleMap = this.createBundleSubscriptionMap(billingEvents);
        TreeSet<BillingEvent> billingEventsToAdd = new TreeSet<BillingEvent>();
        TreeSet<BillingEvent> billingEventsToRemove = new TreeSet<BillingEvent>();
        List blockingEvents = this.blockingApi.getBlockingAllForAccount(catalog, context);
        Iterable accountBlockingEvents = Iterables.filter((Iterable)blockingEvents, (Predicate)new Predicate<BlockingState>(){

            public boolean apply(BlockingState input) {
                return BlockingStateType.ACCOUNT == input.getType();
            }
        });
        Map<UUID, List<BlockingState>> perBundleBlockingEvents = this.getPerTypeBlockingEvents(BlockingStateType.SUBSCRIPTION_BUNDLE, blockingEvents);
        Map<UUID, List<BlockingState>> perSubscriptionBlockingEvents = this.getPerTypeBlockingEvents(BlockingStateType.SUBSCRIPTION, blockingEvents);
        for (UUID bundleId : bundleMap.keySet()) {
            ImmutableList bundleBlockingEvents = perBundleBlockingEvents.get(bundleId) != null ? perBundleBlockingEvents.get(bundleId) : ImmutableList.of();
            for (SubscriptionBase subscription : bundleMap.get(bundleId)) {
                if (skippedSubscriptions.contains(subscription.getId())) continue;
                ImmutableList subscriptionBlockingEvents = perSubscriptionBlockingEvents.get(subscription.getId()) != null ? perSubscriptionBlockingEvents.get(subscription.getId()) : ImmutableList.of();
                List<BlockingState> aggregateSubscriptionBlockingEvents = this.getAggregateBlockingEventsPerSubscription(subscription.getEndDate(), (Iterable<BlockingState>)subscriptionBlockingEvents, (Iterable<BlockingState>)bundleBlockingEvents, accountBlockingEvents);
                List<DisabledDuration> accountBlockingDurations = this.createBlockingDurations(aggregateSubscriptionBlockingEvents);
                SortedSet<BillingEvent> subscriptionBillingEvents = this.filter(billingEvents, subscription);
                SortedSet<BillingEvent> newEvents = this.createNewEvents(accountBlockingDurations, subscriptionBillingEvents, catalog, context);
                billingEventsToAdd.addAll(newEvents);
                SortedSet<BillingEvent> removedEvents = this.eventsToRemove(accountBlockingDurations, subscriptionBillingEvents);
                billingEventsToRemove.addAll(removedEvents);
            }
        }
        for (BillingEvent eventToAdd : billingEventsToAdd) {
            billingEvents.add(eventToAdd);
        }
        for (BillingEvent eventToRemove : billingEventsToRemove) {
            billingEvents.remove(eventToRemove);
        }
        return !billingEventsToAdd.isEmpty() || !billingEventsToRemove.isEmpty();
    }

    final List<BlockingState> getAggregateBlockingEventsPerSubscription(final @Nullable DateTime subscriptionEndDate, Iterable<BlockingState> subscriptionBlockingEvents, Iterable<BlockingState> bundleBlockingEvents, Iterable<BlockingState> accountBlockingEvents) {
        Iterable tmp = Iterables.concat(subscriptionBlockingEvents, bundleBlockingEvents, accountBlockingEvents);
        Iterable allEventsPriorToCancelDate = Iterables.filter((Iterable)tmp, (Predicate)new Predicate<BlockingState>(){

            public boolean apply(BlockingState input) {
                return subscriptionEndDate == null || input.getEffectiveDate().compareTo((ReadableInstant)subscriptionEndDate) <= 0;
            }
        });
        ArrayList result = Lists.newArrayList((Iterable)allEventsPriorToCancelDate);
        Collections.sort(result);
        return result;
    }

    final Map<UUID, List<BlockingState>> getPerTypeBlockingEvents(final BlockingStateType type, List<BlockingState> blockingEvents) {
        Iterable bundleBlockingEvents = Iterables.filter(blockingEvents, (Predicate)new Predicate<BlockingState>(){

            public boolean apply(BlockingState input) {
                return type == input.getType();
            }
        });
        HashMap<UUID, List<BlockingState>> perTypeBlockingEvents = new HashMap<UUID, List<BlockingState>>();
        for (BlockingState cur : bundleBlockingEvents) {
            if (!perTypeBlockingEvents.containsKey(cur.getBlockedId())) {
                perTypeBlockingEvents.put(cur.getBlockedId(), new ArrayList());
            }
            ((List)perTypeBlockingEvents.get(cur.getBlockedId())).add(cur);
        }
        return perTypeBlockingEvents;
    }

    protected SortedSet<BillingEvent> eventsToRemove(List<DisabledDuration> disabledDuration, SortedSet<BillingEvent> subscriptionBillingEvents) {
        TreeSet<BillingEvent> result = new TreeSet<BillingEvent>();
        block0: for (DisabledDuration duration : disabledDuration) {
            for (BillingEvent event : subscriptionBillingEvents) {
                if (duration.getEnd() != null && !event.getEffectiveDate().isBefore((ReadableInstant)duration.getEnd())) continue block0;
                if (event.getEffectiveDate().isBefore((ReadableInstant)duration.getStart())) continue;
                result.add(event);
            }
        }
        return result;
    }

    protected SortedSet<BillingEvent> createNewEvents(List<DisabledDuration> disabledDuration, SortedSet<BillingEvent> subscriptionBillingEvents, Catalog catalog, InternalTenantContext context) throws CatalogApiException {
        Preconditions.checkState((context.getAccountRecordId() != null ? 1 : 0) != 0);
        TreeSet<BillingEvent> result = new TreeSet<BillingEvent>();
        for (DisabledDuration duration : disabledDuration) {
            BillingEvent precedingInitialEvent = this.precedingBillingEventForSubscription(duration.getStart(), subscriptionBillingEvents);
            BillingEvent precedingFinalEvent = this.precedingBillingEventForSubscription(duration.getEnd(), subscriptionBillingEvents);
            if (precedingInitialEvent != null) {
                result.add(this.createNewDisableEvent(duration.getStart(), precedingInitialEvent, catalog));
                if (duration.getEnd() == null) continue;
                result.add(this.createNewReenableEvent(duration.getEnd(), precedingFinalEvent, catalog, context));
                continue;
            }
            if (precedingFinalEvent == null) continue;
            result.add(this.createNewReenableEvent(duration.getEnd(), precedingFinalEvent, catalog, context));
        }
        return result;
    }

    protected BillingEvent precedingBillingEventForSubscription(DateTime disabledDurationStart, SortedSet<BillingEvent> subscriptionBillingEvents) {
        if (disabledDurationStart == null) {
            return null;
        }
        BillingEvent prev = null;
        for (BillingEvent event : subscriptionBillingEvents) {
            if (!event.getEffectiveDate().isBefore((ReadableInstant)disabledDurationStart)) {
                return prev;
            }
            prev = event;
        }
        return prev;
    }

    protected SortedSet<BillingEvent> filter(SortedSet<BillingEvent> billingEvents, SubscriptionBase subscription) {
        TreeSet<BillingEvent> result = new TreeSet<BillingEvent>();
        for (BillingEvent event : billingEvents) {
            if (!event.getSubscription().getId().equals(subscription.getId())) continue;
            result.add(event);
        }
        return result;
    }

    protected BillingEvent createNewDisableEvent(DateTime disabledDurationStart, BillingEvent previousEvent, Catalog catalog) throws CatalogApiException {
        int billCycleDay = previousEvent.getBillCycleDayLocal();
        SubscriptionBase subscription = previousEvent.getSubscription();
        DateTime effectiveDate = disabledDurationStart;
        PlanPhase planPhase = previousEvent.getPlanPhase();
        Plan plan = previousEvent.getPlan();
        BigDecimal fixedPrice = null;
        BillingPeriod billingPeriod = BillingPeriod.NO_BILLING_PERIOD;
        Currency currency = previousEvent.getCurrency();
        String description = "";
        SubscriptionBaseTransitionType type = SubscriptionBaseTransitionType.START_BILLING_DISABLED;
        Long totalOrdering = globaltotalOrder.getAndIncrement();
        return new DefaultBillingEvent(subscription, effectiveDate, true, plan, planPhase, fixedPrice, currency, billingPeriod, billCycleDay, "", totalOrdering, type, catalog, true);
    }

    protected BillingEvent createNewReenableEvent(DateTime odEventTime, BillingEvent previousEvent, Catalog catalog, InternalTenantContext context) throws CatalogApiException {
        int billCycleDay = previousEvent.getBillCycleDayLocal();
        SubscriptionBase subscription = previousEvent.getSubscription();
        DateTime effectiveDate = odEventTime;
        PlanPhase planPhase = previousEvent.getPlanPhase();
        BigDecimal fixedPrice = previousEvent.getFixedPrice();
        Plan plan = previousEvent.getPlan();
        Currency currency = previousEvent.getCurrency();
        String description = "";
        BillingPeriod billingPeriod = previousEvent.getBillingPeriod();
        SubscriptionBaseTransitionType type = SubscriptionBaseTransitionType.END_BILLING_DISABLED;
        Long totalOrdering = globaltotalOrder.getAndIncrement();
        return new DefaultBillingEvent(subscription, effectiveDate, true, plan, planPhase, fixedPrice, currency, billingPeriod, billCycleDay, "", totalOrdering, type, catalog, false);
    }

    protected Hashtable<UUID, List<SubscriptionBase>> createBundleSubscriptionMap(SortedSet<BillingEvent> billingEvents) {
        Hashtable<UUID, List<SubscriptionBase>> result = new Hashtable<UUID, List<SubscriptionBase>>();
        for (BillingEvent event : billingEvents) {
            UUID bundleId = event.getSubscription().getBundleId();
            List<SubscriptionBase> subs = result.get(bundleId);
            if (subs == null) {
                subs = new ArrayList<SubscriptionBase>();
                result.put(bundleId, subs);
            }
            if (result.get(bundleId).contains(event.getSubscription())) continue;
            subs.add(event.getSubscription());
        }
        return result;
    }

    protected List<DisabledDuration> createBlockingDurations(Iterable<BlockingState> inputBundleEvents) {
        ArrayList<DisabledDuration> result = new ArrayList<DisabledDuration>();
        ImmutableSet services = ImmutableSet.copyOf((Iterable)Iterables.transform(inputBundleEvents, (Function)new Function<BlockingState, String>(){

            public String apply(BlockingState input) {
                return input.getService();
            }
        }));
        HashMap<String, BlockingStateService> svcBlockedMap = new HashMap<String, BlockingStateService>();
        for (String svc : services) {
            svcBlockedMap.put(svc, new BlockingStateService());
        }
        for (BlockingState e : inputBundleEvents) {
            ((BlockingStateService)svcBlockedMap.get(e.getService())).addBlockingState(e);
        }
        Iterable unorderedDisabledDuration = Iterables.concat((Iterable)Iterables.transform(svcBlockedMap.values(), (Function)new Function<BlockingStateService, List<DisabledDuration>>(){

            public List<DisabledDuration> apply(BlockingStateService input) {
                return input.build();
            }
        }));
        List sortedDisabledDuration = Ordering.natural().sortedCopy(unorderedDisabledDuration);
        DisabledDuration prevDuration = null;
        for (DisabledDuration d : sortedDisabledDuration) {
            if (prevDuration == null) {
                prevDuration = d;
                continue;
            }
            if (prevDuration.isDisjoint(d)) {
                result.add(prevDuration);
                prevDuration = d;
                continue;
            }
            prevDuration = DisabledDuration.mergeDuration(prevDuration, d);
        }
        if (prevDuration != null) {
            result.add(prevDuration);
        }
        return result;
    }

    @VisibleForTesting
    static AtomicLong getGlobalTotalOrder() {
        return globaltotalOrder;
    }
}

