/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.GuicyKillbillTestSuiteWithEmbeddedDB;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultCatalogService;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entitlement.DefaultEntitlementService;
import org.killbill.billing.entitlement.EntitlementService;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.junction.BillingInternalApi;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.junction.glue.TestJunctionModuleWithEmbeddedDB;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.subscription.api.SubscriptionBaseService;
import org.killbill.billing.subscription.engine.core.DefaultSubscriptionBaseService;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.ClockMock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class JunctionTestSuiteWithEmbeddedDB
extends GuicyKillbillTestSuiteWithEmbeddedDB {
    protected static final Logger log = LoggerFactory.getLogger(JunctionTestSuiteWithEmbeddedDB.class);
    @Inject
    protected AccountUserApi accountApi;
    @Inject
    protected BlockingInternalApi blockingInternalApi;
    @Inject
    protected EntitlementApi entitlementApi;
    @Inject
    protected BillingInternalApi billingInternalApi;
    @Inject
    protected CatalogService catalogService;
    @Inject
    protected SubscriptionBaseInternalApi subscriptionInternalApi;
    @Inject
    protected PersistentBus bus;
    @Inject
    protected TestApiListener testListener;
    @Inject
    protected BusService busService;
    @Inject
    protected SubscriptionBaseService subscriptionBaseService;
    @Inject
    protected EntitlementService entitlementService;
    @Inject
    protected NonEntityDao nonEntityDao;
    @Inject
    protected InternalCallContextFactory internalCallContextFactory;
    protected Catalog catalog;

    protected KillbillConfigSource getConfigSource() {
        return this.getConfigSource("/junction.properties");
    }

    @BeforeClass(groups={"slow"})
    protected void beforeClass() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new TestJunctionModuleWithEmbeddedDB(this.configSource)});
        injector.injectMembers((Object)this);
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.startTestFamework();
        this.catalog = this.initCatalog(this.catalogService);
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.stopTestFramework();
    }

    private Catalog initCatalog(CatalogService catalogService) throws Exception {
        ((DefaultCatalogService)catalogService).loadCatalog();
        Catalog catalog = catalogService.getFullCatalog(true, true, (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)catalog);
        return catalog;
    }

    private void startTestFamework() throws Exception {
        log.debug("STARTING TEST FRAMEWORK");
        this.resetTestListener(this.testListener);
        this.resetClockToStartOfTest(this.clock);
        this.startBusAndRegisterListener(this.busService, this.testListener);
        this.restartSubscriptionService(this.subscriptionBaseService);
        this.restartEntitlementService(this.entitlementService);
        log.debug("STARTED TEST FRAMEWORK");
    }

    private void stopTestFramework() throws Exception {
        log.debug("STOPPING TEST FRAMEWORK");
        this.stopBusAndUnregisterListener(this.busService, this.testListener);
        this.stopSubscriptionService(this.subscriptionBaseService);
        this.stopEntitlementService(this.entitlementService);
        log.debug("STOPPED TEST FRAMEWORK");
    }

    private void resetTestListener(TestApiListener testListener) {
        if (testListener != null) {
            testListener.reset();
        }
    }

    private void resetClockToStartOfTest(ClockMock clock) {
        clock.resetDeltaFromReality();
        DateTime testStartDate = new DateTime(2012, 5, 7, 0, 3, 42, 0);
        clock.setDeltaFromReality(testStartDate.getMillis() - clock.getUTCNow().getMillis());
    }

    private void startBusAndRegisterListener(BusService busService, TestApiListener testListener) throws Exception {
        busService.getBus().start();
        busService.getBus().register((Object)testListener);
    }

    private void restartSubscriptionService(SubscriptionBaseService subscriptionBaseService) {
        ((DefaultSubscriptionBaseService)subscriptionBaseService).initialize();
        ((DefaultSubscriptionBaseService)subscriptionBaseService).start();
    }

    private void restartEntitlementService(EntitlementService entitlementService) {
        ((DefaultEntitlementService)entitlementService).initialize();
        ((DefaultEntitlementService)entitlementService).start();
    }

    private void stopBusAndUnregisterListener(BusService busService, TestApiListener testListener) throws Exception {
        busService.getBus().unregister((Object)testListener);
        busService.getBus().stop();
    }

    private void stopSubscriptionService(SubscriptionBaseService subscriptionBaseService) throws Exception {
        ((DefaultSubscriptionBaseService)subscriptionBaseService).stop();
    }

    private void stopEntitlementService(EntitlementService entitlementService) throws Exception {
        ((DefaultEntitlementService)entitlementService).stop();
    }

    protected AccountData getAccountData(int billingDay) {
        return new MockAccountBuilder().name(UUID.randomUUID().toString().substring(1, 8)).firstNameLength(6).email(UUID.randomUUID().toString().substring(1, 8)).phone(UUID.randomUUID().toString().substring(1, 8)).migrated(false).isNotifiedForInvoices(false).externalKey(UUID.randomUUID().toString().substring(1, 8)).billingCycleDayLocal(billingDay).currency(Currency.USD).paymentMethodId(UUID.randomUUID()).timeZone(DateTimeZone.UTC).build();
    }

    protected Account createAccount(AccountData accountData) throws AccountApiException {
        Account account = this.accountApi.createAccount(accountData, (CallContext)this.callContext);
        this.refreshCallContext(account.getId());
        return account;
    }

    protected void assertListenerStatus() {
        this.testListener.assertListenerStatus();
    }
}

