/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.junction.BillingInternalApi;
import org.killbill.billing.junction.plumbing.billing.BlockingCalculator;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEventSet;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.killbill.billing.tag.TagInternalApi;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.bcd.BillCycleDayCalculator;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInternalBillingApi
implements BillingInternalApi {
    private static final Logger log = LoggerFactory.getLogger(DefaultInternalBillingApi.class);
    private final AccountInternalApi accountApi;
    private final SubscriptionBaseInternalApi subscriptionApi;
    private final CatalogService catalogService;
    private final BlockingCalculator blockCalculator;
    private final TagInternalApi tagApi;

    @Inject
    public DefaultInternalBillingApi(AccountInternalApi accountApi, SubscriptionBaseInternalApi subscriptionApi, BlockingCalculator blockCalculator, CatalogService catalogService, TagInternalApi tagApi) {
        this.accountApi = accountApi;
        this.subscriptionApi = subscriptionApi;
        this.catalogService = catalogService;
        this.blockCalculator = blockCalculator;
        this.tagApi = tagApi;
    }

    public BillingEventSet getBillingEventsForAccountAndUpdateAccountBCD(UUID accountId, DryRunArguments dryRunArguments, InternalCallContext context) throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        DefaultBillingEventSet result;
        StaticCatalog currentCatalog = this.catalogService.getCurrentCatalog(true, true, (InternalTenantContext)context);
        List accountTags = this.tagApi.getTags(accountId, ObjectType.ACCOUNT, (InternalTenantContext)context);
        boolean found_AUTO_INVOICING_OFF = this.is_AUTO_INVOICING_OFF(accountTags);
        HashSet<UUID> skippedSubscriptions = new HashSet<UUID>();
        if (found_AUTO_INVOICING_OFF) {
            result = new DefaultBillingEventSet(true, currentCatalog.getRecurringBillingMode());
        } else {
            List bundles = this.subscriptionApi.getBundlesForAccount(accountId, (InternalTenantContext)context);
            ImmutableAccountData account = this.accountApi.getImmutableAccountDataById(accountId, (InternalTenantContext)context);
            result = new DefaultBillingEventSet(false, currentCatalog.getRecurringBillingMode());
            this.addBillingEventsForBundles(bundles, account, dryRunArguments, context, result, skippedSubscriptions);
        }
        if (result.isEmpty()) {
            log.info("No billing event for accountId='{}'", (Object)accountId);
            return result;
        }
        StringBuilder logStringBuilder = new StringBuilder("Computed billing events for accountId='").append(accountId).append("'");
        this.eventsToString(logStringBuilder, result);
        if (this.blockCalculator.insertBlockingEvents(result, skippedSubscriptions, (InternalTenantContext)context)) {
            logStringBuilder.append("\nBilling Events After Blocking");
            this.eventsToString(logStringBuilder, result);
        }
        log.info(logStringBuilder.toString());
        return result;
    }

    private void eventsToString(StringBuilder stringBuilder, SortedSet<BillingEvent> events) {
        for (BillingEvent event : events) {
            stringBuilder.append("\n").append(event.toString());
        }
    }

    private void addBillingEventsForBundles(List<SubscriptionBaseBundle> bundles, ImmutableAccountData account, DryRunArguments dryRunArguments, InternalCallContext context, DefaultBillingEventSet result, Set<UUID> skipSubscriptionsSet) throws AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        boolean dryRunMode;
        boolean bl = dryRunMode = dryRunArguments != null;
        if (dryRunArguments != null && dryRunArguments.getAction() == SubscriptionEventType.START_BILLING && dryRunArguments.getBundleId() == null) {
            UUID fakeBundleId = UUIDs.randomUUID();
            List subscriptions = this.subscriptionApi.getSubscriptionsForBundle(fakeBundleId, dryRunArguments, (InternalTenantContext)context);
            this.addBillingEventsForSubscription(account, subscriptions, null, dryRunMode, context, result, skipSubscriptionsSet);
        }
        for (SubscriptionBaseBundle bundle : bundles) {
            DryRunArguments dryRunArgumentsForBundle = dryRunArguments != null && dryRunArguments.getBundleId() != null && dryRunArguments.getBundleId().equals(bundle.getId()) ? dryRunArguments : null;
            List subscriptions = this.subscriptionApi.getSubscriptionsForBundle(bundle.getId(), dryRunArgumentsForBundle, (InternalTenantContext)context);
            List bundleTags = this.tagApi.getTags(bundle.getId(), ObjectType.BUNDLE, (InternalTenantContext)context);
            boolean found_AUTO_INVOICING_OFF = this.is_AUTO_INVOICING_OFF(bundleTags);
            if (found_AUTO_INVOICING_OFF) {
                for (SubscriptionBase subscription : subscriptions) {
                    result.getSubscriptionIdsWithAutoInvoiceOff().add(subscription.getId());
                }
                continue;
            }
            SubscriptionBase baseSubscription = !subscriptions.isEmpty() ? (SubscriptionBase)subscriptions.get(0) : null;
            this.addBillingEventsForSubscription(account, subscriptions, baseSubscription, dryRunMode, context, result, skipSubscriptionsSet);
        }
    }

    private void addBillingEventsForSubscription(ImmutableAccountData account, List<SubscriptionBase> subscriptions, SubscriptionBase baseSubscription, boolean dryRunMode, InternalCallContext context, DefaultBillingEventSet result, Set<UUID> skipSubscriptionsSet) throws AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        boolean updatedAccountBCD = dryRunMode;
        HashMap<UUID, Integer> bcdCache = new HashMap<UUID, Integer>();
        int currentAccountBCD = this.accountApi.getBCD(account.getId(), (InternalTenantContext)context);
        for (SubscriptionBase subscription : subscriptions) {
            List billingTransitions = this.subscriptionApi.getBillingTransitions(subscription, (InternalTenantContext)context);
            if (billingTransitions.isEmpty() || ((EffectiveSubscriptionInternalEvent)billingTransitions.get(0)).getTransitionType() != SubscriptionBaseTransitionType.CREATE && ((EffectiveSubscriptionInternalEvent)billingTransitions.get(0)).getTransitionType() != SubscriptionBaseTransitionType.TRANSFER) {
                log.warn("Skipping billing events for subscription " + subscription.getId() + ": Does not start with a valid CREATE transition");
                skipSubscriptionsSet.add(subscription.getId());
                return;
            }
            Catalog catalog = this.catalogService.getFullCatalog(true, true, (InternalTenantContext)context);
            Integer overridenBCD = null;
            for (EffectiveSubscriptionInternalEvent transition : billingTransitions) {
                int bcdLocal;
                overridenBCD = transition.getNextBillCycleDayLocal() != null ? transition.getNextBillCycleDayLocal() : overridenBCD;
                int n = bcdLocal = overridenBCD != null ? overridenBCD.intValue() : this.calculateBcdForTransition(catalog, bcdCache, baseSubscription, subscription, currentAccountBCD, transition, (InternalTenantContext)context);
                if (currentAccountBCD == 0 && !updatedAccountBCD) {
                    log.info("Setting account BCD='{}', accountId='{}'", (Object)bcdLocal, (Object)account.getId());
                    this.accountApi.updateBCD(account.getExternalKey(), bcdLocal, context);
                    updatedAccountBCD = true;
                }
                DefaultBillingEvent event = new DefaultBillingEvent(transition, subscription, bcdLocal, account.getCurrency(), catalog);
                result.add(event);
            }
        }
    }

    private int calculateBcdForTransition(Catalog catalog, Map<UUID, Integer> bcdCache, SubscriptionBase baseSubscription, SubscriptionBase subscription, int accountBillCycleDayLocal, EffectiveSubscriptionInternalEvent transition, InternalTenantContext internalTenantContext) throws CatalogApiException, AccountApiException, SubscriptionBaseApiException {
        BillingAlignment alignment = catalog.billingAlignment(this.getPlanPhaseSpecifierFromTransition(catalog, transition), transition.getEffectiveTransitionTime());
        return BillCycleDayCalculator.calculateBcdForAlignment(bcdCache, (SubscriptionBase)subscription, (SubscriptionBase)baseSubscription, (BillingAlignment)alignment, (InternalTenantContext)internalTenantContext, (int)accountBillCycleDayLocal);
    }

    private PlanPhaseSpecifier getPlanPhaseSpecifierFromTransition(Catalog catalog, EffectiveSubscriptionInternalEvent transition) throws CatalogApiException {
        Plan prevPlan = transition.getPreviousPlan() != null ? catalog.findPlan(transition.getPreviousPlan(), transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
        Plan nextPlan = transition.getNextPlan() != null ? catalog.findPlan(transition.getNextPlan(), transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
        Plan plan = transition.getTransitionType() != SubscriptionBaseTransitionType.CANCEL ? nextPlan : prevPlan;
        PlanPhase prevPhase = transition.getPreviousPhase() != null ? catalog.findPhase(transition.getPreviousPhase(), transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
        PlanPhase nextPhase = transition.getNextPhase() != null ? catalog.findPhase(transition.getNextPhase(), transition.getEffectiveTransitionTime(), transition.getSubscriptionStartDate()) : null;
        PlanPhase phase = transition.getTransitionType() != SubscriptionBaseTransitionType.CANCEL ? nextPhase : prevPhase;
        return new PlanPhaseSpecifier(plan.getName(), phase.getPhaseType());
    }

    private boolean is_AUTO_INVOICING_OFF(List<Tag> tags) {
        return ControlTagType.isAutoInvoicingOff((Collection)Collections2.transform(tags, (Function)new Function<Tag, UUID>(){

            @Nullable
            public UUID apply(@Nullable Tag tag) {
                return tag.getTagDefinitionId();
            }
        }));
    }
}

