/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingCalculator {
    private static final AtomicLong globaltotalOrder = new AtomicLong();
    private final BlockingInternalApi blockingApi;
    private final CatalogService catalogService;

    @Inject
    public BlockingCalculator(BlockingInternalApi blockingApi, CatalogService catalogService) {
        this.blockingApi = blockingApi;
        this.catalogService = catalogService;
    }

    public boolean insertBlockingEvents(SortedSet<BillingEvent> billingEvents, Set<UUID> skippedSubscriptions, InternalTenantContext context) throws CatalogApiException {
        if (billingEvents.size() <= 0) {
            return false;
        }
        Hashtable<UUID, List<SubscriptionBase>> bundleMap = this.createBundleSubscriptionMap(billingEvents);
        TreeSet<BillingEvent> billingEventsToAdd = new TreeSet<BillingEvent>();
        TreeSet<BillingEvent> billingEventsToRemove = new TreeSet<BillingEvent>();
        List blockingEvents = this.blockingApi.getBlockingAllForAccount(context);
        Iterable accountBlockingEvents = Iterables.filter((Iterable)blockingEvents, (Predicate)new Predicate<BlockingState>(){

            public boolean apply(BlockingState input) {
                return BlockingStateType.ACCOUNT == input.getType();
            }
        });
        Map<UUID, List<BlockingState>> perBundleBlockingEvents = this.getPerTypeBlockingEvents(BlockingStateType.SUBSCRIPTION_BUNDLE, blockingEvents);
        Map<UUID, List<BlockingState>> perSubscriptionBlockingEvents = this.getPerTypeBlockingEvents(BlockingStateType.SUBSCRIPTION, blockingEvents);
        for (UUID bundleId : bundleMap.keySet()) {
            ImmutableList bundleBlockingEvents = perBundleBlockingEvents.get(bundleId) != null ? perBundleBlockingEvents.get(bundleId) : ImmutableList.of();
            for (SubscriptionBase subscription : bundleMap.get(bundleId)) {
                if (skippedSubscriptions.contains(subscription.getId())) continue;
                ImmutableList subscriptionBlockingEvents = perSubscriptionBlockingEvents.get(subscription.getId()) != null ? perSubscriptionBlockingEvents.get(subscription.getId()) : ImmutableList.of();
                List<BlockingState> aggregateSubscriptionBlockingEvents = this.getAggregateBlockingEventsPerSubscription((Iterable<BlockingState>)subscriptionBlockingEvents, (Iterable<BlockingState>)bundleBlockingEvents, accountBlockingEvents);
                List<DisabledDuration> accountBlockingDurations = this.createBlockingDurations(aggregateSubscriptionBlockingEvents);
                billingEventsToAdd.addAll(this.createNewEvents(accountBlockingDurations, billingEvents, subscription, context));
                billingEventsToRemove.addAll(this.eventsToRemove(accountBlockingDurations, billingEvents, subscription));
            }
        }
        for (BillingEvent eventToAdd : billingEventsToAdd) {
            billingEvents.add(eventToAdd);
        }
        for (BillingEvent eventToRemove : billingEventsToRemove) {
            billingEvents.remove(eventToRemove);
        }
        return !billingEventsToAdd.isEmpty() || !billingEventsToRemove.isEmpty();
    }

    final List<BlockingState> getAggregateBlockingEventsPerSubscription(Iterable<BlockingState> subscriptionBlockingEvents, Iterable<BlockingState> bundleBlockingEvents, Iterable<BlockingState> accountBlockingEvents) {
        Iterable tmp = Iterables.concat(subscriptionBlockingEvents, bundleBlockingEvents, accountBlockingEvents);
        ArrayList result = Lists.newArrayList((Iterable)tmp);
        Collections.sort(result);
        return result;
    }

    final Map<UUID, List<BlockingState>> getPerTypeBlockingEvents(final BlockingStateType type, List<BlockingState> blockingEvents) {
        Iterable bundleBlockingEvents = Iterables.filter(blockingEvents, (Predicate)new Predicate<BlockingState>(){

            public boolean apply(BlockingState input) {
                return type == input.getType();
            }
        });
        HashMap<UUID, List<BlockingState>> perTypeBlockingEvents = new HashMap<UUID, List<BlockingState>>();
        for (BlockingState cur : bundleBlockingEvents) {
            if (!perTypeBlockingEvents.containsKey(cur.getBlockedId())) {
                perTypeBlockingEvents.put(cur.getBlockedId(), new ArrayList());
            }
            ((List)perTypeBlockingEvents.get(cur.getBlockedId())).add(cur);
        }
        return perTypeBlockingEvents;
    }

    protected SortedSet<BillingEvent> eventsToRemove(List<DisabledDuration> disabledDuration, SortedSet<BillingEvent> billingEvents, SubscriptionBase subscription) {
        TreeSet<BillingEvent> result = new TreeSet<BillingEvent>();
        SortedSet<BillingEvent> filteredBillingEvents = this.filter(billingEvents, subscription);
        block0: for (DisabledDuration duration : disabledDuration) {
            for (BillingEvent event : filteredBillingEvents) {
                if (duration.getEnd() != null && !event.getEffectiveDate().isBefore((ReadableInstant)duration.getEnd())) continue block0;
                if (!event.getEffectiveDate().isAfter((ReadableInstant)duration.getStart())) continue;
                result.add(event);
            }
        }
        return result;
    }

    protected SortedSet<BillingEvent> createNewEvents(List<DisabledDuration> disabledDuration, SortedSet<BillingEvent> billingEvents, SubscriptionBase subscription, InternalTenantContext context) throws CatalogApiException {
        TreeSet<BillingEvent> result = new TreeSet<BillingEvent>();
        Catalog catalog = this.catalogService.getFullCatalog(context);
        for (DisabledDuration duration : disabledDuration) {
            BillingEvent precedingInitialEvent = this.precedingBillingEventForSubscription(duration.getStart(), billingEvents, subscription);
            BillingEvent precedingFinalEvent = this.precedingBillingEventForSubscription(duration.getEnd(), billingEvents, subscription);
            if (precedingInitialEvent != null) {
                result.add(this.createNewDisableEvent(duration.getStart(), precedingInitialEvent, catalog, context));
                if (duration.getEnd() == null) continue;
                result.add(this.createNewReenableEvent(duration.getEnd(), precedingFinalEvent, catalog, context));
                continue;
            }
            if (precedingFinalEvent == null) continue;
            result.add(this.createNewReenableEvent(duration.getEnd(), precedingFinalEvent, catalog, context));
        }
        return result;
    }

    protected BillingEvent precedingBillingEventForSubscription(DateTime datetime, SortedSet<BillingEvent> billingEvents, SubscriptionBase subscription) {
        if (datetime == null) {
            return null;
        }
        SortedSet<BillingEvent> filteredBillingEvents = this.filter(billingEvents, subscription);
        BillingEvent result = filteredBillingEvents.first();
        if (datetime.isBefore((ReadableInstant)result.getEffectiveDate())) {
            return null;
        }
        for (BillingEvent event : filteredBillingEvents) {
            if (!event.getEffectiveDate().isBefore((ReadableInstant)datetime)) {
                return result;
            }
            result = event;
        }
        return result;
    }

    protected SortedSet<BillingEvent> filter(SortedSet<BillingEvent> billingEvents, SubscriptionBase subscription) {
        TreeSet<BillingEvent> result = new TreeSet<BillingEvent>();
        for (BillingEvent event : billingEvents) {
            if (event.getSubscription() != subscription) continue;
            result.add(event);
        }
        return result;
    }

    protected BillingEvent createNewDisableEvent(DateTime odEventTime, BillingEvent previousEvent, Catalog catalog, InternalTenantContext context) throws CatalogApiException {
        int billCycleDay = previousEvent.getBillCycleDayLocal();
        SubscriptionBase subscription = previousEvent.getSubscription();
        DateTime effectiveDate = odEventTime;
        PlanPhase planPhase = previousEvent.getPlanPhase();
        Plan plan = previousEvent.getPlan();
        BigDecimal fixedPrice = null;
        BillingPeriod billingPeriod = BillingPeriod.NO_BILLING_PERIOD;
        Currency currency = previousEvent.getCurrency();
        String description = "";
        SubscriptionBaseTransitionType type = SubscriptionBaseTransitionType.START_BILLING_DISABLED;
        Long totalOrdering = globaltotalOrder.getAndIncrement();
        DateTimeZone tz = previousEvent.getTimeZone();
        return new DefaultBillingEvent(subscription, effectiveDate, true, plan, planPhase, fixedPrice, currency, billingPeriod, billCycleDay, "", totalOrdering, type, tz, catalog, true);
    }

    protected BillingEvent createNewReenableEvent(DateTime odEventTime, BillingEvent previousEvent, Catalog catalog, InternalTenantContext context) throws CatalogApiException {
        int billCycleDay = previousEvent.getBillCycleDayLocal();
        SubscriptionBase subscription = previousEvent.getSubscription();
        DateTime effectiveDate = odEventTime;
        PlanPhase planPhase = previousEvent.getPlanPhase();
        BigDecimal fixedPrice = previousEvent.getFixedPrice();
        Plan plan = previousEvent.getPlan();
        Currency currency = previousEvent.getCurrency();
        String description = "";
        BillingPeriod billingPeriod = previousEvent.getBillingPeriod();
        SubscriptionBaseTransitionType type = SubscriptionBaseTransitionType.END_BILLING_DISABLED;
        Long totalOrdering = globaltotalOrder.getAndIncrement();
        DateTimeZone tz = previousEvent.getTimeZone();
        return new DefaultBillingEvent(subscription, effectiveDate, true, plan, planPhase, fixedPrice, currency, billingPeriod, billCycleDay, "", totalOrdering, type, tz, catalog, false);
    }

    protected Hashtable<UUID, List<SubscriptionBase>> createBundleSubscriptionMap(SortedSet<BillingEvent> billingEvents) {
        Hashtable<UUID, List<SubscriptionBase>> result = new Hashtable<UUID, List<SubscriptionBase>>();
        for (BillingEvent event : billingEvents) {
            UUID bundleId = event.getSubscription().getBundleId();
            List<SubscriptionBase> subs = result.get(bundleId);
            if (subs == null) {
                subs = new ArrayList<SubscriptionBase>();
                result.put(bundleId, subs);
            }
            if (result.get(bundleId).contains(event.getSubscription())) continue;
            subs.add(event.getSubscription());
        }
        return result;
    }

    protected List<DisabledDuration> createBlockingDurations(Iterable<BlockingState> overdueBundleEvents) {
        ArrayList<DisabledDuration> result = new ArrayList<DisabledDuration>();
        BlockingState first = null;
        int blockedNesting = 0;
        BlockingState lastOne = null;
        Iterator<BlockingState> i$ = overdueBundleEvents.iterator();
        while (i$.hasNext()) {
            BlockingState e;
            lastOne = e = i$.next();
            if (e.isBlockBilling() && blockedNesting == 0) {
                first = e;
                ++blockedNesting;
                continue;
            }
            if (e.isBlockBilling() && blockedNesting > 0) {
                ++blockedNesting;
                continue;
            }
            if (e.isBlockBilling() || blockedNesting <= 0 || --blockedNesting != 0) continue;
            this.addDisabledDuration(result, first, e);
            first = null;
        }
        if (first != null) {
            this.addDisabledDuration(result, first, lastOne.isBlockBilling() ? null : lastOne);
        }
        return result;
    }

    private void addDisabledDuration(List<DisabledDuration> result, BlockingState firstBlocking, @Nullable BlockingState firstNonBlocking) {
        DateTime endDate;
        DisabledDuration lastOne = !result.isEmpty() ? result.get(result.size() - 1) : null;
        DateTime startDate = firstBlocking.getEffectiveDate();
        DateTime dateTime = endDate = firstNonBlocking == null ? null : firstNonBlocking.getEffectiveDate();
        if (lastOne != null && lastOne.getEnd().compareTo((ReadableInstant)startDate) == 0) {
            lastOne.setEnd(endDate);
        } else if (endDate == null || Days.daysBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getDays() >= 1) {
            result.add(new DisabledDuration(startDate, endDate));
        }
    }

    @VisibleForTesting
    static AtomicLong getGlobalTotalOrder() {
        return globaltotalOrder;
    }

    protected static class DisabledDuration {
        private final DateTime start;
        private DateTime end;

        public DisabledDuration(DateTime start, DateTime end) {
            this.start = start;
            this.end = end;
        }

        public DateTime getStart() {
            return this.start;
        }

        public DateTime getEnd() {
            return this.end;
        }

        public void setEnd(DateTime end) {
            this.end = end;
        }
    }
}

