/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.junction.plumbing.billing.DefaultBillingEvent;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultBillingEvent
extends JunctionTestSuiteNoDB {
    private static final UUID ID_ZERO = new UUID(0L, 0L);
    private static final UUID ID_ONE = new UUID(0L, 1L);
    private static final UUID ID_TWO = new UUID(0L, 2L);

    @Test(groups={"fast"})
    public void testEntitlementEventsHappeningAtTheSameTimeAsOverdueEvents() throws Exception {
        BillingEvent event0 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        BillingEvent event1 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        BillingEvent event2 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:05.000Z"), SubscriptionBaseTransitionType.CHANGE);
        BillingEvent event3 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:05.000Z"), SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        TreeSet<BillingEvent> set = new TreeSet<BillingEvent>();
        set.add(event0);
        set.add(event1);
        set.add(event2);
        set.add(event3);
        Iterator it = set.iterator();
        Assert.assertEquals((Object)event1, it.next());
        Assert.assertEquals((Object)event0, it.next());
        Assert.assertEquals((Object)event3, it.next());
        Assert.assertEquals((Object)event2, it.next());
    }

    @Test(groups={"fast"})
    public void testEdgeCaseAllEventsHappenAtTheSameTime() throws Exception {
        BillingEvent event0 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        BillingEvent event1 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE, 1L);
        BillingEvent event2 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.CHANGE, 2L);
        BillingEvent event3 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:05.000Z"), SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        TreeSet<BillingEvent> set = new TreeSet<BillingEvent>();
        set.add(event0);
        set.add(event1);
        set.add(event2);
        set.add(event3);
        Iterator it = set.iterator();
        Assert.assertEquals((Object)event1, it.next());
        Assert.assertEquals((Object)event2, it.next());
        Assert.assertEquals((Object)event0, it.next());
        Assert.assertEquals((Object)event3, it.next());
    }

    @Test(groups={"fast"})
    public void testEventOrderingSubscription() {
        BillingEvent event0 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        BillingEvent event1 = this.createEvent(this.subscription(ID_ONE), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        BillingEvent event2 = this.createEvent(this.subscription(ID_TWO), new DateTime((Object)"2012-01-31T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        TreeSet<BillingEvent> set = new TreeSet<BillingEvent>();
        set.add(event2);
        set.add(event1);
        set.add(event0);
        Iterator it = set.iterator();
        Assert.assertEquals((Object)event0, it.next());
        Assert.assertEquals((Object)event1, it.next());
        Assert.assertEquals((Object)event2, it.next());
    }

    @Test(groups={"fast"})
    public void testEventOrderingDate() {
        BillingEvent event0 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        BillingEvent event1 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-02-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        BillingEvent event2 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-03-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        TreeSet<BillingEvent> set = new TreeSet<BillingEvent>();
        set.add(event2);
        set.add(event1);
        set.add(event0);
        Iterator it = set.iterator();
        Assert.assertEquals((Object)event0, it.next());
        Assert.assertEquals((Object)event1, it.next());
        Assert.assertEquals((Object)event2, it.next());
    }

    @Test(groups={"fast"})
    public void testEventTotalOrdering() {
        BillingEvent event0 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE, 1L);
        BillingEvent event1 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CANCEL, 2L);
        BillingEvent event2 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CANCEL, 3L);
        TreeSet<BillingEvent> set = new TreeSet<BillingEvent>();
        set.add(event2);
        set.add(event1);
        set.add(event0);
        Iterator it = set.iterator();
        Assert.assertEquals((Object)event0, it.next());
        Assert.assertEquals((Object)event1, it.next());
        Assert.assertEquals((Object)event2, it.next());
    }

    @Test(groups={"fast"})
    public void testEventOrderingMix() {
        BillingEvent event0 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CREATE);
        BillingEvent event1 = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-02T00:02:04.000Z"), SubscriptionBaseTransitionType.CHANGE);
        BillingEvent event2 = this.createEvent(this.subscription(ID_ONE), new DateTime((Object)"2012-01-01T00:02:04.000Z"), SubscriptionBaseTransitionType.CANCEL);
        TreeSet<BillingEvent> set = new TreeSet<BillingEvent>();
        set.add(event2);
        set.add(event1);
        set.add(event0);
        Iterator it = set.iterator();
        Assert.assertEquals((Object)event0, it.next());
        Assert.assertEquals((Object)event1, it.next());
        Assert.assertEquals((Object)event2, it.next());
    }

    @Test(groups={"fast"})
    public void testToString() throws Exception {
        BillingEvent event = this.createEvent(this.subscription(ID_ZERO), new DateTime((Object)"2012-01-01T00:02:04.000Z", DateTimeZone.UTC), SubscriptionBaseTransitionType.CREATE);
        Assert.assertEquals((String)event.toString(), (String)"DefaultBillingEvent{type=CREATE, effectiveDate=2012-01-01T00:02:04.000Z, planPhaseName=Test-trial, subscriptionId=00000000-0000-0000-0000-000000000000, totalOrdering=1}");
    }

    private BillingEvent createEvent(SubscriptionBase sub, DateTime effectiveDate, SubscriptionBaseTransitionType type) {
        return this.createEvent(sub, effectiveDate, type, 1L);
    }

    private BillingEvent createEvent(SubscriptionBase sub, DateTime effectiveDate, SubscriptionBaseTransitionType type, long totalOrdering) {
        boolean billCycleDay = true;
        MockPlan shotgun = new MockPlan();
        MockPlanPhase shotgunMonthly = this.createMockMonthlyPlanPhase(null, BigDecimal.ZERO, PhaseType.TRIAL);
        Account account = new MockAccountBuilder().build();
        return new DefaultBillingEvent(sub, effectiveDate, true, (Plan)shotgun, (PlanPhase)shotgunMonthly, BigDecimal.ZERO, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, "Test Event 1", totalOrdering, type, DateTimeZone.UTC, null, false);
    }

    private MockPlanPhase createMockMonthlyPlanPhase(@Nullable BigDecimal recurringRate, BigDecimal fixedRate, PhaseType phaseType) {
        return new MockPlanPhase(new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(recurringRate, Currency.USD)}), new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedRate, Currency.USD)}), BillingPeriod.MONTHLY, phaseType);
    }

    private SubscriptionBase subscription(UUID id) {
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getId()).thenReturn((Object)id);
        return subscription;
    }
}

