/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.junction.JunctionTestSuiteWithEmbeddedDB;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultInternalBillingApi
extends JunctionTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"}, description="Check blocking states with same effective date are correctly handled", invocationCount=10)
    public void testBlockingStatesWithSameEffectiveDate() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.accountApi.createAccount(this.getAccountData(7), this.callContext);
        InternalCallContext internalCallContext = this.internalCallContextFactory.createInternalCallContext(account.getId(), this.callContext);
        this.testListener.pushExpectedEvent(TestApiListener.NextEvent.CREATE);
        PlanPhaseSpecifier spec = new PlanPhaseSpecifier("Shotgun", ProductCategory.BASE, BillingPeriod.MONTHLY, "DEFAULT", null);
        Entitlement entitlement = this.entitlementApi.createBaseEntitlement(account.getId(), spec, account.getExternalKey(), initialDate, this.callContext);
        SubscriptionBase subscription = this.subscriptionInternalApi.getSubscriptionFromId(entitlement.getId(), (InternalTenantContext)internalCallContext);
        this.assertListenerStatus();
        DateTime block1Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state1 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", "entitlement-service", true, true, true, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state1, internalCallContext);
        DefaultBlockingState state2 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR", "entitlement-service", false, false, false, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state2, internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(5);
        DateTime block2Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state3 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_BLOCKED", "entitlement-service", true, true, true, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state3, internalCallContext);
        DefaultBlockingState state4 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_CLEAR", "entitlement-service", false, false, false, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state4, internalCallContext);
        this.assertListenerStatus();
        DateTime block3Date = block2Date.plusDays(3);
        this.testListener.pushExpectedEvent(TestApiListener.NextEvent.PHASE);
        this.clock.addDays(50);
        this.assertListenerStatus();
        DateTime block4Date = this.clock.getUTCNow();
        DateTime block5Date = block4Date.plusDays(3);
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state6 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_CLEAR-something", "entitlement-service", false, false, false, block5Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state6, internalCallContext);
        DefaultBlockingState state5 = new DefaultBlockingState(entitlement.getBundleId(), BlockingStateType.SUBSCRIPTION_BUNDLE, "ENT_BLOCKED-something", "entitlement-service", true, true, true, block4Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state5, internalCallContext);
        this.assertListenerStatus();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state7 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED-something2", "entitlement-service", true, true, true, block3Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state7, internalCallContext);
        DefaultBlockingState state8 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR-something2", "entitlement-service", false, false, false, block4Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state8, internalCallContext);
        this.assertListenerStatus();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        this.clock.addDays(5);
        this.assertListenerStatus();
        ImmutableList events = ImmutableList.copyOf((Collection)this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), internalCallContext));
        Assert.assertEquals((int)events.size(), (int)7);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)subscription.getStartDate());
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getEffectiveDate(), (Object)block1Date);
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(2)).getEffectiveDate(), (Object)block1Date);
        Assert.assertEquals((Object)((BillingEvent)events.get(3)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(3)).getEffectiveDate(), (Object)block2Date);
        Assert.assertEquals((Object)((BillingEvent)events.get(4)).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(4)).getEffectiveDate(), (Object)block2Date);
        Assert.assertEquals((Object)((BillingEvent)events.get(5)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(5)).getEffectiveDate(), (Object)block3Date);
        Assert.assertEquals((Object)((BillingEvent)events.get(6)).getTransitionType(), (Object)SubscriptionBaseTransitionType.END_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(6)).getEffectiveDate(), (Object)block5Date);
    }

    @Test(groups={"slow"}, description="Check unblock then block states with same effective date are correctly handled", invocationCount=10)
    public void testUnblockThenBlockBlockingStatesWithSameEffectiveDate() throws Exception {
        LocalDate initialDate = new LocalDate(2013, 8, 7);
        this.clock.setDay(initialDate);
        Account account = this.accountApi.createAccount(this.getAccountData(7), this.callContext);
        InternalCallContext internalCallContext = this.internalCallContextFactory.createInternalCallContext(account.getId(), this.callContext);
        this.testListener.pushExpectedEvent(TestApiListener.NextEvent.CREATE);
        PlanPhaseSpecifier spec = new PlanPhaseSpecifier("Shotgun", ProductCategory.BASE, BillingPeriod.MONTHLY, "DEFAULT", null);
        Entitlement entitlement = this.entitlementApi.createBaseEntitlement(account.getId(), spec, account.getExternalKey(), initialDate, this.callContext);
        SubscriptionBase subscription = this.subscriptionInternalApi.getSubscriptionFromId(entitlement.getId(), (InternalTenantContext)internalCallContext);
        this.assertListenerStatus();
        DateTime block1Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state1 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", "entitlement-service", true, true, true, block1Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state1, internalCallContext);
        this.clock.addDays(1);
        DateTime block2Date = this.clock.getUTCNow();
        this.testListener.pushExpectedEvents(new TestApiListener.NextEvent[]{TestApiListener.NextEvent.BLOCK, TestApiListener.NextEvent.BLOCK});
        DefaultBlockingState state2 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_CLEAR", "entitlement-service", false, false, false, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state2, internalCallContext);
        DefaultBlockingState state3 = new DefaultBlockingState(account.getId(), BlockingStateType.ACCOUNT, "ENT_BLOCKED", "entitlement-service", true, true, true, block2Date);
        this.blockingInternalApi.setBlockingState((BlockingState)state3, internalCallContext);
        this.assertListenerStatus();
        this.clock.addDays(3);
        this.assertListenerStatus();
        ImmutableList events = ImmutableList.copyOf((Collection)this.billingInternalApi.getBillingEventsForAccountAndUpdateAccountBCD(account.getId(), internalCallContext));
        Assert.assertEquals((int)events.size(), (int)2);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getTransitionType(), (Object)SubscriptionBaseTransitionType.CREATE);
        Assert.assertEquals((Object)((BillingEvent)events.get(0)).getEffectiveDate(), (Object)subscription.getStartDate());
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getTransitionType(), (Object)SubscriptionBaseTransitionType.START_BILLING_DISABLED);
        Assert.assertEquals((Object)((BillingEvent)events.get(1)).getEffectiveDate(), (Object)block1Date);
    }
}

